/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;

public class Ipv4AddressNoZone
extends Ipv4Address
implements Serializable {
    private static final long serialVersionUID = 5968212092585493753L;
    private static final Pattern[] patterns;
    public static final List<String> PATTERN_CONSTANTS;

    @ConstructorProperties(value={"value"})
    public Ipv4AddressNoZone(String _value) {
        super(_value);
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        for (Pattern p : patterns) {
            Preconditions.checkArgument((boolean)p.matcher(_value).matches(), (String)"Supplied value \"%s\" does not match required pattern \"%s\"", (Object)_value, (Object)p);
        }
    }

    public Ipv4AddressNoZone(Ipv4AddressNoZone source) {
        super(source);
    }

    public Ipv4AddressNoZone(Ipv4Address source) {
        super(source);
    }

    public static Ipv4AddressNoZone getDefaultInstance(String defaultValue) {
        return new Ipv4AddressNoZone(defaultValue);
    }

    static {
        PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:[0-9\\.]*)$");
        Pattern[] a = new Pattern[PATTERN_CONSTANTS.size()];
        int i = 0;
        for (String regEx : PATTERN_CONSTANTS) {
            a[i++] = Pattern.compile(regEx);
        }
        patterns = a;
    }
}

