/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpPrefixBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;

public class IpPrefix
implements Serializable {
    private static final long serialVersionUID = 4870886602207064041L;
    private final Ipv4Prefix _ipv4Prefix;
    private final Ipv6Prefix _ipv6Prefix;
    private char[] _value;

    public IpPrefix(Ipv4Prefix _ipv4Prefix) {
        this._ipv4Prefix = _ipv4Prefix;
        this._ipv6Prefix = null;
    }

    public IpPrefix(Ipv6Prefix _ipv6Prefix) {
        this._ipv6Prefix = _ipv6Prefix;
        this._ipv4Prefix = null;
    }

    @ConstructorProperties(value={"value"})
    public IpPrefix(char[] _value) {
        String defVal = new String(_value);
        IpPrefix defInst = IpPrefixBuilder.getDefaultInstance(defVal);
        this._ipv4Prefix = defInst._ipv4Prefix;
        this._ipv6Prefix = defInst._ipv6Prefix;
        this._value = _value == null ? null : (char[])_value.clone();
    }

    public IpPrefix(IpPrefix source) {
        this._ipv4Prefix = source._ipv4Prefix;
        this._ipv6Prefix = source._ipv6Prefix;
        this._value = source._value;
    }

    public Ipv4Prefix getIpv4Prefix() {
        return this._ipv4Prefix;
    }

    public Ipv6Prefix getIpv6Prefix() {
        return this._ipv6Prefix;
    }

    public char[] getValue() {
        if (this._value == null) {
            if (this._ipv4Prefix != null) {
                this._value = this._ipv4Prefix.getValue().toString().toCharArray();
            } else if (this._ipv6Prefix != null) {
                this._value = this._ipv6Prefix.getValue().toString().toCharArray();
            }
        }
        return this._value == null ? null : (char[])this._value.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._ipv4Prefix);
        result = 31 * result + Objects.hashCode(this._ipv6Prefix);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpPrefix other = (IpPrefix)obj;
        if (!Objects.equals(this._ipv4Prefix, other._ipv4Prefix)) {
            return false;
        }
        return Objects.equals(this._ipv6Prefix, other._ipv6Prefix);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(IpPrefix.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._ipv4Prefix != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_ipv4Prefix=");
            builder.append(this._ipv4Prefix);
        }
        if (this._ipv6Prefix != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_ipv6Prefix=");
            builder.append(this._ipv6Prefix);
        }
        return builder.append(']').toString();
    }
}

