/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddressBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;

public class IpAddress
implements Serializable {
    private static final long serialVersionUID = 3033840439936785623L;
    private final Ipv4Address _ipv4Address;
    private final Ipv6Address _ipv6Address;
    private char[] _value;

    public IpAddress(Ipv4Address _ipv4Address) {
        this._ipv4Address = _ipv4Address;
        this._ipv6Address = null;
    }

    public IpAddress(Ipv6Address _ipv6Address) {
        this._ipv6Address = _ipv6Address;
        this._ipv4Address = null;
    }

    @ConstructorProperties(value={"value"})
    public IpAddress(char[] _value) {
        String defVal = new String(_value);
        IpAddress defInst = IpAddressBuilder.getDefaultInstance(defVal);
        this._ipv4Address = defInst._ipv4Address;
        this._ipv6Address = defInst._ipv6Address;
        this._value = _value == null ? null : (char[])_value.clone();
    }

    public IpAddress(IpAddress source) {
        this._ipv4Address = source._ipv4Address;
        this._ipv6Address = source._ipv6Address;
        this._value = source._value;
    }

    public Ipv4Address getIpv4Address() {
        return this._ipv4Address;
    }

    public Ipv6Address getIpv6Address() {
        return this._ipv6Address;
    }

    public char[] getValue() {
        if (this._value == null) {
            if (this._ipv4Address != null) {
                this._value = this._ipv4Address.getValue().toString().toCharArray();
            } else if (this._ipv6Address != null) {
                this._value = this._ipv6Address.getValue().toString().toCharArray();
            }
        }
        return this._value == null ? null : (char[])this._value.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._ipv4Address);
        result = 31 * result + Objects.hashCode(this._ipv6Address);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpAddress other = (IpAddress)obj;
        if (!Objects.equals(this._ipv4Address, other._ipv4Address)) {
            return false;
        }
        return Objects.equals(this._ipv6Address, other._ipv6Address);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(IpAddress.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._ipv4Address != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_ipv4Address=");
            builder.append(this._ipv4Address);
        }
        if (this._ipv6Address != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_ipv6Address=");
            builder.append(this._ipv6Address);
        }
        return builder.append(']').toString();
    }
}

