/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924;

import com.google.common.annotations.Beta;
import org.opendaylight.mdsal.model.ietf.util.AbstractIetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;

@Beta
public final class IetfInetUtil
extends AbstractIetfInetUtil<Ipv4Address, Ipv4Prefix, Ipv6Address, Ipv6Prefix, IpAddress, IpPrefix> {
    public static final IetfInetUtil INSTANCE = new IetfInetUtil();

    private IetfInetUtil() {
        super(Ipv4Address.class, Ipv4Prefix.class, Ipv6Address.class, Ipv6Prefix.class);
    }

    protected IpAddress ipv4Address(Ipv4Address addr) {
        return new IpAddress(addr);
    }

    protected IpAddress ipv6Address(Ipv6Address addr) {
        return new IpAddress(addr);
    }

    protected IpPrefix ipv4Prefix(Ipv4Prefix addr) {
        return new IpPrefix(addr);
    }

    protected IpPrefix ipv6Prefix(Ipv6Prefix addr) {
        return new IpPrefix(addr);
    }

    protected String ipv4AddressString(Ipv4Address addr) {
        return addr.getValue();
    }

    protected String ipv6AddressString(Ipv6Address addr) {
        return addr.getValue();
    }

    protected String ipv4PrefixString(Ipv4Prefix prefix) {
        return prefix.getValue();
    }

    protected String ipv6PrefixString(Ipv6Prefix prefix) {
        return prefix.getValue();
    }

    protected Ipv4Address maybeIpv4Address(IpAddress addr) {
        return addr.getIpv4Address();
    }

    protected Ipv6Address maybeIpv6Address(IpAddress addr) {
        return addr.getIpv6Address();
    }
}

