/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.Ace;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.AceKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.AceOperData;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.Actions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.access.list.entries.ace.Matches;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AceBuilder
implements Builder<Ace> {
    private AceOperData _aceOperData;
    private Actions _actions;
    private AceKey _key;
    private Matches _matches;
    private String _ruleName;
    Map<Class<? extends Augmentation<Ace>>, Augmentation<Ace>> augmentation = Collections.emptyMap();

    public AceBuilder() {
    }

    public AceBuilder(Ace base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AceKey(base.getRuleName());
            this._ruleName = base.getRuleName();
        } else {
            this._key = base.getKey();
            this._ruleName = this._key.getRuleName();
        }
        this._aceOperData = base.getAceOperData();
        this._actions = base.getActions();
        this._matches = base.getMatches();
        if (base instanceof AceImpl) {
            AceImpl impl = (AceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ace>>, Augmentation<Ace>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ace>>, Augmentation<Ace>>(casted.augmentations());
        }
    }

    public AceOperData getAceOperData() {
        return this._aceOperData;
    }

    public Actions getActions() {
        return this._actions;
    }

    public AceKey getKey() {
        return this._key;
    }

    public Matches getMatches() {
        return this._matches;
    }

    public String getRuleName() {
        return this._ruleName;
    }

    public <E extends Augmentation<Ace>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AceBuilder setAceOperData(AceOperData value) {
        this._aceOperData = value;
        return this;
    }

    public AceBuilder setActions(Actions value) {
        this._actions = value;
        return this;
    }

    public AceBuilder setKey(AceKey value) {
        this._key = value;
        return this;
    }

    public AceBuilder setMatches(Matches value) {
        this._matches = value;
        return this;
    }

    public AceBuilder setRuleName(String value) {
        this._ruleName = value;
        return this;
    }

    public AceBuilder addAugmentation(Class<? extends Augmentation<Ace>> augmentationType, Augmentation<Ace> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ace>>, Augmentation<Ace>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AceBuilder removeAugmentation(Class<? extends Augmentation<Ace>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ace build() {
        return new AceImpl(this);
    }

    private static final class AceImpl
    implements Ace {
        private final AceOperData _aceOperData;
        private final Actions _actions;
        private final AceKey _key;
        private final Matches _matches;
        private final String _ruleName;
        private Map<Class<? extends Augmentation<Ace>>, Augmentation<Ace>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ace> getImplementedInterface() {
            return Ace.class;
        }

        private AceImpl(AceBuilder base) {
            if (base.getKey() == null) {
                this._key = new AceKey(base.getRuleName());
                this._ruleName = base.getRuleName();
            } else {
                this._key = base.getKey();
                this._ruleName = this._key.getRuleName();
            }
            this._aceOperData = base.getAceOperData();
            this._actions = base.getActions();
            this._matches = base.getMatches();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ace>>, Augmentation<Ace>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ace>>, Augmentation<Ace>>(base.augmentation);
                }
            }
        }

        @Override
        public AceOperData getAceOperData() {
            return this._aceOperData;
        }

        @Override
        public Actions getActions() {
            return this._actions;
        }

        @Override
        public AceKey getKey() {
            return this._key;
        }

        @Override
        public Matches getMatches() {
            return this._matches;
        }

        @Override
        public String getRuleName() {
            return this._ruleName;
        }

        public <E extends Augmentation<Ace>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._aceOperData);
            result = 31 * result + Objects.hashCode(this._actions);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._matches);
            result = 31 * result + Objects.hashCode(this._ruleName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ace.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ace other = (Ace)obj;
            if (!Objects.equals(this._aceOperData, other.getAceOperData())) {
                return false;
            }
            if (!Objects.equals(this._actions, other.getActions())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._matches, other.getMatches())) {
                return false;
            }
            if (!Objects.equals(this._ruleName, other.getRuleName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AceImpl otherImpl = (AceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ace>>, Augmentation<Ace>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Ace [";
            StringBuilder builder = new StringBuilder(name);
            if (this._aceOperData != null) {
                builder.append("_aceOperData=");
                builder.append(this._aceOperData);
                builder.append(", ");
            }
            if (this._actions != null) {
                builder.append("_actions=");
                builder.append(this._actions);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._matches != null) {
                builder.append("_matches=");
                builder.append(this._matches);
                builder.append(", ");
            }
            if (this._ruleName != null) {
                builder.append("_ruleName=");
                builder.append(this._ruleName);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

