/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.AclBase;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.Acl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.AclKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.AccessListEntries;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.access.control.list.rev160218.access.lists.acl.AclOperData;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AclBuilder
implements Builder<Acl> {
    private AccessListEntries _accessListEntries;
    private String _aclName;
    private AclOperData _aclOperData;
    private Class<? extends AclBase> _aclType;
    private AclKey _key;
    Map<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> augmentation = Collections.emptyMap();

    public AclBuilder() {
    }

    public AclBuilder(Acl base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new AclKey(base.getAclName(), base.getAclType());
            this._aclName = base.getAclName();
            this._aclType = base.getAclType();
        } else {
            this._key = base.getKey();
            this._aclName = this._key.getAclName();
            this._aclType = this._key.getAclType();
        }
        this._accessListEntries = base.getAccessListEntries();
        this._aclOperData = base.getAclOperData();
        if (base instanceof AclImpl) {
            AclImpl impl = (AclImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>(casted.augmentations());
        }
    }

    public AccessListEntries getAccessListEntries() {
        return this._accessListEntries;
    }

    public String getAclName() {
        return this._aclName;
    }

    public AclOperData getAclOperData() {
        return this._aclOperData;
    }

    public Class<? extends AclBase> getAclType() {
        return this._aclType;
    }

    public AclKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Acl>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public AclBuilder setAccessListEntries(AccessListEntries value) {
        this._accessListEntries = value;
        return this;
    }

    public AclBuilder setAclName(String value) {
        this._aclName = value;
        return this;
    }

    public AclBuilder setAclOperData(AclOperData value) {
        this._aclOperData = value;
        return this;
    }

    public AclBuilder setAclType(Class<? extends AclBase> value) {
        this._aclType = value;
        return this;
    }

    public AclBuilder setKey(AclKey value) {
        this._key = value;
        return this;
    }

    public AclBuilder addAugmentation(Class<? extends Augmentation<Acl>> augmentationType, Augmentation<Acl> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AclBuilder removeAugmentation(Class<? extends Augmentation<Acl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Acl build() {
        return new AclImpl(this);
    }

    private static final class AclImpl
    implements Acl {
        private final AccessListEntries _accessListEntries;
        private final String _aclName;
        private final AclOperData _aclOperData;
        private final Class<? extends AclBase> _aclType;
        private final AclKey _key;
        private Map<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Acl> getImplementedInterface() {
            return Acl.class;
        }

        private AclImpl(AclBuilder base) {
            if (base.getKey() == null) {
                this._key = new AclKey(base.getAclName(), base.getAclType());
                this._aclName = base.getAclName();
                this._aclType = base.getAclType();
            } else {
                this._key = base.getKey();
                this._aclName = this._key.getAclName();
                this._aclType = this._key.getAclType();
            }
            this._accessListEntries = base.getAccessListEntries();
            this._aclOperData = base.getAclOperData();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Acl>>, Augmentation<Acl>>(base.augmentation);
                }
            }
        }

        @Override
        public AccessListEntries getAccessListEntries() {
            return this._accessListEntries;
        }

        @Override
        public String getAclName() {
            return this._aclName;
        }

        @Override
        public AclOperData getAclOperData() {
            return this._aclOperData;
        }

        @Override
        public Class<? extends AclBase> getAclType() {
            return this._aclType;
        }

        @Override
        public AclKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Acl>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._accessListEntries);
            result = 31 * result + Objects.hashCode(this._aclName);
            result = 31 * result + Objects.hashCode(this._aclOperData);
            result = 31 * result + Objects.hashCode(this._aclType);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Acl.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Acl other = (Acl)obj;
            if (!Objects.equals(this._accessListEntries, other.getAccessListEntries())) {
                return false;
            }
            if (!Objects.equals(this._aclName, other.getAclName())) {
                return false;
            }
            if (!Objects.equals(this._aclOperData, other.getAclOperData())) {
                return false;
            }
            if (!Objects.equals(this._aclType, other.getAclType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AclImpl otherImpl = (AclImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Acl>>, Augmentation<Acl>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Acl [";
            StringBuilder builder = new StringBuilder(name);
            if (this._accessListEntries != null) {
                builder.append("_accessListEntries=");
                builder.append(this._accessListEntries);
                builder.append(", ");
            }
            if (this._aclName != null) {
                builder.append("_aclName=");
                builder.append(this._aclName);
                builder.append(", ");
            }
            if (this._aclOperData != null) {
                builder.append("_aclOperData=");
                builder.append(this._aclOperData);
                builder.append(", ");
            }
            if (this._aclType != null) {
                builder.append("_aclType=");
                builder.append(this._aclType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

