/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ieee.params.xml.ns.yang.dot1q.types.rev150626.dot1q.tag.ranges;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ieee.params.xml.ns.yang.dot1q.types.rev150626.Dot1qTagVlanType;
import org.opendaylight.yang.gen.v1.urn.ieee.params.xml.ns.yang.dot1q.types.rev150626.Dot1qVlanIdRanges;
import org.opendaylight.yang.gen.v1.urn.ieee.params.xml.ns.yang.dot1q.types.rev150626.dot1q.tag.ranges.Dot1qTag;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Dot1qTagBuilder
implements Builder<Dot1qTag> {
    private Class<? extends Dot1qTagVlanType> _tagType;
    private Dot1qVlanIdRanges _vlanIds;
    Map<Class<? extends Augmentation<Dot1qTag>>, Augmentation<Dot1qTag>> augmentation = Collections.emptyMap();

    public Dot1qTagBuilder() {
    }

    public Dot1qTagBuilder(Dot1qTag base) {
        AugmentationHolder casted;
        this._tagType = base.getTagType();
        this._vlanIds = base.getVlanIds();
        if (base instanceof Dot1qTagImpl) {
            Dot1qTagImpl impl = (Dot1qTagImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Dot1qTag>>, Augmentation<Dot1qTag>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Dot1qTag>>, Augmentation<Dot1qTag>>(casted.augmentations());
        }
    }

    public Class<? extends Dot1qTagVlanType> getTagType() {
        return this._tagType;
    }

    public Dot1qVlanIdRanges getVlanIds() {
        return this._vlanIds;
    }

    public <E extends Augmentation<Dot1qTag>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Dot1qTagBuilder setTagType(Class<? extends Dot1qTagVlanType> value) {
        this._tagType = value;
        return this;
    }

    public Dot1qTagBuilder setVlanIds(Dot1qVlanIdRanges value) {
        this._vlanIds = value;
        return this;
    }

    public Dot1qTagBuilder addAugmentation(Class<? extends Augmentation<Dot1qTag>> augmentationType, Augmentation<Dot1qTag> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Dot1qTag>>, Augmentation<Dot1qTag>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Dot1qTagBuilder removeAugmentation(Class<? extends Augmentation<Dot1qTag>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Dot1qTag build() {
        return new Dot1qTagImpl(this);
    }

    private static final class Dot1qTagImpl
    implements Dot1qTag {
        private final Class<? extends Dot1qTagVlanType> _tagType;
        private final Dot1qVlanIdRanges _vlanIds;
        private Map<Class<? extends Augmentation<Dot1qTag>>, Augmentation<Dot1qTag>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Dot1qTag> getImplementedInterface() {
            return Dot1qTag.class;
        }

        private Dot1qTagImpl(Dot1qTagBuilder base) {
            this._tagType = base.getTagType();
            this._vlanIds = base.getVlanIds();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Dot1qTag>>, Augmentation<Dot1qTag>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Dot1qTag>>, Augmentation<Dot1qTag>>(base.augmentation);
                }
            }
        }

        @Override
        public Class<? extends Dot1qTagVlanType> getTagType() {
            return this._tagType;
        }

        @Override
        public Dot1qVlanIdRanges getVlanIds() {
            return this._vlanIds;
        }

        public <E extends Augmentation<Dot1qTag>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._tagType);
            result = 31 * result + Objects.hashCode(this._vlanIds);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Dot1qTag.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Dot1qTag other = (Dot1qTag)obj;
            if (!Objects.equals(this._tagType, other.getTagType())) {
                return false;
            }
            if (!Objects.equals(this._vlanIds, other.getVlanIds())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Dot1qTagImpl otherImpl = (Dot1qTagImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Dot1qTag>>, Augmentation<Dot1qTag>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Dot1qTag [";
            StringBuilder builder = new StringBuilder(name);
            if (this._tagType != null) {
                builder.append("_tagType=");
                builder.append(this._tagType);
                builder.append(", ");
            }
            if (this._vlanIds != null) {
                builder.append("_vlanIds=");
                builder.append(this._vlanIds);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

