/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ieee.params.xml.ns.yang.dot1q.types.rev150626;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class Dot1qVlanId
implements Serializable {
    private static final long serialVersionUID = 4124561813664789174L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= 1 && value <= 4094) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..4094]].", value));
    }

    @ConstructorProperties(value={"value"})
    public Dot1qVlanId(Integer _value) {
        if (_value != null) {
            Dot1qVlanId.check_valueRange(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public Dot1qVlanId(Dot1qVlanId source) {
        this._value = source._value;
    }

    public static Dot1qVlanId getDefaultInstance(String defaultValue) {
        return new Dot1qVlanId(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot1qVlanId other = (Dot1qVlanId)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Dot1qVlanId.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

