/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.sff.ofs.rev150408.port.details;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.sff.ofs.rev150408.port.details.OfsPort;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OfsPortBuilder
implements Builder<OfsPort> {
    private MacAddress _macAddress;
    private String _portId;
    Map<Class<? extends Augmentation<OfsPort>>, Augmentation<OfsPort>> augmentation = Collections.emptyMap();

    public OfsPortBuilder() {
    }

    public OfsPortBuilder(OfsPort base) {
        AugmentationHolder casted;
        this._macAddress = base.getMacAddress();
        this._portId = base.getPortId();
        if (base instanceof OfsPortImpl) {
            OfsPortImpl impl = (OfsPortImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OfsPort>>, Augmentation<OfsPort>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OfsPort>>, Augmentation<OfsPort>>(casted.augmentations());
        }
    }

    public MacAddress getMacAddress() {
        return this._macAddress;
    }

    public String getPortId() {
        return this._portId;
    }

    public <E extends Augmentation<OfsPort>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OfsPortBuilder setMacAddress(MacAddress value) {
        this._macAddress = value;
        return this;
    }

    public OfsPortBuilder setPortId(String value) {
        this._portId = value;
        return this;
    }

    public OfsPortBuilder addAugmentation(Class<? extends Augmentation<OfsPort>> augmentationType, Augmentation<OfsPort> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OfsPort>>, Augmentation<OfsPort>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OfsPortBuilder removeAugmentation(Class<? extends Augmentation<OfsPort>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OfsPort build() {
        return new OfsPortImpl(this);
    }

    private static final class OfsPortImpl
    implements OfsPort {
        private final MacAddress _macAddress;
        private final String _portId;
        private Map<Class<? extends Augmentation<OfsPort>>, Augmentation<OfsPort>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OfsPort> getImplementedInterface() {
            return OfsPort.class;
        }

        private OfsPortImpl(OfsPortBuilder base) {
            this._macAddress = base.getMacAddress();
            this._portId = base.getPortId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OfsPort>>, Augmentation<OfsPort>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OfsPort>>, Augmentation<OfsPort>>(base.augmentation);
                }
            }
        }

        @Override
        public MacAddress getMacAddress() {
            return this._macAddress;
        }

        @Override
        public String getPortId() {
            return this._portId;
        }

        public <E extends Augmentation<OfsPort>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._macAddress);
            result = 31 * result + Objects.hashCode(this._portId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OfsPort.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OfsPort other = (OfsPort)obj;
            if (!Objects.equals(this._macAddress, other.getMacAddress())) {
                return false;
            }
            if (!Objects.equals(this._portId, other.getPortId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OfsPortImpl otherImpl = (OfsPortImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OfsPort>>, Augmentation<OfsPort>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "OfsPort [";
            StringBuilder builder = new StringBuilder(name);
            if (this._macAddress != null) {
                builder.append("_macAddress=");
                builder.append(this._macAddress);
                builder.append(", ");
            }
            if (this._portId != null) {
                builder.append("_portId=");
                builder.append(this._portId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

