/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.sf.map.rev140701.service.function.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.SlTransportType;
import org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.sf.map.rev140701.service.function.mapping.SlTransports;
import org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.sf.map.rev140701.service.function.mapping.SlTransportsKey;
import org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.sf.map.rev140701.service.function.mapping.sl.transports.ServiceFunctionTypeMapping;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SlTransportsBuilder
implements Builder<SlTransports> {
    private SlTransportsKey _key;
    private List<ServiceFunctionTypeMapping> _serviceFunctionTypeMapping;
    private Class<? extends SlTransportType> _transport;
    Map<Class<? extends Augmentation<SlTransports>>, Augmentation<SlTransports>> augmentation = Collections.emptyMap();

    public SlTransportsBuilder() {
    }

    public SlTransportsBuilder(SlTransports base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new SlTransportsKey(base.getTransport());
            this._transport = base.getTransport();
        } else {
            this._key = base.getKey();
            this._transport = this._key.getTransport();
        }
        this._serviceFunctionTypeMapping = base.getServiceFunctionTypeMapping();
        if (base instanceof SlTransportsImpl) {
            SlTransportsImpl impl = (SlTransportsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SlTransports>>, Augmentation<SlTransports>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SlTransports>>, Augmentation<SlTransports>>(casted.augmentations());
        }
    }

    public SlTransportsKey getKey() {
        return this._key;
    }

    public List<ServiceFunctionTypeMapping> getServiceFunctionTypeMapping() {
        return this._serviceFunctionTypeMapping;
    }

    public Class<? extends SlTransportType> getTransport() {
        return this._transport;
    }

    public <E extends Augmentation<SlTransports>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SlTransportsBuilder setKey(SlTransportsKey value) {
        this._key = value;
        return this;
    }

    public SlTransportsBuilder setServiceFunctionTypeMapping(List<ServiceFunctionTypeMapping> value) {
        this._serviceFunctionTypeMapping = value;
        return this;
    }

    public SlTransportsBuilder setTransport(Class<? extends SlTransportType> value) {
        this._transport = value;
        return this;
    }

    public SlTransportsBuilder addAugmentation(Class<? extends Augmentation<SlTransports>> augmentationType, Augmentation<SlTransports> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SlTransports>>, Augmentation<SlTransports>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SlTransportsBuilder removeAugmentation(Class<? extends Augmentation<SlTransports>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SlTransports build() {
        return new SlTransportsImpl(this);
    }

    private static final class SlTransportsImpl
    implements SlTransports {
        private final SlTransportsKey _key;
        private final List<ServiceFunctionTypeMapping> _serviceFunctionTypeMapping;
        private final Class<? extends SlTransportType> _transport;
        private Map<Class<? extends Augmentation<SlTransports>>, Augmentation<SlTransports>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SlTransports> getImplementedInterface() {
            return SlTransports.class;
        }

        private SlTransportsImpl(SlTransportsBuilder base) {
            if (base.getKey() == null) {
                this._key = new SlTransportsKey(base.getTransport());
                this._transport = base.getTransport();
            } else {
                this._key = base.getKey();
                this._transport = this._key.getTransport();
            }
            this._serviceFunctionTypeMapping = base.getServiceFunctionTypeMapping();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SlTransports>>, Augmentation<SlTransports>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SlTransports>>, Augmentation<SlTransports>>(base.augmentation);
                }
            }
        }

        @Override
        public SlTransportsKey getKey() {
            return this._key;
        }

        @Override
        public List<ServiceFunctionTypeMapping> getServiceFunctionTypeMapping() {
            return this._serviceFunctionTypeMapping;
        }

        @Override
        public Class<? extends SlTransportType> getTransport() {
            return this._transport;
        }

        public <E extends Augmentation<SlTransports>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._serviceFunctionTypeMapping);
            result = 31 * result + Objects.hashCode(this._transport);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SlTransports.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SlTransports other = (SlTransports)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionTypeMapping, other.getServiceFunctionTypeMapping())) {
                return false;
            }
            if (!Objects.equals(this._transport, other.getTransport())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SlTransportsImpl otherImpl = (SlTransportsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SlTransports>>, Augmentation<SlTransports>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SlTransports [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._serviceFunctionTypeMapping != null) {
                builder.append("_serviceFunctionTypeMapping=");
                builder.append(this._serviceFunctionTypeMapping);
                builder.append(", ");
            }
            if (this._transport != null) {
                builder.append("_transport=");
                builder.append(this._transport);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

