/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.of.renderer.rev151123.sfc.of.table.offsets;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffName;
import org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.of.renderer.rev151123.SfcOfTablesEntry;
import org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.of.renderer.rev151123.sfc.of.table.offsets.SfcOfTablesByBaseTable;
import org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.of.renderer.rev151123.sfc.of.table.offsets.SfcOfTablesByBaseTableKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SfcOfTablesByBaseTableBuilder
implements Builder<SfcOfTablesByBaseTable> {
    private Long _baseTable;
    private SfcOfTablesByBaseTableKey _key;
    private Long _nextHopTable;
    private Long _pathMapperAclTable;
    private Long _pathMapperTable;
    private SffName _sffName;
    private Long _transportEgressTable;
    private Long _transportIngressTable;
    Map<Class<? extends Augmentation<SfcOfTablesByBaseTable>>, Augmentation<SfcOfTablesByBaseTable>> augmentation = Collections.emptyMap();

    public SfcOfTablesByBaseTableBuilder() {
    }

    public SfcOfTablesByBaseTableBuilder(SfcOfTablesEntry arg) {
        this._sffName = arg.getSffName();
        this._baseTable = arg.getBaseTable();
        this._transportIngressTable = arg.getTransportIngressTable();
        this._pathMapperTable = arg.getPathMapperTable();
        this._pathMapperAclTable = arg.getPathMapperAclTable();
        this._nextHopTable = arg.getNextHopTable();
        this._transportEgressTable = arg.getTransportEgressTable();
    }

    public SfcOfTablesByBaseTableBuilder(SfcOfTablesByBaseTable base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new SfcOfTablesByBaseTableKey(base.getSffName());
            this._sffName = base.getSffName();
        } else {
            this._key = base.getKey();
            this._sffName = this._key.getSffName();
        }
        this._baseTable = base.getBaseTable();
        this._nextHopTable = base.getNextHopTable();
        this._pathMapperAclTable = base.getPathMapperAclTable();
        this._pathMapperTable = base.getPathMapperTable();
        this._transportEgressTable = base.getTransportEgressTable();
        this._transportIngressTable = base.getTransportIngressTable();
        if (base instanceof SfcOfTablesByBaseTableImpl) {
            SfcOfTablesByBaseTableImpl impl = (SfcOfTablesByBaseTableImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SfcOfTablesByBaseTable>>, Augmentation<SfcOfTablesByBaseTable>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SfcOfTablesByBaseTable>>, Augmentation<SfcOfTablesByBaseTable>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SfcOfTablesEntry) {
            this._sffName = ((SfcOfTablesEntry)arg).getSffName();
            this._baseTable = ((SfcOfTablesEntry)arg).getBaseTable();
            this._transportIngressTable = ((SfcOfTablesEntry)arg).getTransportIngressTable();
            this._pathMapperTable = ((SfcOfTablesEntry)arg).getPathMapperTable();
            this._pathMapperAclTable = ((SfcOfTablesEntry)arg).getPathMapperAclTable();
            this._nextHopTable = ((SfcOfTablesEntry)arg).getNextHopTable();
            this._transportEgressTable = ((SfcOfTablesEntry)arg).getTransportEgressTable();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.of.renderer.rev151123.SfcOfTablesEntry] \nbut was: " + arg);
        }
    }

    public Long getBaseTable() {
        return this._baseTable;
    }

    public SfcOfTablesByBaseTableKey getKey() {
        return this._key;
    }

    public Long getNextHopTable() {
        return this._nextHopTable;
    }

    public Long getPathMapperAclTable() {
        return this._pathMapperAclTable;
    }

    public Long getPathMapperTable() {
        return this._pathMapperTable;
    }

    public SffName getSffName() {
        return this._sffName;
    }

    public Long getTransportEgressTable() {
        return this._transportEgressTable;
    }

    public Long getTransportIngressTable() {
        return this._transportIngressTable;
    }

    public <E extends Augmentation<SfcOfTablesByBaseTable>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBaseTableRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public SfcOfTablesByBaseTableBuilder setBaseTable(Long value) {
        if (value != null) {
            SfcOfTablesByBaseTableBuilder.checkBaseTableRange(value);
        }
        this._baseTable = value;
        return this;
    }

    public SfcOfTablesByBaseTableBuilder setKey(SfcOfTablesByBaseTableKey value) {
        this._key = value;
        return this;
    }

    private static void checkNextHopTableRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public SfcOfTablesByBaseTableBuilder setNextHopTable(Long value) {
        if (value != null) {
            SfcOfTablesByBaseTableBuilder.checkNextHopTableRange(value);
        }
        this._nextHopTable = value;
        return this;
    }

    private static void checkPathMapperAclTableRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public SfcOfTablesByBaseTableBuilder setPathMapperAclTable(Long value) {
        if (value != null) {
            SfcOfTablesByBaseTableBuilder.checkPathMapperAclTableRange(value);
        }
        this._pathMapperAclTable = value;
        return this;
    }

    private static void checkPathMapperTableRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public SfcOfTablesByBaseTableBuilder setPathMapperTable(Long value) {
        if (value != null) {
            SfcOfTablesByBaseTableBuilder.checkPathMapperTableRange(value);
        }
        this._pathMapperTable = value;
        return this;
    }

    public SfcOfTablesByBaseTableBuilder setSffName(SffName value) {
        this._sffName = value;
        return this;
    }

    private static void checkTransportEgressTableRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public SfcOfTablesByBaseTableBuilder setTransportEgressTable(Long value) {
        if (value != null) {
            SfcOfTablesByBaseTableBuilder.checkTransportEgressTableRange(value);
        }
        this._transportEgressTable = value;
        return this;
    }

    private static void checkTransportIngressTableRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public SfcOfTablesByBaseTableBuilder setTransportIngressTable(Long value) {
        if (value != null) {
            SfcOfTablesByBaseTableBuilder.checkTransportIngressTableRange(value);
        }
        this._transportIngressTable = value;
        return this;
    }

    public SfcOfTablesByBaseTableBuilder addAugmentation(Class<? extends Augmentation<SfcOfTablesByBaseTable>> augmentationType, Augmentation<SfcOfTablesByBaseTable> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SfcOfTablesByBaseTable>>, Augmentation<SfcOfTablesByBaseTable>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SfcOfTablesByBaseTableBuilder removeAugmentation(Class<? extends Augmentation<SfcOfTablesByBaseTable>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SfcOfTablesByBaseTable build() {
        return new SfcOfTablesByBaseTableImpl(this);
    }

    private static final class SfcOfTablesByBaseTableImpl
    implements SfcOfTablesByBaseTable {
        private final Long _baseTable;
        private final SfcOfTablesByBaseTableKey _key;
        private final Long _nextHopTable;
        private final Long _pathMapperAclTable;
        private final Long _pathMapperTable;
        private final SffName _sffName;
        private final Long _transportEgressTable;
        private final Long _transportIngressTable;
        private Map<Class<? extends Augmentation<SfcOfTablesByBaseTable>>, Augmentation<SfcOfTablesByBaseTable>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SfcOfTablesByBaseTable> getImplementedInterface() {
            return SfcOfTablesByBaseTable.class;
        }

        private SfcOfTablesByBaseTableImpl(SfcOfTablesByBaseTableBuilder base) {
            if (base.getKey() == null) {
                this._key = new SfcOfTablesByBaseTableKey(base.getSffName());
                this._sffName = base.getSffName();
            } else {
                this._key = base.getKey();
                this._sffName = this._key.getSffName();
            }
            this._baseTable = base.getBaseTable();
            this._nextHopTable = base.getNextHopTable();
            this._pathMapperAclTable = base.getPathMapperAclTable();
            this._pathMapperTable = base.getPathMapperTable();
            this._transportEgressTable = base.getTransportEgressTable();
            this._transportIngressTable = base.getTransportIngressTable();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SfcOfTablesByBaseTable>>, Augmentation<SfcOfTablesByBaseTable>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SfcOfTablesByBaseTable>>, Augmentation<SfcOfTablesByBaseTable>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getBaseTable() {
            return this._baseTable;
        }

        @Override
        public SfcOfTablesByBaseTableKey getKey() {
            return this._key;
        }

        @Override
        public Long getNextHopTable() {
            return this._nextHopTable;
        }

        @Override
        public Long getPathMapperAclTable() {
            return this._pathMapperAclTable;
        }

        @Override
        public Long getPathMapperTable() {
            return this._pathMapperTable;
        }

        @Override
        public SffName getSffName() {
            return this._sffName;
        }

        @Override
        public Long getTransportEgressTable() {
            return this._transportEgressTable;
        }

        @Override
        public Long getTransportIngressTable() {
            return this._transportIngressTable;
        }

        public <E extends Augmentation<SfcOfTablesByBaseTable>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._baseTable);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._nextHopTable);
            result = 31 * result + Objects.hashCode(this._pathMapperAclTable);
            result = 31 * result + Objects.hashCode(this._pathMapperTable);
            result = 31 * result + Objects.hashCode(this._sffName);
            result = 31 * result + Objects.hashCode(this._transportEgressTable);
            result = 31 * result + Objects.hashCode(this._transportIngressTable);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SfcOfTablesByBaseTable.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SfcOfTablesByBaseTable other = (SfcOfTablesByBaseTable)obj;
            if (!Objects.equals(this._baseTable, other.getBaseTable())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._nextHopTable, other.getNextHopTable())) {
                return false;
            }
            if (!Objects.equals(this._pathMapperAclTable, other.getPathMapperAclTable())) {
                return false;
            }
            if (!Objects.equals(this._pathMapperTable, other.getPathMapperTable())) {
                return false;
            }
            if (!Objects.equals(this._sffName, other.getSffName())) {
                return false;
            }
            if (!Objects.equals(this._transportEgressTable, other.getTransportEgressTable())) {
                return false;
            }
            if (!Objects.equals(this._transportIngressTable, other.getTransportIngressTable())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SfcOfTablesByBaseTableImpl otherImpl = (SfcOfTablesByBaseTableImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SfcOfTablesByBaseTable>>, Augmentation<SfcOfTablesByBaseTable>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SfcOfTablesByBaseTable [";
            StringBuilder builder = new StringBuilder(name);
            if (this._baseTable != null) {
                builder.append("_baseTable=");
                builder.append(this._baseTable);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._nextHopTable != null) {
                builder.append("_nextHopTable=");
                builder.append(this._nextHopTable);
                builder.append(", ");
            }
            if (this._pathMapperAclTable != null) {
                builder.append("_pathMapperAclTable=");
                builder.append(this._pathMapperAclTable);
                builder.append(", ");
            }
            if (this._pathMapperTable != null) {
                builder.append("_pathMapperTable=");
                builder.append(this._pathMapperTable);
                builder.append(", ");
            }
            if (this._sffName != null) {
                builder.append("_sffName=");
                builder.append(this._sffName);
                builder.append(", ");
            }
            if (this._transportEgressTable != null) {
                builder.append("_transportEgressTable=");
                builder.append(this._transportEgressTable);
                builder.append(", ");
            }
            if (this._transportIngressTable != null) {
                builder.append("_transportIngressTable=");
                builder.append(this._transportIngressTable);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

