/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.of.renderer.rev151123;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ericsson.params.xml.ns.yang.sfc.of.renderer.rev151123.SfcOfRendererConfig;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SfcOfRendererConfigBuilder
implements Builder<SfcOfRendererConfig> {
    private Short _sfcOfAppEgressTableOffset;
    private Short _sfcOfTableOffset;
    Map<Class<? extends Augmentation<SfcOfRendererConfig>>, Augmentation<SfcOfRendererConfig>> augmentation = Collections.emptyMap();

    public SfcOfRendererConfigBuilder() {
    }

    public SfcOfRendererConfigBuilder(SfcOfRendererConfig base) {
        AugmentationHolder casted;
        this._sfcOfAppEgressTableOffset = base.getSfcOfAppEgressTableOffset();
        this._sfcOfTableOffset = base.getSfcOfTableOffset();
        if (base instanceof SfcOfRendererConfigImpl) {
            SfcOfRendererConfigImpl impl = (SfcOfRendererConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SfcOfRendererConfig>>, Augmentation<SfcOfRendererConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SfcOfRendererConfig>>, Augmentation<SfcOfRendererConfig>>(casted.augmentations());
        }
    }

    public Short getSfcOfAppEgressTableOffset() {
        return this._sfcOfAppEgressTableOffset;
    }

    public Short getSfcOfTableOffset() {
        return this._sfcOfTableOffset;
    }

    public <E extends Augmentation<SfcOfRendererConfig>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkSfcOfAppEgressTableOffsetRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public SfcOfRendererConfigBuilder setSfcOfAppEgressTableOffset(Short value) {
        if (value != null) {
            SfcOfRendererConfigBuilder.checkSfcOfAppEgressTableOffsetRange(value);
        }
        this._sfcOfAppEgressTableOffset = value;
        return this;
    }

    private static void checkSfcOfTableOffsetRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public SfcOfRendererConfigBuilder setSfcOfTableOffset(Short value) {
        if (value != null) {
            SfcOfRendererConfigBuilder.checkSfcOfTableOffsetRange(value);
        }
        this._sfcOfTableOffset = value;
        return this;
    }

    public SfcOfRendererConfigBuilder addAugmentation(Class<? extends Augmentation<SfcOfRendererConfig>> augmentationType, Augmentation<SfcOfRendererConfig> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SfcOfRendererConfig>>, Augmentation<SfcOfRendererConfig>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SfcOfRendererConfigBuilder removeAugmentation(Class<? extends Augmentation<SfcOfRendererConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SfcOfRendererConfig build() {
        return new SfcOfRendererConfigImpl(this);
    }

    private static final class SfcOfRendererConfigImpl
    implements SfcOfRendererConfig {
        private final Short _sfcOfAppEgressTableOffset;
        private final Short _sfcOfTableOffset;
        private Map<Class<? extends Augmentation<SfcOfRendererConfig>>, Augmentation<SfcOfRendererConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SfcOfRendererConfig> getImplementedInterface() {
            return SfcOfRendererConfig.class;
        }

        private SfcOfRendererConfigImpl(SfcOfRendererConfigBuilder base) {
            this._sfcOfAppEgressTableOffset = base.getSfcOfAppEgressTableOffset();
            this._sfcOfTableOffset = base.getSfcOfTableOffset();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SfcOfRendererConfig>>, Augmentation<SfcOfRendererConfig>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SfcOfRendererConfig>>, Augmentation<SfcOfRendererConfig>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getSfcOfAppEgressTableOffset() {
            return this._sfcOfAppEgressTableOffset;
        }

        @Override
        public Short getSfcOfTableOffset() {
            return this._sfcOfTableOffset;
        }

        public <E extends Augmentation<SfcOfRendererConfig>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._sfcOfAppEgressTableOffset);
            result = 31 * result + Objects.hashCode(this._sfcOfTableOffset);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SfcOfRendererConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SfcOfRendererConfig other = (SfcOfRendererConfig)obj;
            if (!Objects.equals(this._sfcOfAppEgressTableOffset, other.getSfcOfAppEgressTableOffset())) {
                return false;
            }
            if (!Objects.equals(this._sfcOfTableOffset, other.getSfcOfTableOffset())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SfcOfRendererConfigImpl otherImpl = (SfcOfRendererConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SfcOfRendererConfig>>, Augmentation<SfcOfRendererConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SfcOfRendererConfig [";
            StringBuilder builder = new StringBuilder(name);
            if (this._sfcOfAppEgressTableOffset != null) {
                builder.append("_sfcOfAppEgressTableOffset=");
                builder.append(this._sfcOfAppEgressTableOffset);
                builder.append(", ");
            }
            if (this._sfcOfTableOffset != null) {
                builder.append("_sfcOfTableOffset=");
                builder.append(this._sfcOfTableOffset);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

