/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.statistic.fields;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.statistic.fields.ServiceStatistic;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.ZeroBasedCounter64;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceStatisticBuilder
implements Builder<ServiceStatistic> {
    private ZeroBasedCounter64 _bytesIn;
    private ZeroBasedCounter64 _bytesOut;
    private ZeroBasedCounter64 _packetsIn;
    private ZeroBasedCounter64 _packetsOut;
    Map<Class<? extends Augmentation<ServiceStatistic>>, Augmentation<ServiceStatistic>> augmentation = Collections.emptyMap();

    public ServiceStatisticBuilder() {
    }

    public ServiceStatisticBuilder(ServiceStatistic base) {
        AugmentationHolder casted;
        this._bytesIn = base.getBytesIn();
        this._bytesOut = base.getBytesOut();
        this._packetsIn = base.getPacketsIn();
        this._packetsOut = base.getPacketsOut();
        if (base instanceof ServiceStatisticImpl) {
            ServiceStatisticImpl impl = (ServiceStatisticImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceStatistic>>, Augmentation<ServiceStatistic>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceStatistic>>, Augmentation<ServiceStatistic>>(casted.augmentations());
        }
    }

    public ZeroBasedCounter64 getBytesIn() {
        return this._bytesIn;
    }

    public ZeroBasedCounter64 getBytesOut() {
        return this._bytesOut;
    }

    public ZeroBasedCounter64 getPacketsIn() {
        return this._packetsIn;
    }

    public ZeroBasedCounter64 getPacketsOut() {
        return this._packetsOut;
    }

    public <E extends Augmentation<ServiceStatistic>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceStatisticBuilder setBytesIn(ZeroBasedCounter64 value) {
        this._bytesIn = value;
        return this;
    }

    public ServiceStatisticBuilder setBytesOut(ZeroBasedCounter64 value) {
        this._bytesOut = value;
        return this;
    }

    public ServiceStatisticBuilder setPacketsIn(ZeroBasedCounter64 value) {
        this._packetsIn = value;
        return this;
    }

    public ServiceStatisticBuilder setPacketsOut(ZeroBasedCounter64 value) {
        this._packetsOut = value;
        return this;
    }

    public ServiceStatisticBuilder addAugmentation(Class<? extends Augmentation<ServiceStatistic>> augmentationType, Augmentation<ServiceStatistic> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceStatistic>>, Augmentation<ServiceStatistic>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceStatisticBuilder removeAugmentation(Class<? extends Augmentation<ServiceStatistic>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceStatistic build() {
        return new ServiceStatisticImpl(this);
    }

    private static final class ServiceStatisticImpl
    implements ServiceStatistic {
        private final ZeroBasedCounter64 _bytesIn;
        private final ZeroBasedCounter64 _bytesOut;
        private final ZeroBasedCounter64 _packetsIn;
        private final ZeroBasedCounter64 _packetsOut;
        private Map<Class<? extends Augmentation<ServiceStatistic>>, Augmentation<ServiceStatistic>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceStatistic> getImplementedInterface() {
            return ServiceStatistic.class;
        }

        private ServiceStatisticImpl(ServiceStatisticBuilder base) {
            this._bytesIn = base.getBytesIn();
            this._bytesOut = base.getBytesOut();
            this._packetsIn = base.getPacketsIn();
            this._packetsOut = base.getPacketsOut();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceStatistic>>, Augmentation<ServiceStatistic>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceStatistic>>, Augmentation<ServiceStatistic>>(base.augmentation);
                }
            }
        }

        @Override
        public ZeroBasedCounter64 getBytesIn() {
            return this._bytesIn;
        }

        @Override
        public ZeroBasedCounter64 getBytesOut() {
            return this._bytesOut;
        }

        @Override
        public ZeroBasedCounter64 getPacketsIn() {
            return this._packetsIn;
        }

        @Override
        public ZeroBasedCounter64 getPacketsOut() {
            return this._packetsOut;
        }

        public <E extends Augmentation<ServiceStatistic>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bytesIn);
            result = 31 * result + Objects.hashCode(this._bytesOut);
            result = 31 * result + Objects.hashCode(this._packetsIn);
            result = 31 * result + Objects.hashCode(this._packetsOut);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceStatistic.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceStatistic other = (ServiceStatistic)obj;
            if (!Objects.equals(this._bytesIn, other.getBytesIn())) {
                return false;
            }
            if (!Objects.equals(this._bytesOut, other.getBytesOut())) {
                return false;
            }
            if (!Objects.equals(this._packetsIn, other.getPacketsIn())) {
                return false;
            }
            if (!Objects.equals(this._packetsOut, other.getPacketsOut())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceStatisticImpl otherImpl = (ServiceStatisticImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceStatistic>>, Augmentation<ServiceStatistic>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceStatistic [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bytesIn != null) {
                builder.append("_bytesIn=");
                builder.append(this._bytesIn);
                builder.append(", ");
            }
            if (this._bytesOut != null) {
                builder.append("_bytesOut=");
                builder.append(this._bytesOut);
                builder.append(", ");
            }
            if (this._packetsIn != null) {
                builder.append("_packetsIn=");
                builder.append(this._packetsIn);
                builder.append(", ");
            }
            if (this._packetsOut != null) {
                builder.append("_packetsOut=");
                builder.append(this._packetsOut);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

