/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.service.statistics.group;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.StatisticFields;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.service.statistics.group.StatisticByTimestamp;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.service.statistics.group.StatisticByTimestampKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.statistic.fields.ServiceStatistic;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StatisticByTimestampBuilder
implements Builder<StatisticByTimestamp> {
    private StatisticByTimestampKey _key;
    private ServiceStatistic _serviceStatistic;
    private BigInteger _timestamp;
    Map<Class<? extends Augmentation<StatisticByTimestamp>>, Augmentation<StatisticByTimestamp>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKTIMESTAMPRANGE_RANGES;

    public StatisticByTimestampBuilder() {
    }

    public StatisticByTimestampBuilder(StatisticFields arg) {
        this._serviceStatistic = arg.getServiceStatistic();
    }

    public StatisticByTimestampBuilder(StatisticByTimestamp base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new StatisticByTimestampKey(base.getTimestamp());
            this._timestamp = base.getTimestamp();
        } else {
            this._key = base.getKey();
            this._timestamp = this._key.getTimestamp();
        }
        this._serviceStatistic = base.getServiceStatistic();
        if (base instanceof StatisticByTimestampImpl) {
            StatisticByTimestampImpl impl = (StatisticByTimestampImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<StatisticByTimestamp>>, Augmentation<StatisticByTimestamp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StatisticByTimestamp>>, Augmentation<StatisticByTimestamp>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof StatisticFields) {
            this._serviceStatistic = ((StatisticFields)arg).getServiceStatistic();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.StatisticFields] \nbut was: " + arg);
        }
    }

    public StatisticByTimestampKey getKey() {
        return this._key;
    }

    public ServiceStatistic getServiceStatistic() {
        return this._serviceStatistic;
    }

    public BigInteger getTimestamp() {
        return this._timestamp;
    }

    public <E extends Augmentation<StatisticByTimestamp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public StatisticByTimestampBuilder setKey(StatisticByTimestampKey value) {
        this._key = value;
        return this;
    }

    public StatisticByTimestampBuilder setServiceStatistic(ServiceStatistic value) {
        this._serviceStatistic = value;
        return this;
    }

    private static void checkTimestampRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKTIMESTAMPRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKTIMESTAMPRANGE_RANGES)));
    }

    public StatisticByTimestampBuilder setTimestamp(BigInteger value) {
        if (value != null) {
            StatisticByTimestampBuilder.checkTimestampRange(value);
        }
        this._timestamp = value;
        return this;
    }

    public StatisticByTimestampBuilder addAugmentation(Class<? extends Augmentation<StatisticByTimestamp>> augmentationType, Augmentation<StatisticByTimestamp> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<StatisticByTimestamp>>, Augmentation<StatisticByTimestamp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StatisticByTimestampBuilder removeAugmentation(Class<? extends Augmentation<StatisticByTimestamp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public StatisticByTimestamp build() {
        return new StatisticByTimestampImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKTIMESTAMPRANGE_RANGES = a;
    }

    private static final class StatisticByTimestampImpl
    implements StatisticByTimestamp {
        private final StatisticByTimestampKey _key;
        private final ServiceStatistic _serviceStatistic;
        private final BigInteger _timestamp;
        private Map<Class<? extends Augmentation<StatisticByTimestamp>>, Augmentation<StatisticByTimestamp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<StatisticByTimestamp> getImplementedInterface() {
            return StatisticByTimestamp.class;
        }

        private StatisticByTimestampImpl(StatisticByTimestampBuilder base) {
            if (base.getKey() == null) {
                this._key = new StatisticByTimestampKey(base.getTimestamp());
                this._timestamp = base.getTimestamp();
            } else {
                this._key = base.getKey();
                this._timestamp = this._key.getTimestamp();
            }
            this._serviceStatistic = base.getServiceStatistic();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<StatisticByTimestamp>>, Augmentation<StatisticByTimestamp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<StatisticByTimestamp>>, Augmentation<StatisticByTimestamp>>(base.augmentation);
                }
            }
        }

        @Override
        public StatisticByTimestampKey getKey() {
            return this._key;
        }

        @Override
        public ServiceStatistic getServiceStatistic() {
            return this._serviceStatistic;
        }

        @Override
        public BigInteger getTimestamp() {
            return this._timestamp;
        }

        public <E extends Augmentation<StatisticByTimestamp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._serviceStatistic);
            result = 31 * result + Objects.hashCode(this._timestamp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StatisticByTimestamp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StatisticByTimestamp other = (StatisticByTimestamp)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._serviceStatistic, other.getServiceStatistic())) {
                return false;
            }
            if (!Objects.equals(this._timestamp, other.getTimestamp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StatisticByTimestampImpl otherImpl = (StatisticByTimestampImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<StatisticByTimestamp>>, Augmentation<StatisticByTimestamp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "StatisticByTimestamp [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._serviceStatistic != null) {
                builder.append("_serviceStatistic=");
                builder.append(this._serviceStatistic);
                builder.append(", ");
            }
            if (this._timestamp != null) {
                builder.append("_timestamp=");
                builder.append(this._timestamp);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

