/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sn.rev140701.service.nodes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SnName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sn.rev140701.ServiceNodeGrouping;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sn.rev140701.service.nodes.ServiceNode;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sn.rev140701.service.nodes.ServiceNodeKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceNodeBuilder
implements Builder<ServiceNode> {
    private IpAddress _ipMgmtAddress;
    private ServiceNodeKey _key;
    private SnName _name;
    private List<SfName> _serviceFunction;
    private List<SffName> _serviceFunctionForwarder;
    Map<Class<? extends Augmentation<ServiceNode>>, Augmentation<ServiceNode>> augmentation = Collections.emptyMap();

    public ServiceNodeBuilder() {
    }

    public ServiceNodeBuilder(ServiceNodeGrouping arg) {
        this._name = arg.getName();
        this._ipMgmtAddress = arg.getIpMgmtAddress();
        this._serviceFunctionForwarder = arg.getServiceFunctionForwarder();
        this._serviceFunction = arg.getServiceFunction();
    }

    public ServiceNodeBuilder(ServiceNode base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceNodeKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._ipMgmtAddress = base.getIpMgmtAddress();
        this._serviceFunction = base.getServiceFunction();
        this._serviceFunctionForwarder = base.getServiceFunctionForwarder();
        if (base instanceof ServiceNodeImpl) {
            ServiceNodeImpl impl = (ServiceNodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceNode>>, Augmentation<ServiceNode>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceNode>>, Augmentation<ServiceNode>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceNodeGrouping) {
            this._name = ((ServiceNodeGrouping)arg).getName();
            this._ipMgmtAddress = ((ServiceNodeGrouping)arg).getIpMgmtAddress();
            this._serviceFunctionForwarder = ((ServiceNodeGrouping)arg).getServiceFunctionForwarder();
            this._serviceFunction = ((ServiceNodeGrouping)arg).getServiceFunction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sn.rev140701.ServiceNodeGrouping] \nbut was: " + arg);
        }
    }

    public IpAddress getIpMgmtAddress() {
        return this._ipMgmtAddress;
    }

    public ServiceNodeKey getKey() {
        return this._key;
    }

    public SnName getName() {
        return this._name;
    }

    public List<SfName> getServiceFunction() {
        return this._serviceFunction;
    }

    public List<SffName> getServiceFunctionForwarder() {
        return this._serviceFunctionForwarder;
    }

    public <E extends Augmentation<ServiceNode>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceNodeBuilder setIpMgmtAddress(IpAddress value) {
        this._ipMgmtAddress = value;
        return this;
    }

    public ServiceNodeBuilder setKey(ServiceNodeKey value) {
        this._key = value;
        return this;
    }

    public ServiceNodeBuilder setName(SnName value) {
        this._name = value;
        return this;
    }

    public ServiceNodeBuilder setServiceFunction(List<SfName> value) {
        this._serviceFunction = value;
        return this;
    }

    public ServiceNodeBuilder setServiceFunctionForwarder(List<SffName> value) {
        this._serviceFunctionForwarder = value;
        return this;
    }

    public ServiceNodeBuilder addAugmentation(Class<? extends Augmentation<ServiceNode>> augmentationType, Augmentation<ServiceNode> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceNode>>, Augmentation<ServiceNode>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceNodeBuilder removeAugmentation(Class<? extends Augmentation<ServiceNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceNode build() {
        return new ServiceNodeImpl(this);
    }

    private static final class ServiceNodeImpl
    implements ServiceNode {
        private final IpAddress _ipMgmtAddress;
        private final ServiceNodeKey _key;
        private final SnName _name;
        private final List<SfName> _serviceFunction;
        private final List<SffName> _serviceFunctionForwarder;
        private Map<Class<? extends Augmentation<ServiceNode>>, Augmentation<ServiceNode>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceNode> getImplementedInterface() {
            return ServiceNode.class;
        }

        private ServiceNodeImpl(ServiceNodeBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceNodeKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._ipMgmtAddress = base.getIpMgmtAddress();
            this._serviceFunction = base.getServiceFunction();
            this._serviceFunctionForwarder = base.getServiceFunctionForwarder();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceNode>>, Augmentation<ServiceNode>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceNode>>, Augmentation<ServiceNode>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIpMgmtAddress() {
            return this._ipMgmtAddress;
        }

        @Override
        public ServiceNodeKey getKey() {
            return this._key;
        }

        @Override
        public SnName getName() {
            return this._name;
        }

        @Override
        public List<SfName> getServiceFunction() {
            return this._serviceFunction;
        }

        @Override
        public List<SffName> getServiceFunctionForwarder() {
            return this._serviceFunctionForwarder;
        }

        public <E extends Augmentation<ServiceNode>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipMgmtAddress);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._serviceFunction);
            result = 31 * result + Objects.hashCode(this._serviceFunctionForwarder);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceNode.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceNode other = (ServiceNode)obj;
            if (!Objects.equals(this._ipMgmtAddress, other.getIpMgmtAddress())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunction, other.getServiceFunction())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionForwarder, other.getServiceFunctionForwarder())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceNodeImpl otherImpl = (ServiceNodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceNode>>, Augmentation<ServiceNode>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceNode [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ipMgmtAddress != null) {
                builder.append("_ipMgmtAddress=");
                builder.append(this._ipMgmtAddress);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._serviceFunction != null) {
                builder.append("_serviceFunction=");
                builder.append(this._serviceFunction);
                builder.append(", ");
            }
            if (this._serviceFunctionForwarder != null) {
                builder.append("_serviceFunctionForwarder=");
                builder.append(this._serviceFunctionForwarder);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

