/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.MplsLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type.Mpls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MplsBuilder
implements Builder<Mpls> {
    private Long _mplsLabel;
    Map<Class<? extends Augmentation<Mpls>>, Augmentation<Mpls>> augmentation = Collections.emptyMap();

    public MplsBuilder() {
    }

    public MplsBuilder(MplsLocator arg) {
        this._mplsLabel = arg.getMplsLabel();
    }

    public MplsBuilder(Mpls base) {
        AugmentationHolder casted;
        this._mplsLabel = base.getMplsLabel();
        if (base instanceof MplsImpl) {
            MplsImpl impl = (MplsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Mpls>>, Augmentation<Mpls>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mpls>>, Augmentation<Mpls>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MplsLocator) {
            this._mplsLabel = ((MplsLocator)arg).getMplsLabel();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.MplsLocator] \nbut was: " + arg);
        }
    }

    public Long getMplsLabel() {
        return this._mplsLabel;
    }

    public <E extends Augmentation<Mpls>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMplsLabelRange(long value) {
        if (value >= 1L && value <= 1048575L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..1048575]].", value));
    }

    public MplsBuilder setMplsLabel(Long value) {
        if (value != null) {
            MplsBuilder.checkMplsLabelRange(value);
        }
        this._mplsLabel = value;
        return this;
    }

    public MplsBuilder addAugmentation(Class<? extends Augmentation<Mpls>> augmentationType, Augmentation<Mpls> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mpls>>, Augmentation<Mpls>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MplsBuilder removeAugmentation(Class<? extends Augmentation<Mpls>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Mpls build() {
        return new MplsImpl(this);
    }

    private static final class MplsImpl
    implements Mpls {
        private final Long _mplsLabel;
        private Map<Class<? extends Augmentation<Mpls>>, Augmentation<Mpls>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Mpls> getImplementedInterface() {
            return Mpls.class;
        }

        private MplsImpl(MplsBuilder base) {
            this._mplsLabel = base.getMplsLabel();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Mpls>>, Augmentation<Mpls>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Mpls>>, Augmentation<Mpls>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getMplsLabel() {
            return this._mplsLabel;
        }

        public <E extends Augmentation<Mpls>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mplsLabel);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mpls.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Mpls other = (Mpls)obj;
            if (!Objects.equals(this._mplsLabel, other.getMplsLabel())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MplsImpl otherImpl = (MplsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Mpls>>, Augmentation<Mpls>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Mpls [";
            StringBuilder builder = new StringBuilder(name);
            if (this._mplsLabel != null) {
                builder.append("_mplsLabel=");
                builder.append(this._mplsLabel);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

