/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.MacAddressLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type.Mac;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MacBuilder
implements Builder<Mac> {
    private MacAddress _mac;
    private Integer _vlanId;
    Map<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> augmentation = Collections.emptyMap();

    public MacBuilder() {
    }

    public MacBuilder(MacAddressLocator arg) {
        this._mac = arg.getMac();
        this._vlanId = arg.getVlanId();
    }

    public MacBuilder(Mac base) {
        AugmentationHolder casted;
        this._mac = base.getMac();
        this._vlanId = base.getVlanId();
        if (base instanceof MacImpl) {
            MacImpl impl = (MacImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MacAddressLocator) {
            this._mac = ((MacAddressLocator)arg).getMac();
            this._vlanId = ((MacAddressLocator)arg).getVlanId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.MacAddressLocator] \nbut was: " + arg);
        }
    }

    public MacAddress getMac() {
        return this._mac;
    }

    public Integer getVlanId() {
        return this._vlanId;
    }

    public <E extends Augmentation<Mac>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MacBuilder setMac(MacAddress value) {
        this._mac = value;
        return this;
    }

    private static void checkVlanIdRange(int value) {
        if (value >= 1 && value <= 4094) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..4094]].", value));
    }

    public MacBuilder setVlanId(Integer value) {
        if (value != null) {
            MacBuilder.checkVlanIdRange(value);
        }
        this._vlanId = value;
        return this;
    }

    public MacBuilder addAugmentation(Class<? extends Augmentation<Mac>> augmentationType, Augmentation<Mac> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MacBuilder removeAugmentation(Class<? extends Augmentation<Mac>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Mac build() {
        return new MacImpl(this);
    }

    private static final class MacImpl
    implements Mac {
        private final MacAddress _mac;
        private final Integer _vlanId;
        private Map<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Mac> getImplementedInterface() {
            return Mac.class;
        }

        private MacImpl(MacBuilder base) {
            this._mac = base.getMac();
            this._vlanId = base.getVlanId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Mac>>, Augmentation<Mac>>(base.augmentation);
                }
            }
        }

        @Override
        public MacAddress getMac() {
            return this._mac;
        }

        @Override
        public Integer getVlanId() {
            return this._vlanId;
        }

        public <E extends Augmentation<Mac>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mac);
            result = 31 * result + Objects.hashCode(this._vlanId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mac.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Mac other = (Mac)obj;
            if (!Objects.equals(this._mac, other.getMac())) {
                return false;
            }
            if (!Objects.equals(this._vlanId, other.getVlanId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MacImpl otherImpl = (MacImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Mac>>, Augmentation<Mac>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Mac [";
            StringBuilder builder = new StringBuilder(name);
            if (this._mac != null) {
                builder.append("_mac=");
                builder.append(this._mac);
                builder.append(", ");
            }
            if (this._vlanId != null) {
                builder.append("_vlanId=");
                builder.append(this._vlanId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

