/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.LispLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type.Lisp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LispBuilder
implements Builder<Lisp> {
    private IpAddress _eid;
    Map<Class<? extends Augmentation<Lisp>>, Augmentation<Lisp>> augmentation = Collections.emptyMap();

    public LispBuilder() {
    }

    public LispBuilder(LispLocator arg) {
        this._eid = arg.getEid();
    }

    public LispBuilder(Lisp base) {
        AugmentationHolder casted;
        this._eid = base.getEid();
        if (base instanceof LispImpl) {
            LispImpl impl = (LispImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Lisp>>, Augmentation<Lisp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Lisp>>, Augmentation<Lisp>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LispLocator) {
            this._eid = ((LispLocator)arg).getEid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.LispLocator] \nbut was: " + arg);
        }
    }

    public IpAddress getEid() {
        return this._eid;
    }

    public <E extends Augmentation<Lisp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LispBuilder setEid(IpAddress value) {
        this._eid = value;
        return this;
    }

    public LispBuilder addAugmentation(Class<? extends Augmentation<Lisp>> augmentationType, Augmentation<Lisp> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Lisp>>, Augmentation<Lisp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LispBuilder removeAugmentation(Class<? extends Augmentation<Lisp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Lisp build() {
        return new LispImpl(this);
    }

    private static final class LispImpl
    implements Lisp {
        private final IpAddress _eid;
        private Map<Class<? extends Augmentation<Lisp>>, Augmentation<Lisp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Lisp> getImplementedInterface() {
            return Lisp.class;
        }

        private LispImpl(LispBuilder base) {
            this._eid = base.getEid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Lisp>>, Augmentation<Lisp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Lisp>>, Augmentation<Lisp>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getEid() {
            return this._eid;
        }

        public <E extends Augmentation<Lisp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._eid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Lisp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Lisp other = (Lisp)obj;
            if (!Objects.equals(this._eid, other.getEid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LispImpl otherImpl = (LispImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Lisp>>, Augmentation<Lisp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Lisp [";
            StringBuilder builder = new StringBuilder(name);
            if (this._eid != null) {
                builder.append("_eid=");
                builder.append(this._eid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

