/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.IpPortLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type.Ip;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IpBuilder
implements Builder<Ip> {
    private IpAddress _ip;
    private PortNumber _port;
    Map<Class<? extends Augmentation<Ip>>, Augmentation<Ip>> augmentation = Collections.emptyMap();

    public IpBuilder() {
    }

    public IpBuilder(IpPortLocator arg) {
        this._ip = arg.getIp();
        this._port = arg.getPort();
    }

    public IpBuilder(Ip base) {
        AugmentationHolder casted;
        this._ip = base.getIp();
        this._port = base.getPort();
        if (base instanceof IpImpl) {
            IpImpl impl = (IpImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ip>>, Augmentation<Ip>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ip>>, Augmentation<Ip>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof IpPortLocator) {
            this._ip = ((IpPortLocator)arg).getIp();
            this._port = ((IpPortLocator)arg).getPort();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.IpPortLocator] \nbut was: " + arg);
        }
    }

    public IpAddress getIp() {
        return this._ip;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public <E extends Augmentation<Ip>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public IpBuilder setIp(IpAddress value) {
        this._ip = value;
        return this;
    }

    public IpBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public IpBuilder addAugmentation(Class<? extends Augmentation<Ip>> augmentationType, Augmentation<Ip> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ip>>, Augmentation<Ip>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IpBuilder removeAugmentation(Class<? extends Augmentation<Ip>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ip build() {
        return new IpImpl(this);
    }

    private static final class IpImpl
    implements Ip {
        private final IpAddress _ip;
        private final PortNumber _port;
        private Map<Class<? extends Augmentation<Ip>>, Augmentation<Ip>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ip> getImplementedInterface() {
            return Ip.class;
        }

        private IpImpl(IpBuilder base) {
            this._ip = base.getIp();
            this._port = base.getPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ip>>, Augmentation<Ip>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ip>>, Augmentation<Ip>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIp() {
            return this._ip;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        public <E extends Augmentation<Ip>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip);
            result = 31 * result + Objects.hashCode(this._port);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ip.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ip other = (Ip)obj;
            if (!Objects.equals(this._ip, other.getIp())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IpImpl otherImpl = (IpImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ip>>, Augmentation<Ip>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Ip [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ip != null) {
                builder.append("_ip=");
                builder.append(this._ip);
                builder.append(", ");
            }
            if (this._port != null) {
                builder.append("_port=");
                builder.append(this._port);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

