/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.FunctionLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.locator.type.Function;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FunctionBuilder
implements Builder<Function> {
    private String _functionName;
    Map<Class<? extends Augmentation<Function>>, Augmentation<Function>> augmentation = Collections.emptyMap();

    public FunctionBuilder() {
    }

    public FunctionBuilder(FunctionLocator arg) {
        this._functionName = arg.getFunctionName();
    }

    public FunctionBuilder(Function base) {
        AugmentationHolder casted;
        this._functionName = base.getFunctionName();
        if (base instanceof FunctionImpl) {
            FunctionImpl impl = (FunctionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Function>>, Augmentation<Function>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Function>>, Augmentation<Function>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof FunctionLocator) {
            this._functionName = ((FunctionLocator)arg).getFunctionName();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.FunctionLocator] \nbut was: " + arg);
        }
    }

    public String getFunctionName() {
        return this._functionName;
    }

    public <E extends Augmentation<Function>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FunctionBuilder setFunctionName(String value) {
        this._functionName = value;
        return this;
    }

    public FunctionBuilder addAugmentation(Class<? extends Augmentation<Function>> augmentationType, Augmentation<Function> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Function>>, Augmentation<Function>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public FunctionBuilder removeAugmentation(Class<? extends Augmentation<Function>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Function build() {
        return new FunctionImpl(this);
    }

    private static final class FunctionImpl
    implements Function {
        private final String _functionName;
        private Map<Class<? extends Augmentation<Function>>, Augmentation<Function>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Function> getImplementedInterface() {
            return Function.class;
        }

        private FunctionImpl(FunctionBuilder base) {
            this._functionName = base.getFunctionName();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Function>>, Augmentation<Function>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Function>>, Augmentation<Function>>(base.augmentation);
                }
            }
        }

        @Override
        public String getFunctionName() {
            return this._functionName;
        }

        public <E extends Augmentation<Function>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._functionName);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Function.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Function other = (Function)obj;
            if (!Objects.equals(this._functionName, other.getFunctionName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FunctionImpl otherImpl = (FunctionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Function>>, Augmentation<Function>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Function [";
            StringBuilder builder = new StringBuilder(name);
            if (this._functionName != null) {
                builder.append("_functionName=");
                builder.append(this._functionName);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

