/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sft.rev140701.service.function.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SftTypeName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sft.rev140701.ServiceFunctionTypeDefinition;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sft.rev140701.service.function.type.definition.SupportedDataplanelocatorTypes;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sft.rev140701.service.function.types.ServiceFunctionType;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sft.rev140701.service.function.types.ServiceFunctionTypeKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sft.rev140701.service.function.types.service.function.type.SftServiceFunctionName;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionTypeBuilder
implements Builder<ServiceFunctionType> {
    private ServiceFunctionTypeKey _key;
    private List<SftServiceFunctionName> _sftServiceFunctionName;
    private List<SupportedDataplanelocatorTypes> _supportedDataplanelocatorTypes;
    private SftTypeName _type;
    private Boolean _bidirectional;
    private Boolean _l2Transparent;
    private Boolean _nshAware;
    private Boolean _requestReclassification;
    Map<Class<? extends Augmentation<ServiceFunctionType>>, Augmentation<ServiceFunctionType>> augmentation = Collections.emptyMap();

    public ServiceFunctionTypeBuilder() {
    }

    public ServiceFunctionTypeBuilder(ServiceFunctionTypeDefinition arg) {
        this._type = arg.getType();
        this._bidirectional = arg.isBidirectional();
        this._nshAware = arg.isNshAware();
        this._requestReclassification = arg.isRequestReclassification();
        this._l2Transparent = arg.isL2Transparent();
        this._supportedDataplanelocatorTypes = arg.getSupportedDataplanelocatorTypes();
    }

    public ServiceFunctionTypeBuilder(ServiceFunctionType base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionTypeKey(base.getType());
            this._type = base.getType();
        } else {
            this._key = base.getKey();
            this._type = this._key.getType();
        }
        this._sftServiceFunctionName = base.getSftServiceFunctionName();
        this._supportedDataplanelocatorTypes = base.getSupportedDataplanelocatorTypes();
        this._bidirectional = base.isBidirectional();
        this._l2Transparent = base.isL2Transparent();
        this._nshAware = base.isNshAware();
        this._requestReclassification = base.isRequestReclassification();
        if (base instanceof ServiceFunctionTypeImpl) {
            ServiceFunctionTypeImpl impl = (ServiceFunctionTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionType>>, Augmentation<ServiceFunctionType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionType>>, Augmentation<ServiceFunctionType>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceFunctionTypeDefinition) {
            this._type = ((ServiceFunctionTypeDefinition)arg).getType();
            this._bidirectional = ((ServiceFunctionTypeDefinition)arg).isBidirectional();
            this._nshAware = ((ServiceFunctionTypeDefinition)arg).isNshAware();
            this._requestReclassification = ((ServiceFunctionTypeDefinition)arg).isRequestReclassification();
            this._l2Transparent = ((ServiceFunctionTypeDefinition)arg).isL2Transparent();
            this._supportedDataplanelocatorTypes = ((ServiceFunctionTypeDefinition)arg).getSupportedDataplanelocatorTypes();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sft.rev140701.ServiceFunctionTypeDefinition] \nbut was: " + arg);
        }
    }

    public ServiceFunctionTypeKey getKey() {
        return this._key;
    }

    public List<SftServiceFunctionName> getSftServiceFunctionName() {
        return this._sftServiceFunctionName;
    }

    public List<SupportedDataplanelocatorTypes> getSupportedDataplanelocatorTypes() {
        return this._supportedDataplanelocatorTypes;
    }

    public SftTypeName getType() {
        return this._type;
    }

    public Boolean isBidirectional() {
        return this._bidirectional;
    }

    public Boolean isL2Transparent() {
        return this._l2Transparent;
    }

    public Boolean isNshAware() {
        return this._nshAware;
    }

    public Boolean isRequestReclassification() {
        return this._requestReclassification;
    }

    public <E extends Augmentation<ServiceFunctionType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionTypeBuilder setKey(ServiceFunctionTypeKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionTypeBuilder setSftServiceFunctionName(List<SftServiceFunctionName> value) {
        this._sftServiceFunctionName = value;
        return this;
    }

    public ServiceFunctionTypeBuilder setSupportedDataplanelocatorTypes(List<SupportedDataplanelocatorTypes> value) {
        this._supportedDataplanelocatorTypes = value;
        return this;
    }

    public ServiceFunctionTypeBuilder setType(SftTypeName value) {
        this._type = value;
        return this;
    }

    public ServiceFunctionTypeBuilder setBidirectional(Boolean value) {
        this._bidirectional = value;
        return this;
    }

    public ServiceFunctionTypeBuilder setL2Transparent(Boolean value) {
        this._l2Transparent = value;
        return this;
    }

    public ServiceFunctionTypeBuilder setNshAware(Boolean value) {
        this._nshAware = value;
        return this;
    }

    public ServiceFunctionTypeBuilder setRequestReclassification(Boolean value) {
        this._requestReclassification = value;
        return this;
    }

    public ServiceFunctionTypeBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionType>> augmentationType, Augmentation<ServiceFunctionType> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionType>>, Augmentation<ServiceFunctionType>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionTypeBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionType build() {
        return new ServiceFunctionTypeImpl(this);
    }

    private static final class ServiceFunctionTypeImpl
    implements ServiceFunctionType {
        private final ServiceFunctionTypeKey _key;
        private final List<SftServiceFunctionName> _sftServiceFunctionName;
        private final List<SupportedDataplanelocatorTypes> _supportedDataplanelocatorTypes;
        private final SftTypeName _type;
        private final Boolean _bidirectional;
        private final Boolean _l2Transparent;
        private final Boolean _nshAware;
        private final Boolean _requestReclassification;
        private Map<Class<? extends Augmentation<ServiceFunctionType>>, Augmentation<ServiceFunctionType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionType> getImplementedInterface() {
            return ServiceFunctionType.class;
        }

        private ServiceFunctionTypeImpl(ServiceFunctionTypeBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionTypeKey(base.getType());
                this._type = base.getType();
            } else {
                this._key = base.getKey();
                this._type = this._key.getType();
            }
            this._sftServiceFunctionName = base.getSftServiceFunctionName();
            this._supportedDataplanelocatorTypes = base.getSupportedDataplanelocatorTypes();
            this._bidirectional = base.isBidirectional();
            this._l2Transparent = base.isL2Transparent();
            this._nshAware = base.isNshAware();
            this._requestReclassification = base.isRequestReclassification();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionType>>, Augmentation<ServiceFunctionType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionType>>, Augmentation<ServiceFunctionType>>(base.augmentation);
                }
            }
        }

        @Override
        public ServiceFunctionTypeKey getKey() {
            return this._key;
        }

        @Override
        public List<SftServiceFunctionName> getSftServiceFunctionName() {
            return this._sftServiceFunctionName;
        }

        @Override
        public List<SupportedDataplanelocatorTypes> getSupportedDataplanelocatorTypes() {
            return this._supportedDataplanelocatorTypes;
        }

        @Override
        public SftTypeName getType() {
            return this._type;
        }

        @Override
        public Boolean isBidirectional() {
            return this._bidirectional;
        }

        @Override
        public Boolean isL2Transparent() {
            return this._l2Transparent;
        }

        @Override
        public Boolean isNshAware() {
            return this._nshAware;
        }

        @Override
        public Boolean isRequestReclassification() {
            return this._requestReclassification;
        }

        public <E extends Augmentation<ServiceFunctionType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._sftServiceFunctionName);
            result = 31 * result + Objects.hashCode(this._supportedDataplanelocatorTypes);
            result = 31 * result + Objects.hashCode(this._type);
            result = 31 * result + Objects.hashCode(this._bidirectional);
            result = 31 * result + Objects.hashCode(this._l2Transparent);
            result = 31 * result + Objects.hashCode(this._nshAware);
            result = 31 * result + Objects.hashCode(this._requestReclassification);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionType other = (ServiceFunctionType)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._sftServiceFunctionName, other.getSftServiceFunctionName())) {
                return false;
            }
            if (!Objects.equals(this._supportedDataplanelocatorTypes, other.getSupportedDataplanelocatorTypes())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (!Objects.equals(this._bidirectional, other.isBidirectional())) {
                return false;
            }
            if (!Objects.equals(this._l2Transparent, other.isL2Transparent())) {
                return false;
            }
            if (!Objects.equals(this._nshAware, other.isNshAware())) {
                return false;
            }
            if (!Objects.equals(this._requestReclassification, other.isRequestReclassification())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionTypeImpl otherImpl = (ServiceFunctionTypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionType>>, Augmentation<ServiceFunctionType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionType [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._sftServiceFunctionName != null) {
                builder.append("_sftServiceFunctionName=");
                builder.append(this._sftServiceFunctionName);
                builder.append(", ");
            }
            if (this._supportedDataplanelocatorTypes != null) {
                builder.append("_supportedDataplanelocatorTypes=");
                builder.append(this._supportedDataplanelocatorTypes);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
                builder.append(", ");
            }
            if (this._bidirectional != null) {
                builder.append("_bidirectional=");
                builder.append(this._bidirectional);
                builder.append(", ");
            }
            if (this._l2Transparent != null) {
                builder.append("_l2Transparent=");
                builder.append(this._l2Transparent);
                builder.append(", ");
            }
            if (this._nshAware != null) {
                builder.append("_nshAware=");
                builder.append(this._nshAware);
                builder.append(", ");
            }
            if (this._requestReclassification != null) {
                builder.append("_requestReclassification=");
                builder.append(this._requestReclassification);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

