/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.service.function.path;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.service.function.path.ServicePathHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.service.function.path.ServicePathHopKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServicePathHopBuilder
implements Builder<ServicePathHop> {
    private Short _hopNumber;
    private ServicePathHopKey _key;
    private SffName _serviceFunctionForwarder;
    private String _serviceFunctionGroupName;
    private SfName _serviceFunctionName;
    private Short _serviceIndex;
    Map<Class<? extends Augmentation<ServicePathHop>>, Augmentation<ServicePathHop>> augmentation = Collections.emptyMap();

    public ServicePathHopBuilder() {
    }

    public ServicePathHopBuilder(ServicePathHop base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServicePathHopKey(base.getHopNumber());
            this._hopNumber = base.getHopNumber();
        } else {
            this._key = base.getKey();
            this._hopNumber = this._key.getHopNumber();
        }
        this._serviceFunctionForwarder = base.getServiceFunctionForwarder();
        this._serviceFunctionGroupName = base.getServiceFunctionGroupName();
        this._serviceFunctionName = base.getServiceFunctionName();
        this._serviceIndex = base.getServiceIndex();
        if (base instanceof ServicePathHopImpl) {
            ServicePathHopImpl impl = (ServicePathHopImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathHop>>, Augmentation<ServicePathHop>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathHop>>, Augmentation<ServicePathHop>>(casted.augmentations());
        }
    }

    public Short getHopNumber() {
        return this._hopNumber;
    }

    public ServicePathHopKey getKey() {
        return this._key;
    }

    public SffName getServiceFunctionForwarder() {
        return this._serviceFunctionForwarder;
    }

    public String getServiceFunctionGroupName() {
        return this._serviceFunctionGroupName;
    }

    public SfName getServiceFunctionName() {
        return this._serviceFunctionName;
    }

    public Short getServiceIndex() {
        return this._serviceIndex;
    }

    public <E extends Augmentation<ServicePathHop>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkHopNumberRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public ServicePathHopBuilder setHopNumber(Short value) {
        if (value != null) {
            ServicePathHopBuilder.checkHopNumberRange(value);
        }
        this._hopNumber = value;
        return this;
    }

    public ServicePathHopBuilder setKey(ServicePathHopKey value) {
        this._key = value;
        return this;
    }

    public ServicePathHopBuilder setServiceFunctionForwarder(SffName value) {
        this._serviceFunctionForwarder = value;
        return this;
    }

    public ServicePathHopBuilder setServiceFunctionGroupName(String value) {
        this._serviceFunctionGroupName = value;
        return this;
    }

    public ServicePathHopBuilder setServiceFunctionName(SfName value) {
        this._serviceFunctionName = value;
        return this;
    }

    private static void checkServiceIndexRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public ServicePathHopBuilder setServiceIndex(Short value) {
        if (value != null) {
            ServicePathHopBuilder.checkServiceIndexRange(value);
        }
        this._serviceIndex = value;
        return this;
    }

    public ServicePathHopBuilder addAugmentation(Class<? extends Augmentation<ServicePathHop>> augmentationType, Augmentation<ServicePathHop> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathHop>>, Augmentation<ServicePathHop>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServicePathHopBuilder removeAugmentation(Class<? extends Augmentation<ServicePathHop>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServicePathHop build() {
        return new ServicePathHopImpl(this);
    }

    private static final class ServicePathHopImpl
    implements ServicePathHop {
        private final Short _hopNumber;
        private final ServicePathHopKey _key;
        private final SffName _serviceFunctionForwarder;
        private final String _serviceFunctionGroupName;
        private final SfName _serviceFunctionName;
        private final Short _serviceIndex;
        private Map<Class<? extends Augmentation<ServicePathHop>>, Augmentation<ServicePathHop>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServicePathHop> getImplementedInterface() {
            return ServicePathHop.class;
        }

        private ServicePathHopImpl(ServicePathHopBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServicePathHopKey(base.getHopNumber());
                this._hopNumber = base.getHopNumber();
            } else {
                this._key = base.getKey();
                this._hopNumber = this._key.getHopNumber();
            }
            this._serviceFunctionForwarder = base.getServiceFunctionForwarder();
            this._serviceFunctionGroupName = base.getServiceFunctionGroupName();
            this._serviceFunctionName = base.getServiceFunctionName();
            this._serviceIndex = base.getServiceIndex();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServicePathHop>>, Augmentation<ServicePathHop>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServicePathHop>>, Augmentation<ServicePathHop>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getHopNumber() {
            return this._hopNumber;
        }

        @Override
        public ServicePathHopKey getKey() {
            return this._key;
        }

        @Override
        public SffName getServiceFunctionForwarder() {
            return this._serviceFunctionForwarder;
        }

        @Override
        public String getServiceFunctionGroupName() {
            return this._serviceFunctionGroupName;
        }

        @Override
        public SfName getServiceFunctionName() {
            return this._serviceFunctionName;
        }

        @Override
        public Short getServiceIndex() {
            return this._serviceIndex;
        }

        public <E extends Augmentation<ServicePathHop>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._hopNumber);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._serviceFunctionForwarder);
            result = 31 * result + Objects.hashCode(this._serviceFunctionGroupName);
            result = 31 * result + Objects.hashCode(this._serviceFunctionName);
            result = 31 * result + Objects.hashCode(this._serviceIndex);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServicePathHop.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServicePathHop other = (ServicePathHop)obj;
            if (!Objects.equals(this._hopNumber, other.getHopNumber())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionForwarder, other.getServiceFunctionForwarder())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionGroupName, other.getServiceFunctionGroupName())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionName, other.getServiceFunctionName())) {
                return false;
            }
            if (!Objects.equals(this._serviceIndex, other.getServiceIndex())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServicePathHopImpl otherImpl = (ServicePathHopImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServicePathHop>>, Augmentation<ServicePathHop>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServicePathHop [";
            StringBuilder builder = new StringBuilder(name);
            if (this._hopNumber != null) {
                builder.append("_hopNumber=");
                builder.append(this._hopNumber);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._serviceFunctionForwarder != null) {
                builder.append("_serviceFunctionForwarder=");
                builder.append(this._serviceFunctionForwarder);
                builder.append(", ");
            }
            if (this._serviceFunctionGroupName != null) {
                builder.append("_serviceFunctionGroupName=");
                builder.append(this._serviceFunctionGroupName);
                builder.append(", ");
            }
            if (this._serviceFunctionName != null) {
                builder.append("_serviceFunctionName=");
                builder.append(this._serviceFunctionName);
                builder.append(", ");
            }
            if (this._serviceIndex != null) {
                builder.append("_serviceIndex=");
                builder.append(this._serviceIndex);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

