/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfcName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfpName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.ServiceFunctionPath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.ServiceFunctionPathKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfp.rev140701.service.function.paths.service.function.path.ServicePathHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.SfcEncapsulationIdentity;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.SlTransportType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionPathBuilder
implements Builder<ServiceFunctionPath> {
    private String _classifier;
    private String _contextMetadata;
    private ServiceFunctionPathKey _key;
    private SfpName _name;
    private Long _pathId;
    private SfcName _serviceChainName;
    private List<ServicePathHop> _servicePathHop;
    private Class<? extends SfcEncapsulationIdentity> _sfcEncapsulation;
    private Short _startingIndex;
    private String _symmetricClassifier;
    private String _tenantId;
    private Class<? extends SlTransportType> _transportType;
    private String _variableMetadata;
    private Boolean _symmetric;
    Map<Class<? extends Augmentation<ServiceFunctionPath>>, Augmentation<ServiceFunctionPath>> augmentation = Collections.emptyMap();

    public ServiceFunctionPathBuilder() {
    }

    public ServiceFunctionPathBuilder(ServiceFunctionPath base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionPathKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._classifier = base.getClassifier();
        this._contextMetadata = base.getContextMetadata();
        this._pathId = base.getPathId();
        this._serviceChainName = base.getServiceChainName();
        this._servicePathHop = base.getServicePathHop();
        this._sfcEncapsulation = base.getSfcEncapsulation();
        this._startingIndex = base.getStartingIndex();
        this._symmetricClassifier = base.getSymmetricClassifier();
        this._tenantId = base.getTenantId();
        this._transportType = base.getTransportType();
        this._variableMetadata = base.getVariableMetadata();
        this._symmetric = base.isSymmetric();
        if (base instanceof ServiceFunctionPathImpl) {
            ServiceFunctionPathImpl impl = (ServiceFunctionPathImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionPath>>, Augmentation<ServiceFunctionPath>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionPath>>, Augmentation<ServiceFunctionPath>>(casted.augmentations());
        }
    }

    public String getClassifier() {
        return this._classifier;
    }

    public String getContextMetadata() {
        return this._contextMetadata;
    }

    public ServiceFunctionPathKey getKey() {
        return this._key;
    }

    public SfpName getName() {
        return this._name;
    }

    public Long getPathId() {
        return this._pathId;
    }

    public SfcName getServiceChainName() {
        return this._serviceChainName;
    }

    public List<ServicePathHop> getServicePathHop() {
        return this._servicePathHop;
    }

    public Class<? extends SfcEncapsulationIdentity> getSfcEncapsulation() {
        return this._sfcEncapsulation;
    }

    public Short getStartingIndex() {
        return this._startingIndex;
    }

    public String getSymmetricClassifier() {
        return this._symmetricClassifier;
    }

    public String getTenantId() {
        return this._tenantId;
    }

    public Class<? extends SlTransportType> getTransportType() {
        return this._transportType;
    }

    public String getVariableMetadata() {
        return this._variableMetadata;
    }

    public Boolean isSymmetric() {
        return this._symmetric;
    }

    public <E extends Augmentation<ServiceFunctionPath>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionPathBuilder setClassifier(String value) {
        this._classifier = value;
        return this;
    }

    public ServiceFunctionPathBuilder setContextMetadata(String value) {
        this._contextMetadata = value;
        return this;
    }

    public ServiceFunctionPathBuilder setKey(ServiceFunctionPathKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionPathBuilder setName(SfpName value) {
        this._name = value;
        return this;
    }

    private static void checkPathIdRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public ServiceFunctionPathBuilder setPathId(Long value) {
        if (value != null) {
            ServiceFunctionPathBuilder.checkPathIdRange(value);
        }
        this._pathId = value;
        return this;
    }

    public ServiceFunctionPathBuilder setServiceChainName(SfcName value) {
        this._serviceChainName = value;
        return this;
    }

    public ServiceFunctionPathBuilder setServicePathHop(List<ServicePathHop> value) {
        this._servicePathHop = value;
        return this;
    }

    public ServiceFunctionPathBuilder setSfcEncapsulation(Class<? extends SfcEncapsulationIdentity> value) {
        this._sfcEncapsulation = value;
        return this;
    }

    private static void checkStartingIndexRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public ServiceFunctionPathBuilder setStartingIndex(Short value) {
        if (value != null) {
            ServiceFunctionPathBuilder.checkStartingIndexRange(value);
        }
        this._startingIndex = value;
        return this;
    }

    public ServiceFunctionPathBuilder setSymmetricClassifier(String value) {
        this._symmetricClassifier = value;
        return this;
    }

    public ServiceFunctionPathBuilder setTenantId(String value) {
        this._tenantId = value;
        return this;
    }

    public ServiceFunctionPathBuilder setTransportType(Class<? extends SlTransportType> value) {
        this._transportType = value;
        return this;
    }

    public ServiceFunctionPathBuilder setVariableMetadata(String value) {
        this._variableMetadata = value;
        return this;
    }

    public ServiceFunctionPathBuilder setSymmetric(Boolean value) {
        this._symmetric = value;
        return this;
    }

    public ServiceFunctionPathBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionPath>> augmentationType, Augmentation<ServiceFunctionPath> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionPath>>, Augmentation<ServiceFunctionPath>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionPathBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionPath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionPath build() {
        return new ServiceFunctionPathImpl(this);
    }

    private static final class ServiceFunctionPathImpl
    implements ServiceFunctionPath {
        private final String _classifier;
        private final String _contextMetadata;
        private final ServiceFunctionPathKey _key;
        private final SfpName _name;
        private final Long _pathId;
        private final SfcName _serviceChainName;
        private final List<ServicePathHop> _servicePathHop;
        private final Class<? extends SfcEncapsulationIdentity> _sfcEncapsulation;
        private final Short _startingIndex;
        private final String _symmetricClassifier;
        private final String _tenantId;
        private final Class<? extends SlTransportType> _transportType;
        private final String _variableMetadata;
        private final Boolean _symmetric;
        private Map<Class<? extends Augmentation<ServiceFunctionPath>>, Augmentation<ServiceFunctionPath>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionPath> getImplementedInterface() {
            return ServiceFunctionPath.class;
        }

        private ServiceFunctionPathImpl(ServiceFunctionPathBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionPathKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._classifier = base.getClassifier();
            this._contextMetadata = base.getContextMetadata();
            this._pathId = base.getPathId();
            this._serviceChainName = base.getServiceChainName();
            this._servicePathHop = base.getServicePathHop();
            this._sfcEncapsulation = base.getSfcEncapsulation();
            this._startingIndex = base.getStartingIndex();
            this._symmetricClassifier = base.getSymmetricClassifier();
            this._tenantId = base.getTenantId();
            this._transportType = base.getTransportType();
            this._variableMetadata = base.getVariableMetadata();
            this._symmetric = base.isSymmetric();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionPath>>, Augmentation<ServiceFunctionPath>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionPath>>, Augmentation<ServiceFunctionPath>>(base.augmentation);
                }
            }
        }

        @Override
        public String getClassifier() {
            return this._classifier;
        }

        @Override
        public String getContextMetadata() {
            return this._contextMetadata;
        }

        @Override
        public ServiceFunctionPathKey getKey() {
            return this._key;
        }

        @Override
        public SfpName getName() {
            return this._name;
        }

        @Override
        public Long getPathId() {
            return this._pathId;
        }

        @Override
        public SfcName getServiceChainName() {
            return this._serviceChainName;
        }

        @Override
        public List<ServicePathHop> getServicePathHop() {
            return this._servicePathHop;
        }

        @Override
        public Class<? extends SfcEncapsulationIdentity> getSfcEncapsulation() {
            return this._sfcEncapsulation;
        }

        @Override
        public Short getStartingIndex() {
            return this._startingIndex;
        }

        @Override
        public String getSymmetricClassifier() {
            return this._symmetricClassifier;
        }

        @Override
        public String getTenantId() {
            return this._tenantId;
        }

        @Override
        public Class<? extends SlTransportType> getTransportType() {
            return this._transportType;
        }

        @Override
        public String getVariableMetadata() {
            return this._variableMetadata;
        }

        @Override
        public Boolean isSymmetric() {
            return this._symmetric;
        }

        public <E extends Augmentation<ServiceFunctionPath>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._classifier);
            result = 31 * result + Objects.hashCode(this._contextMetadata);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._pathId);
            result = 31 * result + Objects.hashCode(this._serviceChainName);
            result = 31 * result + Objects.hashCode(this._servicePathHop);
            result = 31 * result + Objects.hashCode(this._sfcEncapsulation);
            result = 31 * result + Objects.hashCode(this._startingIndex);
            result = 31 * result + Objects.hashCode(this._symmetricClassifier);
            result = 31 * result + Objects.hashCode(this._tenantId);
            result = 31 * result + Objects.hashCode(this._transportType);
            result = 31 * result + Objects.hashCode(this._variableMetadata);
            result = 31 * result + Objects.hashCode(this._symmetric);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionPath.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionPath other = (ServiceFunctionPath)obj;
            if (!Objects.equals(this._classifier, other.getClassifier())) {
                return false;
            }
            if (!Objects.equals(this._contextMetadata, other.getContextMetadata())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (!Objects.equals(this._serviceChainName, other.getServiceChainName())) {
                return false;
            }
            if (!Objects.equals(this._servicePathHop, other.getServicePathHop())) {
                return false;
            }
            if (!Objects.equals(this._sfcEncapsulation, other.getSfcEncapsulation())) {
                return false;
            }
            if (!Objects.equals(this._startingIndex, other.getStartingIndex())) {
                return false;
            }
            if (!Objects.equals(this._symmetricClassifier, other.getSymmetricClassifier())) {
                return false;
            }
            if (!Objects.equals(this._tenantId, other.getTenantId())) {
                return false;
            }
            if (!Objects.equals(this._transportType, other.getTransportType())) {
                return false;
            }
            if (!Objects.equals(this._variableMetadata, other.getVariableMetadata())) {
                return false;
            }
            if (!Objects.equals(this._symmetric, other.isSymmetric())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionPathImpl otherImpl = (ServiceFunctionPathImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionPath>>, Augmentation<ServiceFunctionPath>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionPath [";
            StringBuilder builder = new StringBuilder(name);
            if (this._classifier != null) {
                builder.append("_classifier=");
                builder.append(this._classifier);
                builder.append(", ");
            }
            if (this._contextMetadata != null) {
                builder.append("_contextMetadata=");
                builder.append(this._contextMetadata);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._pathId != null) {
                builder.append("_pathId=");
                builder.append(this._pathId);
                builder.append(", ");
            }
            if (this._serviceChainName != null) {
                builder.append("_serviceChainName=");
                builder.append(this._serviceChainName);
                builder.append(", ");
            }
            if (this._servicePathHop != null) {
                builder.append("_servicePathHop=");
                builder.append(this._servicePathHop);
                builder.append(", ");
            }
            if (this._sfcEncapsulation != null) {
                builder.append("_sfcEncapsulation=");
                builder.append(this._sfcEncapsulation);
                builder.append(", ");
            }
            if (this._startingIndex != null) {
                builder.append("_startingIndex=");
                builder.append(this._startingIndex);
                builder.append(", ");
            }
            if (this._symmetricClassifier != null) {
                builder.append("_symmetricClassifier=");
                builder.append(this._symmetricClassifier);
                builder.append(", ");
            }
            if (this._tenantId != null) {
                builder.append("_tenantId=");
                builder.append(this._tenantId);
                builder.append(", ");
            }
            if (this._transportType != null) {
                builder.append("_transportType=");
                builder.append(this._transportType);
                builder.append(", ");
            }
            if (this._variableMetadata != null) {
                builder.append("_variableMetadata=");
                builder.append(this._variableMetadata);
                builder.append(", ");
            }
            if (this._symmetric != null) {
                builder.append("_symmetric=");
                builder.append(this._symmetric);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

