/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.rev150214.service.function.groups;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SftTypeName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.rev150214.ServiceFunctionGroupEntry;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.rev150214.service.function.group.entry.SfcServiceFunction;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.rev150214.service.function.groups.ServiceFunctionGroup;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.rev150214.service.function.groups.ServiceFunctionGroupKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionGroupBuilder
implements Builder<ServiceFunctionGroup> {
    private String _algorithm;
    private Long _groupId;
    private IpAddress _ipMgmtAddress;
    private ServiceFunctionGroupKey _key;
    private String _name;
    private Uri _restUri;
    private List<SfcServiceFunction> _sfcServiceFunction;
    private SftTypeName _type;
    Map<Class<? extends Augmentation<ServiceFunctionGroup>>, Augmentation<ServiceFunctionGroup>> augmentation = Collections.emptyMap();

    public ServiceFunctionGroupBuilder() {
    }

    public ServiceFunctionGroupBuilder(ServiceFunctionGroupEntry arg) {
        this._name = arg.getName();
        this._groupId = arg.getGroupId();
        this._algorithm = arg.getAlgorithm();
        this._restUri = arg.getRestUri();
        this._ipMgmtAddress = arg.getIpMgmtAddress();
        this._type = arg.getType();
        this._sfcServiceFunction = arg.getSfcServiceFunction();
    }

    public ServiceFunctionGroupBuilder(ServiceFunctionGroup base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionGroupKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._algorithm = base.getAlgorithm();
        this._groupId = base.getGroupId();
        this._ipMgmtAddress = base.getIpMgmtAddress();
        this._restUri = base.getRestUri();
        this._sfcServiceFunction = base.getSfcServiceFunction();
        this._type = base.getType();
        if (base instanceof ServiceFunctionGroupImpl) {
            ServiceFunctionGroupImpl impl = (ServiceFunctionGroupImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionGroup>>, Augmentation<ServiceFunctionGroup>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionGroup>>, Augmentation<ServiceFunctionGroup>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceFunctionGroupEntry) {
            this._name = ((ServiceFunctionGroupEntry)arg).getName();
            this._groupId = ((ServiceFunctionGroupEntry)arg).getGroupId();
            this._algorithm = ((ServiceFunctionGroupEntry)arg).getAlgorithm();
            this._restUri = ((ServiceFunctionGroupEntry)arg).getRestUri();
            this._ipMgmtAddress = ((ServiceFunctionGroupEntry)arg).getIpMgmtAddress();
            this._type = ((ServiceFunctionGroupEntry)arg).getType();
            this._sfcServiceFunction = ((ServiceFunctionGroupEntry)arg).getSfcServiceFunction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.rev150214.ServiceFunctionGroupEntry] \nbut was: " + arg);
        }
    }

    public String getAlgorithm() {
        return this._algorithm;
    }

    public Long getGroupId() {
        return this._groupId;
    }

    public IpAddress getIpMgmtAddress() {
        return this._ipMgmtAddress;
    }

    public ServiceFunctionGroupKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public Uri getRestUri() {
        return this._restUri;
    }

    public List<SfcServiceFunction> getSfcServiceFunction() {
        return this._sfcServiceFunction;
    }

    public SftTypeName getType() {
        return this._type;
    }

    public <E extends Augmentation<ServiceFunctionGroup>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionGroupBuilder setAlgorithm(String value) {
        this._algorithm = value;
        return this;
    }

    private static void checkGroupIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ServiceFunctionGroupBuilder setGroupId(Long value) {
        if (value != null) {
            ServiceFunctionGroupBuilder.checkGroupIdRange(value);
        }
        this._groupId = value;
        return this;
    }

    public ServiceFunctionGroupBuilder setIpMgmtAddress(IpAddress value) {
        this._ipMgmtAddress = value;
        return this;
    }

    public ServiceFunctionGroupBuilder setKey(ServiceFunctionGroupKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionGroupBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ServiceFunctionGroupBuilder setRestUri(Uri value) {
        this._restUri = value;
        return this;
    }

    public ServiceFunctionGroupBuilder setSfcServiceFunction(List<SfcServiceFunction> value) {
        this._sfcServiceFunction = value;
        return this;
    }

    public ServiceFunctionGroupBuilder setType(SftTypeName value) {
        this._type = value;
        return this;
    }

    public ServiceFunctionGroupBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionGroup>> augmentationType, Augmentation<ServiceFunctionGroup> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionGroup>>, Augmentation<ServiceFunctionGroup>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionGroupBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionGroup>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionGroup build() {
        return new ServiceFunctionGroupImpl(this);
    }

    private static final class ServiceFunctionGroupImpl
    implements ServiceFunctionGroup {
        private final String _algorithm;
        private final Long _groupId;
        private final IpAddress _ipMgmtAddress;
        private final ServiceFunctionGroupKey _key;
        private final String _name;
        private final Uri _restUri;
        private final List<SfcServiceFunction> _sfcServiceFunction;
        private final SftTypeName _type;
        private Map<Class<? extends Augmentation<ServiceFunctionGroup>>, Augmentation<ServiceFunctionGroup>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionGroup> getImplementedInterface() {
            return ServiceFunctionGroup.class;
        }

        private ServiceFunctionGroupImpl(ServiceFunctionGroupBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionGroupKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._algorithm = base.getAlgorithm();
            this._groupId = base.getGroupId();
            this._ipMgmtAddress = base.getIpMgmtAddress();
            this._restUri = base.getRestUri();
            this._sfcServiceFunction = base.getSfcServiceFunction();
            this._type = base.getType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionGroup>>, Augmentation<ServiceFunctionGroup>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionGroup>>, Augmentation<ServiceFunctionGroup>>(base.augmentation);
                }
            }
        }

        @Override
        public String getAlgorithm() {
            return this._algorithm;
        }

        @Override
        public Long getGroupId() {
            return this._groupId;
        }

        @Override
        public IpAddress getIpMgmtAddress() {
            return this._ipMgmtAddress;
        }

        @Override
        public ServiceFunctionGroupKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Uri getRestUri() {
            return this._restUri;
        }

        @Override
        public List<SfcServiceFunction> getSfcServiceFunction() {
            return this._sfcServiceFunction;
        }

        @Override
        public SftTypeName getType() {
            return this._type;
        }

        public <E extends Augmentation<ServiceFunctionGroup>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._algorithm);
            result = 31 * result + Objects.hashCode(this._groupId);
            result = 31 * result + Objects.hashCode(this._ipMgmtAddress);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._restUri);
            result = 31 * result + Objects.hashCode(this._sfcServiceFunction);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionGroup.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionGroup other = (ServiceFunctionGroup)obj;
            if (!Objects.equals(this._algorithm, other.getAlgorithm())) {
                return false;
            }
            if (!Objects.equals(this._groupId, other.getGroupId())) {
                return false;
            }
            if (!Objects.equals(this._ipMgmtAddress, other.getIpMgmtAddress())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._restUri, other.getRestUri())) {
                return false;
            }
            if (!Objects.equals(this._sfcServiceFunction, other.getSfcServiceFunction())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionGroupImpl otherImpl = (ServiceFunctionGroupImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionGroup>>, Augmentation<ServiceFunctionGroup>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionGroup [";
            StringBuilder builder = new StringBuilder(name);
            if (this._algorithm != null) {
                builder.append("_algorithm=");
                builder.append(this._algorithm);
                builder.append(", ");
            }
            if (this._groupId != null) {
                builder.append("_groupId=");
                builder.append(this._groupId);
                builder.append(", ");
            }
            if (this._ipMgmtAddress != null) {
                builder.append("_ipMgmtAddress=");
                builder.append(this._ipMgmtAddress);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._restUri != null) {
                builder.append("_restUri=");
                builder.append(this._restUri);
                builder.append(", ");
            }
            if (this._sfcServiceFunction != null) {
                builder.append("_sfcServiceFunction=");
                builder.append(this._sfcServiceFunction);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

