/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.alg.rev150214.service.function.group.algorithms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.alg.rev150214.ServiceFunctionGroupAlgorithmEntry;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.alg.rev150214.service.function.group.algorithms.ServiceFunctionGroupAlgorithm;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.alg.rev150214.service.function.group.algorithms.ServiceFunctionGroupAlgorithmKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionGroupAlgorithmBuilder
implements Builder<ServiceFunctionGroupAlgorithm> {
    private ServiceFunctionGroupAlgorithmEntry.AlgorithmType _algorithmType;
    private ServiceFunctionGroupAlgorithmKey _key;
    private String _name;
    Map<Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>>, Augmentation<ServiceFunctionGroupAlgorithm>> augmentation = Collections.emptyMap();

    public ServiceFunctionGroupAlgorithmBuilder() {
    }

    public ServiceFunctionGroupAlgorithmBuilder(ServiceFunctionGroupAlgorithmEntry arg) {
        this._name = arg.getName();
        this._algorithmType = arg.getAlgorithmType();
    }

    public ServiceFunctionGroupAlgorithmBuilder(ServiceFunctionGroupAlgorithm base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionGroupAlgorithmKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._algorithmType = base.getAlgorithmType();
        if (base instanceof ServiceFunctionGroupAlgorithmImpl) {
            ServiceFunctionGroupAlgorithmImpl impl = (ServiceFunctionGroupAlgorithmImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>>, Augmentation<ServiceFunctionGroupAlgorithm>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>>, Augmentation<ServiceFunctionGroupAlgorithm>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceFunctionGroupAlgorithmEntry) {
            this._name = ((ServiceFunctionGroupAlgorithmEntry)arg).getName();
            this._algorithmType = ((ServiceFunctionGroupAlgorithmEntry)arg).getAlgorithmType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfg.alg.rev150214.ServiceFunctionGroupAlgorithmEntry] \nbut was: " + arg);
        }
    }

    public ServiceFunctionGroupAlgorithmEntry.AlgorithmType getAlgorithmType() {
        return this._algorithmType;
    }

    public ServiceFunctionGroupAlgorithmKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public <E extends Augmentation<ServiceFunctionGroupAlgorithm>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionGroupAlgorithmBuilder setAlgorithmType(ServiceFunctionGroupAlgorithmEntry.AlgorithmType value) {
        this._algorithmType = value;
        return this;
    }

    public ServiceFunctionGroupAlgorithmBuilder setKey(ServiceFunctionGroupAlgorithmKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionGroupAlgorithmBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ServiceFunctionGroupAlgorithmBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>> augmentationType, Augmentation<ServiceFunctionGroupAlgorithm> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>>, Augmentation<ServiceFunctionGroupAlgorithm>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionGroupAlgorithmBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionGroupAlgorithm build() {
        return new ServiceFunctionGroupAlgorithmImpl(this);
    }

    private static final class ServiceFunctionGroupAlgorithmImpl
    implements ServiceFunctionGroupAlgorithm {
        private final ServiceFunctionGroupAlgorithmEntry.AlgorithmType _algorithmType;
        private final ServiceFunctionGroupAlgorithmKey _key;
        private final String _name;
        private Map<Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>>, Augmentation<ServiceFunctionGroupAlgorithm>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionGroupAlgorithm> getImplementedInterface() {
            return ServiceFunctionGroupAlgorithm.class;
        }

        private ServiceFunctionGroupAlgorithmImpl(ServiceFunctionGroupAlgorithmBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionGroupAlgorithmKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._algorithmType = base.getAlgorithmType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>>, Augmentation<ServiceFunctionGroupAlgorithm>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>>, Augmentation<ServiceFunctionGroupAlgorithm>>(base.augmentation);
                }
            }
        }

        @Override
        public ServiceFunctionGroupAlgorithmEntry.AlgorithmType getAlgorithmType() {
            return this._algorithmType;
        }

        @Override
        public ServiceFunctionGroupAlgorithmKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public <E extends Augmentation<ServiceFunctionGroupAlgorithm>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._algorithmType);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionGroupAlgorithm.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionGroupAlgorithm other = (ServiceFunctionGroupAlgorithm)obj;
            if (!Objects.equals((Object)this._algorithmType, (Object)other.getAlgorithmType())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionGroupAlgorithmImpl otherImpl = (ServiceFunctionGroupAlgorithmImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionGroupAlgorithm>>, Augmentation<ServiceFunctionGroupAlgorithm>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionGroupAlgorithm [";
            StringBuilder builder = new StringBuilder(name);
            if (this._algorithmType != null) {
                builder.append("_algorithmType=");
                builder.append((Object)this._algorithmType);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

