/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.service.function.forwarder;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.FailmodeTypeIdentity;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.service.function.forwarder.ServiceFunctionDictionary;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.service.function.forwarder.ServiceFunctionDictionaryKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.service.function.forwarder.service.function.dictionary.SffInterfaces;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.service.function.forwarder.service.function.dictionary.SffSfDataPlaneLocator;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionDictionaryBuilder
implements Builder<ServiceFunctionDictionary> {
    private Class<? extends FailmodeTypeIdentity> _failmode;
    private ServiceFunctionDictionaryKey _key;
    private SfName _name;
    private List<SffInterfaces> _sffInterfaces;
    private SffSfDataPlaneLocator _sffSfDataPlaneLocator;
    Map<Class<? extends Augmentation<ServiceFunctionDictionary>>, Augmentation<ServiceFunctionDictionary>> augmentation = Collections.emptyMap();

    public ServiceFunctionDictionaryBuilder() {
    }

    public ServiceFunctionDictionaryBuilder(ServiceFunctionDictionary base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionDictionaryKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._failmode = base.getFailmode();
        this._sffInterfaces = base.getSffInterfaces();
        this._sffSfDataPlaneLocator = base.getSffSfDataPlaneLocator();
        if (base instanceof ServiceFunctionDictionaryImpl) {
            ServiceFunctionDictionaryImpl impl = (ServiceFunctionDictionaryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionDictionary>>, Augmentation<ServiceFunctionDictionary>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionDictionary>>, Augmentation<ServiceFunctionDictionary>>(casted.augmentations());
        }
    }

    public Class<? extends FailmodeTypeIdentity> getFailmode() {
        return this._failmode;
    }

    public ServiceFunctionDictionaryKey getKey() {
        return this._key;
    }

    public SfName getName() {
        return this._name;
    }

    public List<SffInterfaces> getSffInterfaces() {
        return this._sffInterfaces;
    }

    public SffSfDataPlaneLocator getSffSfDataPlaneLocator() {
        return this._sffSfDataPlaneLocator;
    }

    public <E extends Augmentation<ServiceFunctionDictionary>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionDictionaryBuilder setFailmode(Class<? extends FailmodeTypeIdentity> value) {
        this._failmode = value;
        return this;
    }

    public ServiceFunctionDictionaryBuilder setKey(ServiceFunctionDictionaryKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionDictionaryBuilder setName(SfName value) {
        this._name = value;
        return this;
    }

    public ServiceFunctionDictionaryBuilder setSffInterfaces(List<SffInterfaces> value) {
        this._sffInterfaces = value;
        return this;
    }

    public ServiceFunctionDictionaryBuilder setSffSfDataPlaneLocator(SffSfDataPlaneLocator value) {
        this._sffSfDataPlaneLocator = value;
        return this;
    }

    public ServiceFunctionDictionaryBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionDictionary>> augmentationType, Augmentation<ServiceFunctionDictionary> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionDictionary>>, Augmentation<ServiceFunctionDictionary>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionDictionaryBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionDictionary>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionDictionary build() {
        return new ServiceFunctionDictionaryImpl(this);
    }

    private static final class ServiceFunctionDictionaryImpl
    implements ServiceFunctionDictionary {
        private final Class<? extends FailmodeTypeIdentity> _failmode;
        private final ServiceFunctionDictionaryKey _key;
        private final SfName _name;
        private final List<SffInterfaces> _sffInterfaces;
        private final SffSfDataPlaneLocator _sffSfDataPlaneLocator;
        private Map<Class<? extends Augmentation<ServiceFunctionDictionary>>, Augmentation<ServiceFunctionDictionary>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionDictionary> getImplementedInterface() {
            return ServiceFunctionDictionary.class;
        }

        private ServiceFunctionDictionaryImpl(ServiceFunctionDictionaryBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionDictionaryKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._failmode = base.getFailmode();
            this._sffInterfaces = base.getSffInterfaces();
            this._sffSfDataPlaneLocator = base.getSffSfDataPlaneLocator();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionDictionary>>, Augmentation<ServiceFunctionDictionary>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionDictionary>>, Augmentation<ServiceFunctionDictionary>>(base.augmentation);
                }
            }
        }

        @Override
        public Class<? extends FailmodeTypeIdentity> getFailmode() {
            return this._failmode;
        }

        @Override
        public ServiceFunctionDictionaryKey getKey() {
            return this._key;
        }

        @Override
        public SfName getName() {
            return this._name;
        }

        @Override
        public List<SffInterfaces> getSffInterfaces() {
            return this._sffInterfaces;
        }

        @Override
        public SffSfDataPlaneLocator getSffSfDataPlaneLocator() {
            return this._sffSfDataPlaneLocator;
        }

        public <E extends Augmentation<ServiceFunctionDictionary>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._failmode);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._sffInterfaces);
            result = 31 * result + Objects.hashCode(this._sffSfDataPlaneLocator);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionDictionary.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionDictionary other = (ServiceFunctionDictionary)obj;
            if (!Objects.equals(this._failmode, other.getFailmode())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._sffInterfaces, other.getSffInterfaces())) {
                return false;
            }
            if (!Objects.equals(this._sffSfDataPlaneLocator, other.getSffSfDataPlaneLocator())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionDictionaryImpl otherImpl = (ServiceFunctionDictionaryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionDictionary>>, Augmentation<ServiceFunctionDictionary>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionDictionary [";
            StringBuilder builder = new StringBuilder(name);
            if (this._failmode != null) {
                builder.append("_failmode=");
                builder.append(this._failmode);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._sffInterfaces != null) {
                builder.append("_sffInterfaces=");
                builder.append(this._sffInterfaces);
                builder.append(", ");
            }
            if (this._sffSfDataPlaneLocator != null) {
                builder.append("_sffSfDataPlaneLocator=");
                builder.append(this._sffSfDataPlaneLocator);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

