/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SnName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.ServiceFunctionForwarderBase;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarder.base.SffDataPlaneLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.ServiceFunctionForwarder;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.ServiceFunctionForwarderKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.service.function.forwarder.ConnectedSffDictionary;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.service.function.forwarders.service.function.forwarder.ServiceFunctionDictionary;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionForwarderBuilder
implements Builder<ServiceFunctionForwarder> {
    private List<ConnectedSffDictionary> _connectedSffDictionary;
    private IpAddress _ipMgmtAddress;
    private ServiceFunctionForwarderKey _key;
    private SffName _name;
    private Uri _restUri;
    private List<ServiceFunctionDictionary> _serviceFunctionDictionary;
    private SnName _serviceNode;
    private List<SffDataPlaneLocator> _sffDataPlaneLocator;
    Map<Class<? extends Augmentation<ServiceFunctionForwarder>>, Augmentation<ServiceFunctionForwarder>> augmentation = Collections.emptyMap();

    public ServiceFunctionForwarderBuilder() {
    }

    public ServiceFunctionForwarderBuilder(ServiceFunctionForwarderBase arg) {
        this._name = arg.getName();
        this._serviceNode = arg.getServiceNode();
        this._ipMgmtAddress = arg.getIpMgmtAddress();
        this._sffDataPlaneLocator = arg.getSffDataPlaneLocator();
    }

    public ServiceFunctionForwarderBuilder(ServiceFunctionForwarder base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionForwarderKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._connectedSffDictionary = base.getConnectedSffDictionary();
        this._ipMgmtAddress = base.getIpMgmtAddress();
        this._restUri = base.getRestUri();
        this._serviceFunctionDictionary = base.getServiceFunctionDictionary();
        this._serviceNode = base.getServiceNode();
        this._sffDataPlaneLocator = base.getSffDataPlaneLocator();
        if (base instanceof ServiceFunctionForwarderImpl) {
            ServiceFunctionForwarderImpl impl = (ServiceFunctionForwarderImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionForwarder>>, Augmentation<ServiceFunctionForwarder>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionForwarder>>, Augmentation<ServiceFunctionForwarder>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceFunctionForwarderBase) {
            this._name = ((ServiceFunctionForwarderBase)arg).getName();
            this._serviceNode = ((ServiceFunctionForwarderBase)arg).getServiceNode();
            this._ipMgmtAddress = ((ServiceFunctionForwarderBase)arg).getIpMgmtAddress();
            this._sffDataPlaneLocator = ((ServiceFunctionForwarderBase)arg).getSffDataPlaneLocator();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.rev140701.ServiceFunctionForwarderBase] \nbut was: " + arg);
        }
    }

    public List<ConnectedSffDictionary> getConnectedSffDictionary() {
        return this._connectedSffDictionary;
    }

    public IpAddress getIpMgmtAddress() {
        return this._ipMgmtAddress;
    }

    public ServiceFunctionForwarderKey getKey() {
        return this._key;
    }

    public SffName getName() {
        return this._name;
    }

    public Uri getRestUri() {
        return this._restUri;
    }

    public List<ServiceFunctionDictionary> getServiceFunctionDictionary() {
        return this._serviceFunctionDictionary;
    }

    public SnName getServiceNode() {
        return this._serviceNode;
    }

    public List<SffDataPlaneLocator> getSffDataPlaneLocator() {
        return this._sffDataPlaneLocator;
    }

    public <E extends Augmentation<ServiceFunctionForwarder>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionForwarderBuilder setConnectedSffDictionary(List<ConnectedSffDictionary> value) {
        this._connectedSffDictionary = value;
        return this;
    }

    public ServiceFunctionForwarderBuilder setIpMgmtAddress(IpAddress value) {
        this._ipMgmtAddress = value;
        return this;
    }

    public ServiceFunctionForwarderBuilder setKey(ServiceFunctionForwarderKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionForwarderBuilder setName(SffName value) {
        this._name = value;
        return this;
    }

    public ServiceFunctionForwarderBuilder setRestUri(Uri value) {
        this._restUri = value;
        return this;
    }

    public ServiceFunctionForwarderBuilder setServiceFunctionDictionary(List<ServiceFunctionDictionary> value) {
        this._serviceFunctionDictionary = value;
        return this;
    }

    public ServiceFunctionForwarderBuilder setServiceNode(SnName value) {
        this._serviceNode = value;
        return this;
    }

    public ServiceFunctionForwarderBuilder setSffDataPlaneLocator(List<SffDataPlaneLocator> value) {
        this._sffDataPlaneLocator = value;
        return this;
    }

    public ServiceFunctionForwarderBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionForwarder>> augmentationType, Augmentation<ServiceFunctionForwarder> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionForwarder>>, Augmentation<ServiceFunctionForwarder>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionForwarderBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionForwarder>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionForwarder build() {
        return new ServiceFunctionForwarderImpl(this);
    }

    private static final class ServiceFunctionForwarderImpl
    implements ServiceFunctionForwarder {
        private final List<ConnectedSffDictionary> _connectedSffDictionary;
        private final IpAddress _ipMgmtAddress;
        private final ServiceFunctionForwarderKey _key;
        private final SffName _name;
        private final Uri _restUri;
        private final List<ServiceFunctionDictionary> _serviceFunctionDictionary;
        private final SnName _serviceNode;
        private final List<SffDataPlaneLocator> _sffDataPlaneLocator;
        private Map<Class<? extends Augmentation<ServiceFunctionForwarder>>, Augmentation<ServiceFunctionForwarder>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionForwarder> getImplementedInterface() {
            return ServiceFunctionForwarder.class;
        }

        private ServiceFunctionForwarderImpl(ServiceFunctionForwarderBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionForwarderKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._connectedSffDictionary = base.getConnectedSffDictionary();
            this._ipMgmtAddress = base.getIpMgmtAddress();
            this._restUri = base.getRestUri();
            this._serviceFunctionDictionary = base.getServiceFunctionDictionary();
            this._serviceNode = base.getServiceNode();
            this._sffDataPlaneLocator = base.getSffDataPlaneLocator();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionForwarder>>, Augmentation<ServiceFunctionForwarder>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionForwarder>>, Augmentation<ServiceFunctionForwarder>>(base.augmentation);
                }
            }
        }

        @Override
        public List<ConnectedSffDictionary> getConnectedSffDictionary() {
            return this._connectedSffDictionary;
        }

        @Override
        public IpAddress getIpMgmtAddress() {
            return this._ipMgmtAddress;
        }

        @Override
        public ServiceFunctionForwarderKey getKey() {
            return this._key;
        }

        @Override
        public SffName getName() {
            return this._name;
        }

        @Override
        public Uri getRestUri() {
            return this._restUri;
        }

        @Override
        public List<ServiceFunctionDictionary> getServiceFunctionDictionary() {
            return this._serviceFunctionDictionary;
        }

        @Override
        public SnName getServiceNode() {
            return this._serviceNode;
        }

        @Override
        public List<SffDataPlaneLocator> getSffDataPlaneLocator() {
            return this._sffDataPlaneLocator;
        }

        public <E extends Augmentation<ServiceFunctionForwarder>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._connectedSffDictionary);
            result = 31 * result + Objects.hashCode(this._ipMgmtAddress);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._restUri);
            result = 31 * result + Objects.hashCode(this._serviceFunctionDictionary);
            result = 31 * result + Objects.hashCode(this._serviceNode);
            result = 31 * result + Objects.hashCode(this._sffDataPlaneLocator);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionForwarder.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionForwarder other = (ServiceFunctionForwarder)obj;
            if (!Objects.equals(this._connectedSffDictionary, other.getConnectedSffDictionary())) {
                return false;
            }
            if (!Objects.equals(this._ipMgmtAddress, other.getIpMgmtAddress())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._restUri, other.getRestUri())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionDictionary, other.getServiceFunctionDictionary())) {
                return false;
            }
            if (!Objects.equals(this._serviceNode, other.getServiceNode())) {
                return false;
            }
            if (!Objects.equals(this._sffDataPlaneLocator, other.getSffDataPlaneLocator())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionForwarderImpl otherImpl = (ServiceFunctionForwarderImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionForwarder>>, Augmentation<ServiceFunctionForwarder>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionForwarder [";
            StringBuilder builder = new StringBuilder(name);
            if (this._connectedSffDictionary != null) {
                builder.append("_connectedSffDictionary=");
                builder.append(this._connectedSffDictionary);
                builder.append(", ");
            }
            if (this._ipMgmtAddress != null) {
                builder.append("_ipMgmtAddress=");
                builder.append(this._ipMgmtAddress);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._restUri != null) {
                builder.append("_restUri=");
                builder.append(this._restUri);
                builder.append(", ");
            }
            if (this._serviceFunctionDictionary != null) {
                builder.append("_serviceFunctionDictionary=");
                builder.append(this._serviceFunctionDictionary);
                builder.append(", ");
            }
            if (this._serviceNode != null) {
                builder.append("_serviceNode=");
                builder.append(this._serviceNode);
                builder.append(", ");
            }
            if (this._sffDataPlaneLocator != null) {
                builder.append("_sffDataPlaneLocator=");
                builder.append(this._sffDataPlaneLocator);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

