/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.ovs.rev140701.sff.ovs.mappings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.ovs.rev140701.sff.ovs.mappings.OvsNodeToSffMapping;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.ovs.rev140701.sff.ovs.mappings.OvsNodeToSffMappingKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OvsNodeToSffMappingBuilder
implements Builder<OvsNodeToSffMapping> {
    private String _bridgeName;
    private OvsNodeToSffMappingKey _key;
    private SffName _name;
    private Uuid _uuid;
    Map<Class<? extends Augmentation<OvsNodeToSffMapping>>, Augmentation<OvsNodeToSffMapping>> augmentation = Collections.emptyMap();

    public OvsNodeToSffMappingBuilder() {
    }

    public OvsNodeToSffMappingBuilder(OvsNodeToSffMapping base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new OvsNodeToSffMappingKey(base.getBridgeName(), base.getUuid());
            this._bridgeName = base.getBridgeName();
            this._uuid = base.getUuid();
        } else {
            this._key = base.getKey();
            this._bridgeName = this._key.getBridgeName();
            this._uuid = this._key.getUuid();
        }
        this._name = base.getName();
        if (base instanceof OvsNodeToSffMappingImpl) {
            OvsNodeToSffMappingImpl impl = (OvsNodeToSffMappingImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OvsNodeToSffMapping>>, Augmentation<OvsNodeToSffMapping>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OvsNodeToSffMapping>>, Augmentation<OvsNodeToSffMapping>>(casted.augmentations());
        }
    }

    public String getBridgeName() {
        return this._bridgeName;
    }

    public OvsNodeToSffMappingKey getKey() {
        return this._key;
    }

    public SffName getName() {
        return this._name;
    }

    public Uuid getUuid() {
        return this._uuid;
    }

    public <E extends Augmentation<OvsNodeToSffMapping>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OvsNodeToSffMappingBuilder setBridgeName(String value) {
        this._bridgeName = value;
        return this;
    }

    public OvsNodeToSffMappingBuilder setKey(OvsNodeToSffMappingKey value) {
        this._key = value;
        return this;
    }

    public OvsNodeToSffMappingBuilder setName(SffName value) {
        this._name = value;
        return this;
    }

    public OvsNodeToSffMappingBuilder setUuid(Uuid value) {
        this._uuid = value;
        return this;
    }

    public OvsNodeToSffMappingBuilder addAugmentation(Class<? extends Augmentation<OvsNodeToSffMapping>> augmentationType, Augmentation<OvsNodeToSffMapping> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OvsNodeToSffMapping>>, Augmentation<OvsNodeToSffMapping>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OvsNodeToSffMappingBuilder removeAugmentation(Class<? extends Augmentation<OvsNodeToSffMapping>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OvsNodeToSffMapping build() {
        return new OvsNodeToSffMappingImpl(this);
    }

    private static final class OvsNodeToSffMappingImpl
    implements OvsNodeToSffMapping {
        private final String _bridgeName;
        private final OvsNodeToSffMappingKey _key;
        private final SffName _name;
        private final Uuid _uuid;
        private Map<Class<? extends Augmentation<OvsNodeToSffMapping>>, Augmentation<OvsNodeToSffMapping>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OvsNodeToSffMapping> getImplementedInterface() {
            return OvsNodeToSffMapping.class;
        }

        private OvsNodeToSffMappingImpl(OvsNodeToSffMappingBuilder base) {
            if (base.getKey() == null) {
                this._key = new OvsNodeToSffMappingKey(base.getBridgeName(), base.getUuid());
                this._bridgeName = base.getBridgeName();
                this._uuid = base.getUuid();
            } else {
                this._key = base.getKey();
                this._bridgeName = this._key.getBridgeName();
                this._uuid = this._key.getUuid();
            }
            this._name = base.getName();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OvsNodeToSffMapping>>, Augmentation<OvsNodeToSffMapping>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OvsNodeToSffMapping>>, Augmentation<OvsNodeToSffMapping>>(base.augmentation);
                }
            }
        }

        @Override
        public String getBridgeName() {
            return this._bridgeName;
        }

        @Override
        public OvsNodeToSffMappingKey getKey() {
            return this._key;
        }

        @Override
        public SffName getName() {
            return this._name;
        }

        @Override
        public Uuid getUuid() {
            return this._uuid;
        }

        public <E extends Augmentation<OvsNodeToSffMapping>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bridgeName);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._uuid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OvsNodeToSffMapping.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OvsNodeToSffMapping other = (OvsNodeToSffMapping)obj;
            if (!Objects.equals(this._bridgeName, other.getBridgeName())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._uuid, other.getUuid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OvsNodeToSffMappingImpl otherImpl = (OvsNodeToSffMappingImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OvsNodeToSffMapping>>, Augmentation<OvsNodeToSffMapping>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "OvsNodeToSffMapping [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bridgeName != null) {
                builder.append("_bridgeName=");
                builder.append(this._bridgeName);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._uuid != null) {
                builder.append("_uuid=");
                builder.append(this._uuid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

