/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.ovs.rev140701.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.ovs.rev140701.node.OvsNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ovsdb.rev150105.OvsdbNodeRef;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OvsNodeBuilder
implements Builder<OvsNode> {
    private OvsdbNodeRef _nodeId;
    Map<Class<? extends Augmentation<OvsNode>>, Augmentation<OvsNode>> augmentation = Collections.emptyMap();

    public OvsNodeBuilder() {
    }

    public OvsNodeBuilder(OvsNode base) {
        AugmentationHolder casted;
        this._nodeId = base.getNodeId();
        if (base instanceof OvsNodeImpl) {
            OvsNodeImpl impl = (OvsNodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OvsNode>>, Augmentation<OvsNode>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OvsNode>>, Augmentation<OvsNode>>(casted.augmentations());
        }
    }

    public OvsdbNodeRef getNodeId() {
        return this._nodeId;
    }

    public <E extends Augmentation<OvsNode>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OvsNodeBuilder setNodeId(OvsdbNodeRef value) {
        this._nodeId = value;
        return this;
    }

    public OvsNodeBuilder addAugmentation(Class<? extends Augmentation<OvsNode>> augmentationType, Augmentation<OvsNode> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OvsNode>>, Augmentation<OvsNode>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OvsNodeBuilder removeAugmentation(Class<? extends Augmentation<OvsNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OvsNode build() {
        return new OvsNodeImpl(this);
    }

    private static final class OvsNodeImpl
    implements OvsNode {
        private final OvsdbNodeRef _nodeId;
        private Map<Class<? extends Augmentation<OvsNode>>, Augmentation<OvsNode>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OvsNode> getImplementedInterface() {
            return OvsNode.class;
        }

        private OvsNodeImpl(OvsNodeBuilder base) {
            this._nodeId = base.getNodeId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OvsNode>>, Augmentation<OvsNode>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OvsNode>>, Augmentation<OvsNode>>(base.augmentation);
                }
            }
        }

        @Override
        public OvsdbNodeRef getNodeId() {
            return this._nodeId;
        }

        public <E extends Augmentation<OvsNode>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._nodeId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OvsNode.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OvsNode other = (OvsNode)obj;
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OvsNodeImpl otherImpl = (OvsNodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OvsNode>>, Augmentation<OvsNode>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "OvsNode [";
            StringBuilder builder = new StringBuilder(name);
            if (this._nodeId != null) {
                builder.append("_nodeId=");
                builder.append(this._nodeId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

