/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.ovs.rev140701.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.ovs.rev140701.bridge.OvsBridge;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sff.ovs.rev140701.bridge.ovs.bridge.ExternalIds;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OvsBridgeBuilder
implements Builder<OvsBridge> {
    private String _bridgeName;
    private List<ExternalIds> _externalIds;
    private String _openflowNodeId;
    private Uuid _uuid;
    Map<Class<? extends Augmentation<OvsBridge>>, Augmentation<OvsBridge>> augmentation = Collections.emptyMap();

    public OvsBridgeBuilder() {
    }

    public OvsBridgeBuilder(OvsBridge base) {
        AugmentationHolder casted;
        this._bridgeName = base.getBridgeName();
        this._externalIds = base.getExternalIds();
        this._openflowNodeId = base.getOpenflowNodeId();
        this._uuid = base.getUuid();
        if (base instanceof OvsBridgeImpl) {
            OvsBridgeImpl impl = (OvsBridgeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OvsBridge>>, Augmentation<OvsBridge>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OvsBridge>>, Augmentation<OvsBridge>>(casted.augmentations());
        }
    }

    public String getBridgeName() {
        return this._bridgeName;
    }

    public List<ExternalIds> getExternalIds() {
        return this._externalIds;
    }

    public String getOpenflowNodeId() {
        return this._openflowNodeId;
    }

    public Uuid getUuid() {
        return this._uuid;
    }

    public <E extends Augmentation<OvsBridge>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OvsBridgeBuilder setBridgeName(String value) {
        this._bridgeName = value;
        return this;
    }

    public OvsBridgeBuilder setExternalIds(List<ExternalIds> value) {
        this._externalIds = value;
        return this;
    }

    public OvsBridgeBuilder setOpenflowNodeId(String value) {
        this._openflowNodeId = value;
        return this;
    }

    public OvsBridgeBuilder setUuid(Uuid value) {
        this._uuid = value;
        return this;
    }

    public OvsBridgeBuilder addAugmentation(Class<? extends Augmentation<OvsBridge>> augmentationType, Augmentation<OvsBridge> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OvsBridge>>, Augmentation<OvsBridge>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OvsBridgeBuilder removeAugmentation(Class<? extends Augmentation<OvsBridge>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OvsBridge build() {
        return new OvsBridgeImpl(this);
    }

    private static final class OvsBridgeImpl
    implements OvsBridge {
        private final String _bridgeName;
        private final List<ExternalIds> _externalIds;
        private final String _openflowNodeId;
        private final Uuid _uuid;
        private Map<Class<? extends Augmentation<OvsBridge>>, Augmentation<OvsBridge>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OvsBridge> getImplementedInterface() {
            return OvsBridge.class;
        }

        private OvsBridgeImpl(OvsBridgeBuilder base) {
            this._bridgeName = base.getBridgeName();
            this._externalIds = base.getExternalIds();
            this._openflowNodeId = base.getOpenflowNodeId();
            this._uuid = base.getUuid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OvsBridge>>, Augmentation<OvsBridge>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OvsBridge>>, Augmentation<OvsBridge>>(base.augmentation);
                }
            }
        }

        @Override
        public String getBridgeName() {
            return this._bridgeName;
        }

        @Override
        public List<ExternalIds> getExternalIds() {
            return this._externalIds;
        }

        @Override
        public String getOpenflowNodeId() {
            return this._openflowNodeId;
        }

        @Override
        public Uuid getUuid() {
            return this._uuid;
        }

        public <E extends Augmentation<OvsBridge>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bridgeName);
            result = 31 * result + Objects.hashCode(this._externalIds);
            result = 31 * result + Objects.hashCode(this._openflowNodeId);
            result = 31 * result + Objects.hashCode(this._uuid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OvsBridge.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OvsBridge other = (OvsBridge)obj;
            if (!Objects.equals(this._bridgeName, other.getBridgeName())) {
                return false;
            }
            if (!Objects.equals(this._externalIds, other.getExternalIds())) {
                return false;
            }
            if (!Objects.equals(this._openflowNodeId, other.getOpenflowNodeId())) {
                return false;
            }
            if (!Objects.equals(this._uuid, other.getUuid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OvsBridgeImpl otherImpl = (OvsBridgeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OvsBridge>>, Augmentation<OvsBridge>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "OvsBridge [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bridgeName != null) {
                builder.append("_bridgeName=");
                builder.append(this._bridgeName);
                builder.append(", ");
            }
            if (this._externalIds != null) {
                builder.append("_externalIds=");
                builder.append(this._externalIds);
                builder.append(", ");
            }
            if (this._openflowNodeId != null) {
                builder.append("_openflowNodeId=");
                builder.append(this._openflowNodeId);
                builder.append(", ");
            }
            if (this._uuid != null) {
                builder.append("_uuid=");
                builder.append(this._uuid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

