/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfc.rev140701.service.function.chain.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfcName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfc.rev140701.service.function.chain.grouping.ServiceFunctionChain;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfc.rev140701.service.function.chain.grouping.ServiceFunctionChainKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sfc.rev140701.service.function.chain.grouping.service.function.chain.SfcServiceFunction;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionChainBuilder
implements Builder<ServiceFunctionChain> {
    private ServiceFunctionChainKey _key;
    private SfcName _name;
    private List<SfcServiceFunction> _sfcServiceFunction;
    private Boolean _symmetric;
    Map<Class<? extends Augmentation<ServiceFunctionChain>>, Augmentation<ServiceFunctionChain>> augmentation = Collections.emptyMap();

    public ServiceFunctionChainBuilder() {
    }

    public ServiceFunctionChainBuilder(ServiceFunctionChain base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionChainKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._sfcServiceFunction = base.getSfcServiceFunction();
        this._symmetric = base.isSymmetric();
        if (base instanceof ServiceFunctionChainImpl) {
            ServiceFunctionChainImpl impl = (ServiceFunctionChainImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionChain>>, Augmentation<ServiceFunctionChain>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionChain>>, Augmentation<ServiceFunctionChain>>(casted.augmentations());
        }
    }

    public ServiceFunctionChainKey getKey() {
        return this._key;
    }

    public SfcName getName() {
        return this._name;
    }

    public List<SfcServiceFunction> getSfcServiceFunction() {
        return this._sfcServiceFunction;
    }

    public Boolean isSymmetric() {
        return this._symmetric;
    }

    public <E extends Augmentation<ServiceFunctionChain>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionChainBuilder setKey(ServiceFunctionChainKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionChainBuilder setName(SfcName value) {
        this._name = value;
        return this;
    }

    public ServiceFunctionChainBuilder setSfcServiceFunction(List<SfcServiceFunction> value) {
        this._sfcServiceFunction = value;
        return this;
    }

    public ServiceFunctionChainBuilder setSymmetric(Boolean value) {
        this._symmetric = value;
        return this;
    }

    public ServiceFunctionChainBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionChain>> augmentationType, Augmentation<ServiceFunctionChain> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionChain>>, Augmentation<ServiceFunctionChain>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionChainBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionChain>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionChain build() {
        return new ServiceFunctionChainImpl(this);
    }

    private static final class ServiceFunctionChainImpl
    implements ServiceFunctionChain {
        private final ServiceFunctionChainKey _key;
        private final SfcName _name;
        private final List<SfcServiceFunction> _sfcServiceFunction;
        private final Boolean _symmetric;
        private Map<Class<? extends Augmentation<ServiceFunctionChain>>, Augmentation<ServiceFunctionChain>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionChain> getImplementedInterface() {
            return ServiceFunctionChain.class;
        }

        private ServiceFunctionChainImpl(ServiceFunctionChainBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionChainKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._sfcServiceFunction = base.getSfcServiceFunction();
            this._symmetric = base.isSymmetric();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionChain>>, Augmentation<ServiceFunctionChain>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionChain>>, Augmentation<ServiceFunctionChain>>(base.augmentation);
                }
            }
        }

        @Override
        public ServiceFunctionChainKey getKey() {
            return this._key;
        }

        @Override
        public SfcName getName() {
            return this._name;
        }

        @Override
        public List<SfcServiceFunction> getSfcServiceFunction() {
            return this._sfcServiceFunction;
        }

        @Override
        public Boolean isSymmetric() {
            return this._symmetric;
        }

        public <E extends Augmentation<ServiceFunctionChain>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._sfcServiceFunction);
            result = 31 * result + Objects.hashCode(this._symmetric);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionChain.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionChain other = (ServiceFunctionChain)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._sfcServiceFunction, other.getSfcServiceFunction())) {
                return false;
            }
            if (!Objects.equals(this._symmetric, other.isSymmetric())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionChainImpl otherImpl = (ServiceFunctionChainImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionChain>>, Augmentation<ServiceFunctionChain>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionChain [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._sfcServiceFunction != null) {
                builder.append("_sfcServiceFunction=");
                builder.append(this._sfcServiceFunction);
                builder.append(", ");
            }
            if (this._symmetric != null) {
                builder.append("_symmetric=");
                builder.append(this._symmetric);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

