/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.functions.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.functions.state.ServiceFunctionState;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.functions.state.ServiceFunctionStateKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.functions.state.service.function.state.SfServicePath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.ServiceStatisticsGroup;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.service.statistics.group.StatisticByTimestamp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionStateBuilder
implements Builder<ServiceFunctionState> {
    private ServiceFunctionStateKey _key;
    private SfName _name;
    private List<SfServicePath> _sfServicePath;
    private List<StatisticByTimestamp> _statisticByTimestamp;
    Map<Class<? extends Augmentation<ServiceFunctionState>>, Augmentation<ServiceFunctionState>> augmentation = Collections.emptyMap();

    public ServiceFunctionStateBuilder() {
    }

    public ServiceFunctionStateBuilder(ServiceStatisticsGroup arg) {
        this._statisticByTimestamp = arg.getStatisticByTimestamp();
    }

    public ServiceFunctionStateBuilder(ServiceFunctionState base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionStateKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._sfServicePath = base.getSfServicePath();
        this._statisticByTimestamp = base.getStatisticByTimestamp();
        if (base instanceof ServiceFunctionStateImpl) {
            ServiceFunctionStateImpl impl = (ServiceFunctionStateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionState>>, Augmentation<ServiceFunctionState>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionState>>, Augmentation<ServiceFunctionState>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceStatisticsGroup) {
            this._statisticByTimestamp = ((ServiceStatisticsGroup)arg).getStatisticByTimestamp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.ServiceStatisticsGroup] \nbut was: " + arg);
        }
    }

    public ServiceFunctionStateKey getKey() {
        return this._key;
    }

    public SfName getName() {
        return this._name;
    }

    public List<SfServicePath> getSfServicePath() {
        return this._sfServicePath;
    }

    public List<StatisticByTimestamp> getStatisticByTimestamp() {
        return this._statisticByTimestamp;
    }

    public <E extends Augmentation<ServiceFunctionState>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionStateBuilder setKey(ServiceFunctionStateKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionStateBuilder setName(SfName value) {
        this._name = value;
        return this;
    }

    public ServiceFunctionStateBuilder setSfServicePath(List<SfServicePath> value) {
        this._sfServicePath = value;
        return this;
    }

    public ServiceFunctionStateBuilder setStatisticByTimestamp(List<StatisticByTimestamp> value) {
        this._statisticByTimestamp = value;
        return this;
    }

    public ServiceFunctionStateBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionState>> augmentationType, Augmentation<ServiceFunctionState> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionState>>, Augmentation<ServiceFunctionState>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionStateBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionState build() {
        return new ServiceFunctionStateImpl(this);
    }

    private static final class ServiceFunctionStateImpl
    implements ServiceFunctionState {
        private final ServiceFunctionStateKey _key;
        private final SfName _name;
        private final List<SfServicePath> _sfServicePath;
        private final List<StatisticByTimestamp> _statisticByTimestamp;
        private Map<Class<? extends Augmentation<ServiceFunctionState>>, Augmentation<ServiceFunctionState>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionState> getImplementedInterface() {
            return ServiceFunctionState.class;
        }

        private ServiceFunctionStateImpl(ServiceFunctionStateBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionStateKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._sfServicePath = base.getSfServicePath();
            this._statisticByTimestamp = base.getStatisticByTimestamp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionState>>, Augmentation<ServiceFunctionState>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionState>>, Augmentation<ServiceFunctionState>>(base.augmentation);
                }
            }
        }

        @Override
        public ServiceFunctionStateKey getKey() {
            return this._key;
        }

        @Override
        public SfName getName() {
            return this._name;
        }

        @Override
        public List<SfServicePath> getSfServicePath() {
            return this._sfServicePath;
        }

        @Override
        public List<StatisticByTimestamp> getStatisticByTimestamp() {
            return this._statisticByTimestamp;
        }

        public <E extends Augmentation<ServiceFunctionState>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._sfServicePath);
            result = 31 * result + Objects.hashCode(this._statisticByTimestamp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionState.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionState other = (ServiceFunctionState)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._sfServicePath, other.getSfServicePath())) {
                return false;
            }
            if (!Objects.equals(this._statisticByTimestamp, other.getStatisticByTimestamp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionStateImpl otherImpl = (ServiceFunctionStateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionState>>, Augmentation<ServiceFunctionState>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionState [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._sfServicePath != null) {
                builder.append("_sfServicePath=");
                builder.append(this._sfServicePath);
                builder.append(", ");
            }
            if (this._statisticByTimestamp != null) {
                builder.append("_statisticByTimestamp=");
                builder.append(this._statisticByTimestamp);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

