/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.functions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SftTypeName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.TenantId;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.ServiceFunctionBase;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.ServiceFunctionEntry;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.function.base.SfDataPlaneLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.functions.ServiceFunction;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.functions.ServiceFunctionKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionBuilder
implements Builder<ServiceFunction> {
    private IpAddress _ipMgmtAddress;
    private ServiceFunctionKey _key;
    private SfName _name;
    private Uri _restUri;
    private List<SfDataPlaneLocator> _sfDataPlaneLocator;
    private TenantId _tenantId;
    private SftTypeName _type;
    private Boolean _oneChainOnly;
    Map<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>> augmentation = Collections.emptyMap();

    public ServiceFunctionBuilder() {
    }

    public ServiceFunctionBuilder(ServiceFunctionEntry arg) {
        this._tenantId = arg.getTenantId();
        this._restUri = arg.getRestUri();
        this._name = arg.getName();
        this._type = arg.getType();
        this._ipMgmtAddress = arg.getIpMgmtAddress();
        this._oneChainOnly = arg.isOneChainOnly();
        this._sfDataPlaneLocator = arg.getSfDataPlaneLocator();
    }

    public ServiceFunctionBuilder(ServiceFunctionBase arg) {
        this._name = arg.getName();
        this._type = arg.getType();
        this._ipMgmtAddress = arg.getIpMgmtAddress();
        this._oneChainOnly = arg.isOneChainOnly();
        this._sfDataPlaneLocator = arg.getSfDataPlaneLocator();
    }

    public ServiceFunctionBuilder(ServiceFunction base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._ipMgmtAddress = base.getIpMgmtAddress();
        this._restUri = base.getRestUri();
        this._sfDataPlaneLocator = base.getSfDataPlaneLocator();
        this._tenantId = base.getTenantId();
        this._type = base.getType();
        this._oneChainOnly = base.isOneChainOnly();
        if (base instanceof ServiceFunctionImpl) {
            ServiceFunctionImpl impl = (ServiceFunctionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceFunctionBase) {
            this._name = ((ServiceFunctionBase)arg).getName();
            this._type = ((ServiceFunctionBase)arg).getType();
            this._ipMgmtAddress = ((ServiceFunctionBase)arg).getIpMgmtAddress();
            this._oneChainOnly = ((ServiceFunctionBase)arg).isOneChainOnly();
            this._sfDataPlaneLocator = ((ServiceFunctionBase)arg).getSfDataPlaneLocator();
            isValidArg = true;
        }
        if (arg instanceof ServiceFunctionEntry) {
            this._tenantId = ((ServiceFunctionEntry)arg).getTenantId();
            this._restUri = ((ServiceFunctionEntry)arg).getRestUri();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.ServiceFunctionBase, org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.ServiceFunctionEntry] \nbut was: " + arg);
        }
    }

    public IpAddress getIpMgmtAddress() {
        return this._ipMgmtAddress;
    }

    public ServiceFunctionKey getKey() {
        return this._key;
    }

    public SfName getName() {
        return this._name;
    }

    public Uri getRestUri() {
        return this._restUri;
    }

    public List<SfDataPlaneLocator> getSfDataPlaneLocator() {
        return this._sfDataPlaneLocator;
    }

    public TenantId getTenantId() {
        return this._tenantId;
    }

    public SftTypeName getType() {
        return this._type;
    }

    public Boolean isOneChainOnly() {
        return this._oneChainOnly;
    }

    public <E extends Augmentation<ServiceFunction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionBuilder setIpMgmtAddress(IpAddress value) {
        this._ipMgmtAddress = value;
        return this;
    }

    public ServiceFunctionBuilder setKey(ServiceFunctionKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionBuilder setName(SfName value) {
        this._name = value;
        return this;
    }

    public ServiceFunctionBuilder setRestUri(Uri value) {
        this._restUri = value;
        return this;
    }

    public ServiceFunctionBuilder setSfDataPlaneLocator(List<SfDataPlaneLocator> value) {
        this._sfDataPlaneLocator = value;
        return this;
    }

    public ServiceFunctionBuilder setTenantId(TenantId value) {
        this._tenantId = value;
        return this;
    }

    public ServiceFunctionBuilder setType(SftTypeName value) {
        this._type = value;
        return this;
    }

    public ServiceFunctionBuilder setOneChainOnly(Boolean value) {
        this._oneChainOnly = value;
        return this;
    }

    public ServiceFunctionBuilder addAugmentation(Class<? extends Augmentation<ServiceFunction>> augmentationType, Augmentation<ServiceFunction> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunction build() {
        return new ServiceFunctionImpl(this);
    }

    private static final class ServiceFunctionImpl
    implements ServiceFunction {
        private final IpAddress _ipMgmtAddress;
        private final ServiceFunctionKey _key;
        private final SfName _name;
        private final Uri _restUri;
        private final List<SfDataPlaneLocator> _sfDataPlaneLocator;
        private final TenantId _tenantId;
        private final SftTypeName _type;
        private final Boolean _oneChainOnly;
        private Map<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunction> getImplementedInterface() {
            return ServiceFunction.class;
        }

        private ServiceFunctionImpl(ServiceFunctionBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._ipMgmtAddress = base.getIpMgmtAddress();
            this._restUri = base.getRestUri();
            this._sfDataPlaneLocator = base.getSfDataPlaneLocator();
            this._tenantId = base.getTenantId();
            this._type = base.getType();
            this._oneChainOnly = base.isOneChainOnly();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIpMgmtAddress() {
            return this._ipMgmtAddress;
        }

        @Override
        public ServiceFunctionKey getKey() {
            return this._key;
        }

        @Override
        public SfName getName() {
            return this._name;
        }

        @Override
        public Uri getRestUri() {
            return this._restUri;
        }

        @Override
        public List<SfDataPlaneLocator> getSfDataPlaneLocator() {
            return this._sfDataPlaneLocator;
        }

        @Override
        public TenantId getTenantId() {
            return this._tenantId;
        }

        @Override
        public SftTypeName getType() {
            return this._type;
        }

        @Override
        public Boolean isOneChainOnly() {
            return this._oneChainOnly;
        }

        public <E extends Augmentation<ServiceFunction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipMgmtAddress);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._restUri);
            result = 31 * result + Objects.hashCode(this._sfDataPlaneLocator);
            result = 31 * result + Objects.hashCode(this._tenantId);
            result = 31 * result + Objects.hashCode(this._type);
            result = 31 * result + Objects.hashCode(this._oneChainOnly);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunction.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunction other = (ServiceFunction)obj;
            if (!Objects.equals(this._ipMgmtAddress, other.getIpMgmtAddress())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._restUri, other.getRestUri())) {
                return false;
            }
            if (!Objects.equals(this._sfDataPlaneLocator, other.getSfDataPlaneLocator())) {
                return false;
            }
            if (!Objects.equals(this._tenantId, other.getTenantId())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (!Objects.equals(this._oneChainOnly, other.isOneChainOnly())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionImpl otherImpl = (ServiceFunctionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunction>>, Augmentation<ServiceFunction>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunction [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ipMgmtAddress != null) {
                builder.append("_ipMgmtAddress=");
                builder.append(this._ipMgmtAddress);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._restUri != null) {
                builder.append("_restUri=");
                builder.append(this._restUri);
                builder.append(", ");
            }
            if (this._sfDataPlaneLocator != null) {
                builder.append("_sfDataPlaneLocator=");
                builder.append(this._sfDataPlaneLocator);
                builder.append(", ");
            }
            if (this._tenantId != null) {
                builder.append("_tenantId=");
                builder.append(this._tenantId);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
                builder.append(", ");
            }
            if (this._oneChainOnly != null) {
                builder.append("_oneChainOnly=");
                builder.append(this._oneChainOnly);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

