/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.function.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfDataPlaneLocatorName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.function.base.SfDataPlaneLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sf.rev140701.service.function.base.SfDataPlaneLocatorKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.DataPlaneLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.SlTransportType;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.data.plane.locator.LocatorType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SfDataPlaneLocatorBuilder
implements Builder<SfDataPlaneLocator> {
    private SfDataPlaneLocatorKey _key;
    private LocatorType _locatorType;
    private SfDataPlaneLocatorName _name;
    private SffName _serviceFunctionForwarder;
    private Class<? extends SlTransportType> _transport;
    Map<Class<? extends Augmentation<SfDataPlaneLocator>>, Augmentation<SfDataPlaneLocator>> augmentation = Collections.emptyMap();

    public SfDataPlaneLocatorBuilder() {
    }

    public SfDataPlaneLocatorBuilder(DataPlaneLocator arg) {
        this._locatorType = arg.getLocatorType();
        this._transport = arg.getTransport();
    }

    public SfDataPlaneLocatorBuilder(SfDataPlaneLocator base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new SfDataPlaneLocatorKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._locatorType = base.getLocatorType();
        this._serviceFunctionForwarder = base.getServiceFunctionForwarder();
        this._transport = base.getTransport();
        if (base instanceof SfDataPlaneLocatorImpl) {
            SfDataPlaneLocatorImpl impl = (SfDataPlaneLocatorImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SfDataPlaneLocator>>, Augmentation<SfDataPlaneLocator>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SfDataPlaneLocator>>, Augmentation<SfDataPlaneLocator>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DataPlaneLocator) {
            this._locatorType = ((DataPlaneLocator)arg).getLocatorType();
            this._transport = ((DataPlaneLocator)arg).getTransport();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.DataPlaneLocator] \nbut was: " + arg);
        }
    }

    public SfDataPlaneLocatorKey getKey() {
        return this._key;
    }

    public LocatorType getLocatorType() {
        return this._locatorType;
    }

    public SfDataPlaneLocatorName getName() {
        return this._name;
    }

    public SffName getServiceFunctionForwarder() {
        return this._serviceFunctionForwarder;
    }

    public Class<? extends SlTransportType> getTransport() {
        return this._transport;
    }

    public <E extends Augmentation<SfDataPlaneLocator>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SfDataPlaneLocatorBuilder setKey(SfDataPlaneLocatorKey value) {
        this._key = value;
        return this;
    }

    public SfDataPlaneLocatorBuilder setLocatorType(LocatorType value) {
        this._locatorType = value;
        return this;
    }

    public SfDataPlaneLocatorBuilder setName(SfDataPlaneLocatorName value) {
        this._name = value;
        return this;
    }

    public SfDataPlaneLocatorBuilder setServiceFunctionForwarder(SffName value) {
        this._serviceFunctionForwarder = value;
        return this;
    }

    public SfDataPlaneLocatorBuilder setTransport(Class<? extends SlTransportType> value) {
        this._transport = value;
        return this;
    }

    public SfDataPlaneLocatorBuilder addAugmentation(Class<? extends Augmentation<SfDataPlaneLocator>> augmentationType, Augmentation<SfDataPlaneLocator> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SfDataPlaneLocator>>, Augmentation<SfDataPlaneLocator>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SfDataPlaneLocatorBuilder removeAugmentation(Class<? extends Augmentation<SfDataPlaneLocator>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SfDataPlaneLocator build() {
        return new SfDataPlaneLocatorImpl(this);
    }

    private static final class SfDataPlaneLocatorImpl
    implements SfDataPlaneLocator {
        private final SfDataPlaneLocatorKey _key;
        private final LocatorType _locatorType;
        private final SfDataPlaneLocatorName _name;
        private final SffName _serviceFunctionForwarder;
        private final Class<? extends SlTransportType> _transport;
        private Map<Class<? extends Augmentation<SfDataPlaneLocator>>, Augmentation<SfDataPlaneLocator>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SfDataPlaneLocator> getImplementedInterface() {
            return SfDataPlaneLocator.class;
        }

        private SfDataPlaneLocatorImpl(SfDataPlaneLocatorBuilder base) {
            if (base.getKey() == null) {
                this._key = new SfDataPlaneLocatorKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._locatorType = base.getLocatorType();
            this._serviceFunctionForwarder = base.getServiceFunctionForwarder();
            this._transport = base.getTransport();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SfDataPlaneLocator>>, Augmentation<SfDataPlaneLocator>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SfDataPlaneLocator>>, Augmentation<SfDataPlaneLocator>>(base.augmentation);
                }
            }
        }

        @Override
        public SfDataPlaneLocatorKey getKey() {
            return this._key;
        }

        @Override
        public LocatorType getLocatorType() {
            return this._locatorType;
        }

        @Override
        public SfDataPlaneLocatorName getName() {
            return this._name;
        }

        @Override
        public SffName getServiceFunctionForwarder() {
            return this._serviceFunctionForwarder;
        }

        @Override
        public Class<? extends SlTransportType> getTransport() {
            return this._transport;
        }

        public <E extends Augmentation<SfDataPlaneLocator>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._locatorType);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._serviceFunctionForwarder);
            result = 31 * result + Objects.hashCode(this._transport);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SfDataPlaneLocator.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SfDataPlaneLocator other = (SfDataPlaneLocator)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._locatorType, other.getLocatorType())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionForwarder, other.getServiceFunctionForwarder())) {
                return false;
            }
            if (!Objects.equals(this._transport, other.getTransport())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SfDataPlaneLocatorImpl otherImpl = (SfDataPlaneLocatorImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SfDataPlaneLocator>>, Augmentation<SfDataPlaneLocator>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SfDataPlaneLocator [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._locatorType != null) {
                builder.append("_locatorType=");
                builder.append(this._locatorType);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._serviceFunctionForwarder != null) {
                builder.append("_serviceFunctionForwarder=");
                builder.append(this._serviceFunctionForwarder);
                builder.append(", ");
            }
            if (this._transport != null) {
                builder.append("_transport=");
                builder.append(this._transport);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

