/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.scf.rev140701.service.function.classifiers;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.scf.rev140701.service.function.classifiers.ServiceFunctionClassifier;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.scf.rev140701.service.function.classifiers.ServiceFunctionClassifierKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.scf.rev140701.service.function.classifiers.service.function.classifier.Acl;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.scf.rev140701.service.function.classifiers.service.function.classifier.SclServiceFunctionForwarder;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceFunctionClassifierBuilder
implements Builder<ServiceFunctionClassifier> {
    private Acl _acl;
    private ServiceFunctionClassifierKey _key;
    private String _name;
    private List<SclServiceFunctionForwarder> _sclServiceFunctionForwarder;
    Map<Class<? extends Augmentation<ServiceFunctionClassifier>>, Augmentation<ServiceFunctionClassifier>> augmentation = Collections.emptyMap();

    public ServiceFunctionClassifierBuilder() {
    }

    public ServiceFunctionClassifierBuilder(ServiceFunctionClassifier base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceFunctionClassifierKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._acl = base.getAcl();
        this._sclServiceFunctionForwarder = base.getSclServiceFunctionForwarder();
        if (base instanceof ServiceFunctionClassifierImpl) {
            ServiceFunctionClassifierImpl impl = (ServiceFunctionClassifierImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionClassifier>>, Augmentation<ServiceFunctionClassifier>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionClassifier>>, Augmentation<ServiceFunctionClassifier>>(casted.augmentations());
        }
    }

    public Acl getAcl() {
        return this._acl;
    }

    public ServiceFunctionClassifierKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public List<SclServiceFunctionForwarder> getSclServiceFunctionForwarder() {
        return this._sclServiceFunctionForwarder;
    }

    public <E extends Augmentation<ServiceFunctionClassifier>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceFunctionClassifierBuilder setAcl(Acl value) {
        this._acl = value;
        return this;
    }

    public ServiceFunctionClassifierBuilder setKey(ServiceFunctionClassifierKey value) {
        this._key = value;
        return this;
    }

    public ServiceFunctionClassifierBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ServiceFunctionClassifierBuilder setSclServiceFunctionForwarder(List<SclServiceFunctionForwarder> value) {
        this._sclServiceFunctionForwarder = value;
        return this;
    }

    public ServiceFunctionClassifierBuilder addAugmentation(Class<? extends Augmentation<ServiceFunctionClassifier>> augmentationType, Augmentation<ServiceFunctionClassifier> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionClassifier>>, Augmentation<ServiceFunctionClassifier>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceFunctionClassifierBuilder removeAugmentation(Class<? extends Augmentation<ServiceFunctionClassifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ServiceFunctionClassifier build() {
        return new ServiceFunctionClassifierImpl(this);
    }

    private static final class ServiceFunctionClassifierImpl
    implements ServiceFunctionClassifier {
        private final Acl _acl;
        private final ServiceFunctionClassifierKey _key;
        private final String _name;
        private final List<SclServiceFunctionForwarder> _sclServiceFunctionForwarder;
        private Map<Class<? extends Augmentation<ServiceFunctionClassifier>>, Augmentation<ServiceFunctionClassifier>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ServiceFunctionClassifier> getImplementedInterface() {
            return ServiceFunctionClassifier.class;
        }

        private ServiceFunctionClassifierImpl(ServiceFunctionClassifierBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceFunctionClassifierKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._acl = base.getAcl();
            this._sclServiceFunctionForwarder = base.getSclServiceFunctionForwarder();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ServiceFunctionClassifier>>, Augmentation<ServiceFunctionClassifier>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ServiceFunctionClassifier>>, Augmentation<ServiceFunctionClassifier>>(base.augmentation);
                }
            }
        }

        @Override
        public Acl getAcl() {
            return this._acl;
        }

        @Override
        public ServiceFunctionClassifierKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public List<SclServiceFunctionForwarder> getSclServiceFunctionForwarder() {
            return this._sclServiceFunctionForwarder;
        }

        public <E extends Augmentation<ServiceFunctionClassifier>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._acl);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._sclServiceFunctionForwarder);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ServiceFunctionClassifier.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ServiceFunctionClassifier other = (ServiceFunctionClassifier)obj;
            if (!Objects.equals(this._acl, other.getAcl())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._sclServiceFunctionForwarder, other.getSclServiceFunctionForwarder())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceFunctionClassifierImpl otherImpl = (ServiceFunctionClassifierImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ServiceFunctionClassifier>>, Augmentation<ServiceFunctionClassifier>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ServiceFunctionClassifier [";
            StringBuilder builder = new StringBuilder(name);
            if (this._acl != null) {
                builder.append("_acl=");
                builder.append(this._acl);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._sclServiceFunctionForwarder != null) {
                builder.append("_sclServiceFunctionForwarder=");
                builder.append(this._sclServiceFunctionForwarder);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

