/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.scf.rev140701.attachment.point.attachment.point.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.scf.rev140701.attachment.point.attachment.point.type.Bridge;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BridgeBuilder
implements Builder<Bridge> {
    private String _bridge;
    Map<Class<? extends Augmentation<Bridge>>, Augmentation<Bridge>> augmentation = Collections.emptyMap();

    public BridgeBuilder() {
    }

    public BridgeBuilder(Bridge base) {
        AugmentationHolder casted;
        this._bridge = base.getBridge();
        if (base instanceof BridgeImpl) {
            BridgeImpl impl = (BridgeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Bridge>>, Augmentation<Bridge>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Bridge>>, Augmentation<Bridge>>(casted.augmentations());
        }
    }

    public String getBridge() {
        return this._bridge;
    }

    public <E extends Augmentation<Bridge>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BridgeBuilder setBridge(String value) {
        this._bridge = value;
        return this;
    }

    public BridgeBuilder addAugmentation(Class<? extends Augmentation<Bridge>> augmentationType, Augmentation<Bridge> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Bridge>>, Augmentation<Bridge>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BridgeBuilder removeAugmentation(Class<? extends Augmentation<Bridge>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Bridge build() {
        return new BridgeImpl(this);
    }

    private static final class BridgeImpl
    implements Bridge {
        private final String _bridge;
        private Map<Class<? extends Augmentation<Bridge>>, Augmentation<Bridge>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Bridge> getImplementedInterface() {
            return Bridge.class;
        }

        private BridgeImpl(BridgeBuilder base) {
            this._bridge = base.getBridge();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Bridge>>, Augmentation<Bridge>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Bridge>>, Augmentation<Bridge>>(base.augmentation);
                }
            }
        }

        @Override
        public String getBridge() {
            return this._bridge;
        }

        public <E extends Augmentation<Bridge>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bridge);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Bridge.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Bridge other = (Bridge)obj;
            if (!Objects.equals(this._bridge, other.getBridge())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BridgeImpl otherImpl = (BridgeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Bridge>>, Augmentation<Bridge>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Bridge [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bridge != null) {
                builder.append("_bridge=");
                builder.append(this._bridge);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

