/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.rendered.service.path;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffDataPlaneLocatorName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SffName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.rendered.service.path.RenderedServicePathHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.rendered.service.path.RenderedServicePathHopKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RenderedServicePathHopBuilder
implements Builder<RenderedServicePathHop> {
    private Short _hopNumber;
    private RenderedServicePathHopKey _key;
    private SffName _serviceFunctionForwarder;
    private SffDataPlaneLocatorName _serviceFunctionForwarderLocator;
    private String _serviceFunctionGroupName;
    private SfName _serviceFunctionName;
    private Short _serviceIndex;
    Map<Class<? extends Augmentation<RenderedServicePathHop>>, Augmentation<RenderedServicePathHop>> augmentation = Collections.emptyMap();

    public RenderedServicePathHopBuilder() {
    }

    public RenderedServicePathHopBuilder(RenderedServicePathHop base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new RenderedServicePathHopKey(base.getHopNumber());
            this._hopNumber = base.getHopNumber();
        } else {
            this._key = base.getKey();
            this._hopNumber = this._key.getHopNumber();
        }
        this._serviceFunctionForwarder = base.getServiceFunctionForwarder();
        this._serviceFunctionForwarderLocator = base.getServiceFunctionForwarderLocator();
        this._serviceFunctionGroupName = base.getServiceFunctionGroupName();
        this._serviceFunctionName = base.getServiceFunctionName();
        this._serviceIndex = base.getServiceIndex();
        if (base instanceof RenderedServicePathHopImpl) {
            RenderedServicePathHopImpl impl = (RenderedServicePathHopImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePathHop>>, Augmentation<RenderedServicePathHop>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePathHop>>, Augmentation<RenderedServicePathHop>>(casted.augmentations());
        }
    }

    public Short getHopNumber() {
        return this._hopNumber;
    }

    public RenderedServicePathHopKey getKey() {
        return this._key;
    }

    public SffName getServiceFunctionForwarder() {
        return this._serviceFunctionForwarder;
    }

    public SffDataPlaneLocatorName getServiceFunctionForwarderLocator() {
        return this._serviceFunctionForwarderLocator;
    }

    public String getServiceFunctionGroupName() {
        return this._serviceFunctionGroupName;
    }

    public SfName getServiceFunctionName() {
        return this._serviceFunctionName;
    }

    public Short getServiceIndex() {
        return this._serviceIndex;
    }

    public <E extends Augmentation<RenderedServicePathHop>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkHopNumberRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public RenderedServicePathHopBuilder setHopNumber(Short value) {
        if (value != null) {
            RenderedServicePathHopBuilder.checkHopNumberRange(value);
        }
        this._hopNumber = value;
        return this;
    }

    public RenderedServicePathHopBuilder setKey(RenderedServicePathHopKey value) {
        this._key = value;
        return this;
    }

    public RenderedServicePathHopBuilder setServiceFunctionForwarder(SffName value) {
        this._serviceFunctionForwarder = value;
        return this;
    }

    public RenderedServicePathHopBuilder setServiceFunctionForwarderLocator(SffDataPlaneLocatorName value) {
        this._serviceFunctionForwarderLocator = value;
        return this;
    }

    public RenderedServicePathHopBuilder setServiceFunctionGroupName(String value) {
        this._serviceFunctionGroupName = value;
        return this;
    }

    public RenderedServicePathHopBuilder setServiceFunctionName(SfName value) {
        this._serviceFunctionName = value;
        return this;
    }

    private static void checkServiceIndexRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public RenderedServicePathHopBuilder setServiceIndex(Short value) {
        if (value != null) {
            RenderedServicePathHopBuilder.checkServiceIndexRange(value);
        }
        this._serviceIndex = value;
        return this;
    }

    public RenderedServicePathHopBuilder addAugmentation(Class<? extends Augmentation<RenderedServicePathHop>> augmentationType, Augmentation<RenderedServicePathHop> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePathHop>>, Augmentation<RenderedServicePathHop>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RenderedServicePathHopBuilder removeAugmentation(Class<? extends Augmentation<RenderedServicePathHop>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RenderedServicePathHop build() {
        return new RenderedServicePathHopImpl(this);
    }

    private static final class RenderedServicePathHopImpl
    implements RenderedServicePathHop {
        private final Short _hopNumber;
        private final RenderedServicePathHopKey _key;
        private final SffName _serviceFunctionForwarder;
        private final SffDataPlaneLocatorName _serviceFunctionForwarderLocator;
        private final String _serviceFunctionGroupName;
        private final SfName _serviceFunctionName;
        private final Short _serviceIndex;
        private Map<Class<? extends Augmentation<RenderedServicePathHop>>, Augmentation<RenderedServicePathHop>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RenderedServicePathHop> getImplementedInterface() {
            return RenderedServicePathHop.class;
        }

        private RenderedServicePathHopImpl(RenderedServicePathHopBuilder base) {
            if (base.getKey() == null) {
                this._key = new RenderedServicePathHopKey(base.getHopNumber());
                this._hopNumber = base.getHopNumber();
            } else {
                this._key = base.getKey();
                this._hopNumber = this._key.getHopNumber();
            }
            this._serviceFunctionForwarder = base.getServiceFunctionForwarder();
            this._serviceFunctionForwarderLocator = base.getServiceFunctionForwarderLocator();
            this._serviceFunctionGroupName = base.getServiceFunctionGroupName();
            this._serviceFunctionName = base.getServiceFunctionName();
            this._serviceIndex = base.getServiceIndex();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RenderedServicePathHop>>, Augmentation<RenderedServicePathHop>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePathHop>>, Augmentation<RenderedServicePathHop>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getHopNumber() {
            return this._hopNumber;
        }

        @Override
        public RenderedServicePathHopKey getKey() {
            return this._key;
        }

        @Override
        public SffName getServiceFunctionForwarder() {
            return this._serviceFunctionForwarder;
        }

        @Override
        public SffDataPlaneLocatorName getServiceFunctionForwarderLocator() {
            return this._serviceFunctionForwarderLocator;
        }

        @Override
        public String getServiceFunctionGroupName() {
            return this._serviceFunctionGroupName;
        }

        @Override
        public SfName getServiceFunctionName() {
            return this._serviceFunctionName;
        }

        @Override
        public Short getServiceIndex() {
            return this._serviceIndex;
        }

        public <E extends Augmentation<RenderedServicePathHop>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._hopNumber);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._serviceFunctionForwarder);
            result = 31 * result + Objects.hashCode(this._serviceFunctionForwarderLocator);
            result = 31 * result + Objects.hashCode(this._serviceFunctionGroupName);
            result = 31 * result + Objects.hashCode(this._serviceFunctionName);
            result = 31 * result + Objects.hashCode(this._serviceIndex);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RenderedServicePathHop.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RenderedServicePathHop other = (RenderedServicePathHop)obj;
            if (!Objects.equals(this._hopNumber, other.getHopNumber())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionForwarder, other.getServiceFunctionForwarder())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionForwarderLocator, other.getServiceFunctionForwarderLocator())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionGroupName, other.getServiceFunctionGroupName())) {
                return false;
            }
            if (!Objects.equals(this._serviceFunctionName, other.getServiceFunctionName())) {
                return false;
            }
            if (!Objects.equals(this._serviceIndex, other.getServiceIndex())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RenderedServicePathHopImpl otherImpl = (RenderedServicePathHopImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RenderedServicePathHop>>, Augmentation<RenderedServicePathHop>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RenderedServicePathHop [";
            StringBuilder builder = new StringBuilder(name);
            if (this._hopNumber != null) {
                builder.append("_hopNumber=");
                builder.append(this._hopNumber);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._serviceFunctionForwarder != null) {
                builder.append("_serviceFunctionForwarder=");
                builder.append(this._serviceFunctionForwarder);
                builder.append(", ");
            }
            if (this._serviceFunctionForwarderLocator != null) {
                builder.append("_serviceFunctionForwarderLocator=");
                builder.append(this._serviceFunctionForwarderLocator);
                builder.append(", ");
            }
            if (this._serviceFunctionGroupName != null) {
                builder.append("_serviceFunctionGroupName=");
                builder.append(this._serviceFunctionGroupName);
                builder.append(", ");
            }
            if (this._serviceFunctionName != null) {
                builder.append("_serviceFunctionName=");
                builder.append(this._serviceFunctionName);
                builder.append(", ");
            }
            if (this._serviceIndex != null) {
                builder.append("_serviceIndex=");
                builder.append(this._serviceIndex);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

