/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfcName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.SfpName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePath;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.RenderedServicePathKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.paths.rendered.service.path.RenderedServicePathHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.SfcEncapsulationIdentity;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.SlTransportType;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.ServiceStatisticsGroup;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.service.statistics.group.StatisticByTimestamp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RenderedServicePathBuilder
implements Builder<RenderedServicePath> {
    private String _contextMetadata;
    private RenderedServicePathKey _key;
    private RspName _name;
    private SfpName _parentServiceFunctionPath;
    private Long _pathId;
    private List<RenderedServicePathHop> _renderedServicePathHop;
    private SfcName _serviceChainName;
    private Class<? extends SfcEncapsulationIdentity> _sfcEncapsulation;
    private Short _startingIndex;
    private List<StatisticByTimestamp> _statisticByTimestamp;
    private Long _symmetricPathId;
    private String _tenantId;
    private Class<? extends SlTransportType> _transportType;
    private String _variableMetadata;
    Map<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>> augmentation = Collections.emptyMap();

    public RenderedServicePathBuilder() {
    }

    public RenderedServicePathBuilder(ServiceStatisticsGroup arg) {
        this._statisticByTimestamp = arg.getStatisticByTimestamp();
    }

    public RenderedServicePathBuilder(RenderedServicePath base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new RenderedServicePathKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._contextMetadata = base.getContextMetadata();
        this._parentServiceFunctionPath = base.getParentServiceFunctionPath();
        this._pathId = base.getPathId();
        this._renderedServicePathHop = base.getRenderedServicePathHop();
        this._serviceChainName = base.getServiceChainName();
        this._sfcEncapsulation = base.getSfcEncapsulation();
        this._startingIndex = base.getStartingIndex();
        this._statisticByTimestamp = base.getStatisticByTimestamp();
        this._symmetricPathId = base.getSymmetricPathId();
        this._tenantId = base.getTenantId();
        this._transportType = base.getTransportType();
        this._variableMetadata = base.getVariableMetadata();
        if (base instanceof RenderedServicePathImpl) {
            RenderedServicePathImpl impl = (RenderedServicePathImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ServiceStatisticsGroup) {
            this._statisticByTimestamp = ((ServiceStatisticsGroup)arg).getStatisticByTimestamp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ss.rev140701.ServiceStatisticsGroup] \nbut was: " + arg);
        }
    }

    public String getContextMetadata() {
        return this._contextMetadata;
    }

    public RenderedServicePathKey getKey() {
        return this._key;
    }

    public RspName getName() {
        return this._name;
    }

    public SfpName getParentServiceFunctionPath() {
        return this._parentServiceFunctionPath;
    }

    public Long getPathId() {
        return this._pathId;
    }

    public List<RenderedServicePathHop> getRenderedServicePathHop() {
        return this._renderedServicePathHop;
    }

    public SfcName getServiceChainName() {
        return this._serviceChainName;
    }

    public Class<? extends SfcEncapsulationIdentity> getSfcEncapsulation() {
        return this._sfcEncapsulation;
    }

    public Short getStartingIndex() {
        return this._startingIndex;
    }

    public List<StatisticByTimestamp> getStatisticByTimestamp() {
        return this._statisticByTimestamp;
    }

    public Long getSymmetricPathId() {
        return this._symmetricPathId;
    }

    public String getTenantId() {
        return this._tenantId;
    }

    public Class<? extends SlTransportType> getTransportType() {
        return this._transportType;
    }

    public String getVariableMetadata() {
        return this._variableMetadata;
    }

    public <E extends Augmentation<RenderedServicePath>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RenderedServicePathBuilder setContextMetadata(String value) {
        this._contextMetadata = value;
        return this;
    }

    public RenderedServicePathBuilder setKey(RenderedServicePathKey value) {
        this._key = value;
        return this;
    }

    public RenderedServicePathBuilder setName(RspName value) {
        this._name = value;
        return this;
    }

    public RenderedServicePathBuilder setParentServiceFunctionPath(SfpName value) {
        this._parentServiceFunctionPath = value;
        return this;
    }

    private static void checkPathIdRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public RenderedServicePathBuilder setPathId(Long value) {
        if (value != null) {
            RenderedServicePathBuilder.checkPathIdRange(value);
        }
        this._pathId = value;
        return this;
    }

    public RenderedServicePathBuilder setRenderedServicePathHop(List<RenderedServicePathHop> value) {
        this._renderedServicePathHop = value;
        return this;
    }

    public RenderedServicePathBuilder setServiceChainName(SfcName value) {
        this._serviceChainName = value;
        return this;
    }

    public RenderedServicePathBuilder setSfcEncapsulation(Class<? extends SfcEncapsulationIdentity> value) {
        this._sfcEncapsulation = value;
        return this;
    }

    private static void checkStartingIndexRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public RenderedServicePathBuilder setStartingIndex(Short value) {
        if (value != null) {
            RenderedServicePathBuilder.checkStartingIndexRange(value);
        }
        this._startingIndex = value;
        return this;
    }

    public RenderedServicePathBuilder setStatisticByTimestamp(List<StatisticByTimestamp> value) {
        this._statisticByTimestamp = value;
        return this;
    }

    private static void checkSymmetricPathIdRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public RenderedServicePathBuilder setSymmetricPathId(Long value) {
        if (value != null) {
            RenderedServicePathBuilder.checkSymmetricPathIdRange(value);
        }
        this._symmetricPathId = value;
        return this;
    }

    public RenderedServicePathBuilder setTenantId(String value) {
        this._tenantId = value;
        return this;
    }

    public RenderedServicePathBuilder setTransportType(Class<? extends SlTransportType> value) {
        this._transportType = value;
        return this;
    }

    public RenderedServicePathBuilder setVariableMetadata(String value) {
        this._variableMetadata = value;
        return this;
    }

    public RenderedServicePathBuilder addAugmentation(Class<? extends Augmentation<RenderedServicePath>> augmentationType, Augmentation<RenderedServicePath> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RenderedServicePathBuilder removeAugmentation(Class<? extends Augmentation<RenderedServicePath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RenderedServicePath build() {
        return new RenderedServicePathImpl(this);
    }

    private static final class RenderedServicePathImpl
    implements RenderedServicePath {
        private final String _contextMetadata;
        private final RenderedServicePathKey _key;
        private final RspName _name;
        private final SfpName _parentServiceFunctionPath;
        private final Long _pathId;
        private final List<RenderedServicePathHop> _renderedServicePathHop;
        private final SfcName _serviceChainName;
        private final Class<? extends SfcEncapsulationIdentity> _sfcEncapsulation;
        private final Short _startingIndex;
        private final List<StatisticByTimestamp> _statisticByTimestamp;
        private final Long _symmetricPathId;
        private final String _tenantId;
        private final Class<? extends SlTransportType> _transportType;
        private final String _variableMetadata;
        private Map<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RenderedServicePath> getImplementedInterface() {
            return RenderedServicePath.class;
        }

        private RenderedServicePathImpl(RenderedServicePathBuilder base) {
            if (base.getKey() == null) {
                this._key = new RenderedServicePathKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._contextMetadata = base.getContextMetadata();
            this._parentServiceFunctionPath = base.getParentServiceFunctionPath();
            this._pathId = base.getPathId();
            this._renderedServicePathHop = base.getRenderedServicePathHop();
            this._serviceChainName = base.getServiceChainName();
            this._sfcEncapsulation = base.getSfcEncapsulation();
            this._startingIndex = base.getStartingIndex();
            this._statisticByTimestamp = base.getStatisticByTimestamp();
            this._symmetricPathId = base.getSymmetricPathId();
            this._tenantId = base.getTenantId();
            this._transportType = base.getTransportType();
            this._variableMetadata = base.getVariableMetadata();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>>(base.augmentation);
                }
            }
        }

        @Override
        public String getContextMetadata() {
            return this._contextMetadata;
        }

        @Override
        public RenderedServicePathKey getKey() {
            return this._key;
        }

        @Override
        public RspName getName() {
            return this._name;
        }

        @Override
        public SfpName getParentServiceFunctionPath() {
            return this._parentServiceFunctionPath;
        }

        @Override
        public Long getPathId() {
            return this._pathId;
        }

        @Override
        public List<RenderedServicePathHop> getRenderedServicePathHop() {
            return this._renderedServicePathHop;
        }

        @Override
        public SfcName getServiceChainName() {
            return this._serviceChainName;
        }

        @Override
        public Class<? extends SfcEncapsulationIdentity> getSfcEncapsulation() {
            return this._sfcEncapsulation;
        }

        @Override
        public Short getStartingIndex() {
            return this._startingIndex;
        }

        @Override
        public List<StatisticByTimestamp> getStatisticByTimestamp() {
            return this._statisticByTimestamp;
        }

        @Override
        public Long getSymmetricPathId() {
            return this._symmetricPathId;
        }

        @Override
        public String getTenantId() {
            return this._tenantId;
        }

        @Override
        public Class<? extends SlTransportType> getTransportType() {
            return this._transportType;
        }

        @Override
        public String getVariableMetadata() {
            return this._variableMetadata;
        }

        public <E extends Augmentation<RenderedServicePath>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._contextMetadata);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._parentServiceFunctionPath);
            result = 31 * result + Objects.hashCode(this._pathId);
            result = 31 * result + Objects.hashCode(this._renderedServicePathHop);
            result = 31 * result + Objects.hashCode(this._serviceChainName);
            result = 31 * result + Objects.hashCode(this._sfcEncapsulation);
            result = 31 * result + Objects.hashCode(this._startingIndex);
            result = 31 * result + Objects.hashCode(this._statisticByTimestamp);
            result = 31 * result + Objects.hashCode(this._symmetricPathId);
            result = 31 * result + Objects.hashCode(this._tenantId);
            result = 31 * result + Objects.hashCode(this._transportType);
            result = 31 * result + Objects.hashCode(this._variableMetadata);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RenderedServicePath.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RenderedServicePath other = (RenderedServicePath)obj;
            if (!Objects.equals(this._contextMetadata, other.getContextMetadata())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._parentServiceFunctionPath, other.getParentServiceFunctionPath())) {
                return false;
            }
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (!Objects.equals(this._renderedServicePathHop, other.getRenderedServicePathHop())) {
                return false;
            }
            if (!Objects.equals(this._serviceChainName, other.getServiceChainName())) {
                return false;
            }
            if (!Objects.equals(this._sfcEncapsulation, other.getSfcEncapsulation())) {
                return false;
            }
            if (!Objects.equals(this._startingIndex, other.getStartingIndex())) {
                return false;
            }
            if (!Objects.equals(this._statisticByTimestamp, other.getStatisticByTimestamp())) {
                return false;
            }
            if (!Objects.equals(this._symmetricPathId, other.getSymmetricPathId())) {
                return false;
            }
            if (!Objects.equals(this._tenantId, other.getTenantId())) {
                return false;
            }
            if (!Objects.equals(this._transportType, other.getTransportType())) {
                return false;
            }
            if (!Objects.equals(this._variableMetadata, other.getVariableMetadata())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RenderedServicePathImpl otherImpl = (RenderedServicePathImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RenderedServicePath>>, Augmentation<RenderedServicePath>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RenderedServicePath [";
            StringBuilder builder = new StringBuilder(name);
            if (this._contextMetadata != null) {
                builder.append("_contextMetadata=");
                builder.append(this._contextMetadata);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._parentServiceFunctionPath != null) {
                builder.append("_parentServiceFunctionPath=");
                builder.append(this._parentServiceFunctionPath);
                builder.append(", ");
            }
            if (this._pathId != null) {
                builder.append("_pathId=");
                builder.append(this._pathId);
                builder.append(", ");
            }
            if (this._renderedServicePathHop != null) {
                builder.append("_renderedServicePathHop=");
                builder.append(this._renderedServicePathHop);
                builder.append(", ");
            }
            if (this._serviceChainName != null) {
                builder.append("_serviceChainName=");
                builder.append(this._serviceChainName);
                builder.append(", ");
            }
            if (this._sfcEncapsulation != null) {
                builder.append("_sfcEncapsulation=");
                builder.append(this._sfcEncapsulation);
                builder.append(", ");
            }
            if (this._startingIndex != null) {
                builder.append("_startingIndex=");
                builder.append(this._startingIndex);
                builder.append(", ");
            }
            if (this._statisticByTimestamp != null) {
                builder.append("_statisticByTimestamp=");
                builder.append(this._statisticByTimestamp);
                builder.append(", ");
            }
            if (this._symmetricPathId != null) {
                builder.append("_symmetricPathId=");
                builder.append(this._symmetricPathId);
                builder.append(", ");
            }
            if (this._tenantId != null) {
                builder.append("_tenantId=");
                builder.append(this._tenantId);
                builder.append(", ");
            }
            if (this._transportType != null) {
                builder.append("_transportType=");
                builder.append(this._transportType);
                builder.append(", ");
            }
            if (this._variableMetadata != null) {
                builder.append("_variableMetadata=");
                builder.append(this._variableMetadata);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

