/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.path.first.hop.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.rendered.service.path.first.hop.info.RenderedServicePathFirstHop;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.IpPortLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.MplsLocator;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.SlTransportType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RenderedServicePathFirstHopBuilder
implements Builder<RenderedServicePathFirstHop> {
    private IpAddress _ip;
    private Long _mplsLabel;
    private Long _pathId;
    private PortNumber _port;
    private Short _startingIndex;
    private Long _symmetricPathId;
    private Class<? extends SlTransportType> _transportType;
    Map<Class<? extends Augmentation<RenderedServicePathFirstHop>>, Augmentation<RenderedServicePathFirstHop>> augmentation = Collections.emptyMap();

    public RenderedServicePathFirstHopBuilder() {
    }

    public RenderedServicePathFirstHopBuilder(IpPortLocator arg) {
        this._ip = arg.getIp();
        this._port = arg.getPort();
    }

    public RenderedServicePathFirstHopBuilder(MplsLocator arg) {
        this._mplsLabel = arg.getMplsLabel();
    }

    public RenderedServicePathFirstHopBuilder(RenderedServicePathFirstHop base) {
        AugmentationHolder casted;
        this._ip = base.getIp();
        this._mplsLabel = base.getMplsLabel();
        this._pathId = base.getPathId();
        this._port = base.getPort();
        this._startingIndex = base.getStartingIndex();
        this._symmetricPathId = base.getSymmetricPathId();
        this._transportType = base.getTransportType();
        if (base instanceof RenderedServicePathFirstHopImpl) {
            RenderedServicePathFirstHopImpl impl = (RenderedServicePathFirstHopImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePathFirstHop>>, Augmentation<RenderedServicePathFirstHop>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePathFirstHop>>, Augmentation<RenderedServicePathFirstHop>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MplsLocator) {
            this._mplsLabel = ((MplsLocator)arg).getMplsLabel();
            isValidArg = true;
        }
        if (arg instanceof IpPortLocator) {
            this._ip = ((IpPortLocator)arg).getIp();
            this._port = ((IpPortLocator)arg).getPort();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.MplsLocator, org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.sl.rev140701.IpPortLocator] \nbut was: " + arg);
        }
    }

    public IpAddress getIp() {
        return this._ip;
    }

    public Long getMplsLabel() {
        return this._mplsLabel;
    }

    public Long getPathId() {
        return this._pathId;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Short getStartingIndex() {
        return this._startingIndex;
    }

    public Long getSymmetricPathId() {
        return this._symmetricPathId;
    }

    public Class<? extends SlTransportType> getTransportType() {
        return this._transportType;
    }

    public <E extends Augmentation<RenderedServicePathFirstHop>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RenderedServicePathFirstHopBuilder setIp(IpAddress value) {
        this._ip = value;
        return this;
    }

    private static void checkMplsLabelRange(long value) {
        if (value >= 1L && value <= 1048575L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..1048575]].", value));
    }

    public RenderedServicePathFirstHopBuilder setMplsLabel(Long value) {
        if (value != null) {
            RenderedServicePathFirstHopBuilder.checkMplsLabelRange(value);
        }
        this._mplsLabel = value;
        return this;
    }

    private static void checkPathIdRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public RenderedServicePathFirstHopBuilder setPathId(Long value) {
        if (value != null) {
            RenderedServicePathFirstHopBuilder.checkPathIdRange(value);
        }
        this._pathId = value;
        return this;
    }

    public RenderedServicePathFirstHopBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    private static void checkStartingIndexRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public RenderedServicePathFirstHopBuilder setStartingIndex(Short value) {
        if (value != null) {
            RenderedServicePathFirstHopBuilder.checkStartingIndexRange(value);
        }
        this._startingIndex = value;
        return this;
    }

    private static void checkSymmetricPathIdRange(long value) {
        if (value >= 0L && value <= 0x1000000L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..16777216]].", value));
    }

    public RenderedServicePathFirstHopBuilder setSymmetricPathId(Long value) {
        if (value != null) {
            RenderedServicePathFirstHopBuilder.checkSymmetricPathIdRange(value);
        }
        this._symmetricPathId = value;
        return this;
    }

    public RenderedServicePathFirstHopBuilder setTransportType(Class<? extends SlTransportType> value) {
        this._transportType = value;
        return this;
    }

    public RenderedServicePathFirstHopBuilder addAugmentation(Class<? extends Augmentation<RenderedServicePathFirstHop>> augmentationType, Augmentation<RenderedServicePathFirstHop> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePathFirstHop>>, Augmentation<RenderedServicePathFirstHop>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RenderedServicePathFirstHopBuilder removeAugmentation(Class<? extends Augmentation<RenderedServicePathFirstHop>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RenderedServicePathFirstHop build() {
        return new RenderedServicePathFirstHopImpl(this);
    }

    private static final class RenderedServicePathFirstHopImpl
    implements RenderedServicePathFirstHop {
        private final IpAddress _ip;
        private final Long _mplsLabel;
        private final Long _pathId;
        private final PortNumber _port;
        private final Short _startingIndex;
        private final Long _symmetricPathId;
        private final Class<? extends SlTransportType> _transportType;
        private Map<Class<? extends Augmentation<RenderedServicePathFirstHop>>, Augmentation<RenderedServicePathFirstHop>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RenderedServicePathFirstHop> getImplementedInterface() {
            return RenderedServicePathFirstHop.class;
        }

        private RenderedServicePathFirstHopImpl(RenderedServicePathFirstHopBuilder base) {
            this._ip = base.getIp();
            this._mplsLabel = base.getMplsLabel();
            this._pathId = base.getPathId();
            this._port = base.getPort();
            this._startingIndex = base.getStartingIndex();
            this._symmetricPathId = base.getSymmetricPathId();
            this._transportType = base.getTransportType();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RenderedServicePathFirstHop>>, Augmentation<RenderedServicePathFirstHop>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RenderedServicePathFirstHop>>, Augmentation<RenderedServicePathFirstHop>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getIp() {
            return this._ip;
        }

        @Override
        public Long getMplsLabel() {
            return this._mplsLabel;
        }

        @Override
        public Long getPathId() {
            return this._pathId;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public Short getStartingIndex() {
            return this._startingIndex;
        }

        @Override
        public Long getSymmetricPathId() {
            return this._symmetricPathId;
        }

        @Override
        public Class<? extends SlTransportType> getTransportType() {
            return this._transportType;
        }

        public <E extends Augmentation<RenderedServicePathFirstHop>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip);
            result = 31 * result + Objects.hashCode(this._mplsLabel);
            result = 31 * result + Objects.hashCode(this._pathId);
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._startingIndex);
            result = 31 * result + Objects.hashCode(this._symmetricPathId);
            result = 31 * result + Objects.hashCode(this._transportType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RenderedServicePathFirstHop.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RenderedServicePathFirstHop other = (RenderedServicePathFirstHop)obj;
            if (!Objects.equals(this._ip, other.getIp())) {
                return false;
            }
            if (!Objects.equals(this._mplsLabel, other.getMplsLabel())) {
                return false;
            }
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._startingIndex, other.getStartingIndex())) {
                return false;
            }
            if (!Objects.equals(this._symmetricPathId, other.getSymmetricPathId())) {
                return false;
            }
            if (!Objects.equals(this._transportType, other.getTransportType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RenderedServicePathFirstHopImpl otherImpl = (RenderedServicePathFirstHopImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RenderedServicePathFirstHop>>, Augmentation<RenderedServicePathFirstHop>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RenderedServicePathFirstHop [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ip != null) {
                builder.append("_ip=");
                builder.append(this._ip);
                builder.append(", ");
            }
            if (this._mplsLabel != null) {
                builder.append("_mplsLabel=");
                builder.append(this._mplsLabel);
                builder.append(", ");
            }
            if (this._pathId != null) {
                builder.append("_pathId=");
                builder.append(this._pathId);
                builder.append(", ");
            }
            if (this._port != null) {
                builder.append("_port=");
                builder.append(this._port);
                builder.append(", ");
            }
            if (this._startingIndex != null) {
                builder.append("_startingIndex=");
                builder.append(this._startingIndex);
                builder.append(", ");
            }
            if (this._symmetricPathId != null) {
                builder.append("_symmetricPathId=");
                builder.append(this._symmetricPathId);
                builder.append(", ");
            }
            if (this._transportType != null) {
                builder.append("_transportType=");
                builder.append(this._transportType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

