/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.create.rendered.path.input.context.header.allocation.type._1;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.rsp.rev140701.create.rendered.path.input.context.header.allocation.type._1.Mobility;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MobilityBuilder
implements Builder<Mobility> {
    private Boolean _mobilityAllocationEnabled;
    Map<Class<? extends Augmentation<Mobility>>, Augmentation<Mobility>> augmentation = Collections.emptyMap();

    public MobilityBuilder() {
    }

    public MobilityBuilder(Mobility base) {
        AugmentationHolder casted;
        this._mobilityAllocationEnabled = base.isMobilityAllocationEnabled();
        if (base instanceof MobilityImpl) {
            MobilityImpl impl = (MobilityImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Mobility>>, Augmentation<Mobility>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mobility>>, Augmentation<Mobility>>(casted.augmentations());
        }
    }

    public Boolean isMobilityAllocationEnabled() {
        return this._mobilityAllocationEnabled;
    }

    public <E extends Augmentation<Mobility>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MobilityBuilder setMobilityAllocationEnabled(Boolean value) {
        this._mobilityAllocationEnabled = value;
        return this;
    }

    public MobilityBuilder addAugmentation(Class<? extends Augmentation<Mobility>> augmentationType, Augmentation<Mobility> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Mobility>>, Augmentation<Mobility>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MobilityBuilder removeAugmentation(Class<? extends Augmentation<Mobility>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Mobility build() {
        return new MobilityImpl(this);
    }

    private static final class MobilityImpl
    implements Mobility {
        private final Boolean _mobilityAllocationEnabled;
        private Map<Class<? extends Augmentation<Mobility>>, Augmentation<Mobility>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Mobility> getImplementedInterface() {
            return Mobility.class;
        }

        private MobilityImpl(MobilityBuilder base) {
            this._mobilityAllocationEnabled = base.isMobilityAllocationEnabled();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Mobility>>, Augmentation<Mobility>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Mobility>>, Augmentation<Mobility>>(base.augmentation);
                }
            }
        }

        @Override
        public Boolean isMobilityAllocationEnabled() {
            return this._mobilityAllocationEnabled;
        }

        public <E extends Augmentation<Mobility>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mobilityAllocationEnabled);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Mobility.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Mobility other = (Mobility)obj;
            if (!Objects.equals(this._mobilityAllocationEnabled, other.isMobilityAllocationEnabled())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MobilityImpl otherImpl = (MobilityImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Mobility>>, Augmentation<Mobility>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Mobility [";
            StringBuilder builder = new StringBuilder(name);
            if (this._mobilityAllocationEnabled != null) {
                builder.append("_mobilityAllocationEnabled=");
                builder.append(this._mobilityAllocationEnabled);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

