/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.md.rev140701.service.function.metadata.variable.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.md.rev140701.service.function.metadata.variable.metadata.TlvMetadata;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.md.rev140701.service.function.metadata.variable.metadata.TlvMetadataKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TlvMetadataBuilder
implements Builder<TlvMetadata> {
    private TlvMetadata.Flags _flags;
    private TlvMetadataKey _key;
    private Short _length;
    private Integer _tlvClass;
    private String _tlvData;
    private Short _tlvType;
    Map<Class<? extends Augmentation<TlvMetadata>>, Augmentation<TlvMetadata>> augmentation = Collections.emptyMap();

    public TlvMetadataBuilder() {
    }

    public TlvMetadataBuilder(TlvMetadata base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new TlvMetadataKey(base.getTlvClass(), base.getTlvType());
            this._tlvClass = base.getTlvClass();
            this._tlvType = base.getTlvType();
        } else {
            this._key = base.getKey();
            this._tlvClass = this._key.getTlvClass();
            this._tlvType = this._key.getTlvType();
        }
        this._flags = base.getFlags();
        this._length = base.getLength();
        this._tlvData = base.getTlvData();
        if (base instanceof TlvMetadataImpl) {
            TlvMetadataImpl impl = (TlvMetadataImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TlvMetadata>>, Augmentation<TlvMetadata>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TlvMetadata>>, Augmentation<TlvMetadata>>(casted.augmentations());
        }
    }

    public TlvMetadata.Flags getFlags() {
        return this._flags;
    }

    public TlvMetadataKey getKey() {
        return this._key;
    }

    public Short getLength() {
        return this._length;
    }

    public Integer getTlvClass() {
        return this._tlvClass;
    }

    public String getTlvData() {
        return this._tlvData;
    }

    public Short getTlvType() {
        return this._tlvType;
    }

    public <E extends Augmentation<TlvMetadata>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TlvMetadataBuilder setFlags(TlvMetadata.Flags value) {
        this._flags = value;
        return this;
    }

    public TlvMetadataBuilder setKey(TlvMetadataKey value) {
        this._key = value;
        return this;
    }

    private static void checkLengthRange(short value) {
        if (value >= 0 && value <= 32) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..32]].", value));
    }

    public TlvMetadataBuilder setLength(Short value) {
        if (value != null) {
            TlvMetadataBuilder.checkLengthRange(value);
        }
        this._length = value;
        return this;
    }

    private static void checkTlvClassRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public TlvMetadataBuilder setTlvClass(Integer value) {
        if (value != null) {
            TlvMetadataBuilder.checkTlvClassRange(value);
        }
        this._tlvClass = value;
        return this;
    }

    public TlvMetadataBuilder setTlvData(String value) {
        this._tlvData = value;
        return this;
    }

    private static void checkTlvTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public TlvMetadataBuilder setTlvType(Short value) {
        if (value != null) {
            TlvMetadataBuilder.checkTlvTypeRange(value);
        }
        this._tlvType = value;
        return this;
    }

    public TlvMetadataBuilder addAugmentation(Class<? extends Augmentation<TlvMetadata>> augmentationType, Augmentation<TlvMetadata> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TlvMetadata>>, Augmentation<TlvMetadata>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TlvMetadataBuilder removeAugmentation(Class<? extends Augmentation<TlvMetadata>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TlvMetadata build() {
        return new TlvMetadataImpl(this);
    }

    private static final class TlvMetadataImpl
    implements TlvMetadata {
        private final TlvMetadata.Flags _flags;
        private final TlvMetadataKey _key;
        private final Short _length;
        private final Integer _tlvClass;
        private final String _tlvData;
        private final Short _tlvType;
        private Map<Class<? extends Augmentation<TlvMetadata>>, Augmentation<TlvMetadata>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TlvMetadata> getImplementedInterface() {
            return TlvMetadata.class;
        }

        private TlvMetadataImpl(TlvMetadataBuilder base) {
            if (base.getKey() == null) {
                this._key = new TlvMetadataKey(base.getTlvClass(), base.getTlvType());
                this._tlvClass = base.getTlvClass();
                this._tlvType = base.getTlvType();
            } else {
                this._key = base.getKey();
                this._tlvClass = this._key.getTlvClass();
                this._tlvType = this._key.getTlvType();
            }
            this._flags = base.getFlags();
            this._length = base.getLength();
            this._tlvData = base.getTlvData();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TlvMetadata>>, Augmentation<TlvMetadata>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TlvMetadata>>, Augmentation<TlvMetadata>>(base.augmentation);
                }
            }
        }

        @Override
        public TlvMetadata.Flags getFlags() {
            return this._flags;
        }

        @Override
        public TlvMetadataKey getKey() {
            return this._key;
        }

        @Override
        public Short getLength() {
            return this._length;
        }

        @Override
        public Integer getTlvClass() {
            return this._tlvClass;
        }

        @Override
        public String getTlvData() {
            return this._tlvData;
        }

        @Override
        public Short getTlvType() {
            return this._tlvType;
        }

        public <E extends Augmentation<TlvMetadata>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._length);
            result = 31 * result + Objects.hashCode(this._tlvClass);
            result = 31 * result + Objects.hashCode(this._tlvData);
            result = 31 * result + Objects.hashCode(this._tlvType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TlvMetadata.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TlvMetadata other = (TlvMetadata)obj;
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._length, other.getLength())) {
                return false;
            }
            if (!Objects.equals(this._tlvClass, other.getTlvClass())) {
                return false;
            }
            if (!Objects.equals(this._tlvData, other.getTlvData())) {
                return false;
            }
            if (!Objects.equals(this._tlvType, other.getTlvType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TlvMetadataImpl otherImpl = (TlvMetadataImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TlvMetadata>>, Augmentation<TlvMetadata>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "TlvMetadata [";
            StringBuilder builder = new StringBuilder(name);
            if (this._flags != null) {
                builder.append("_flags=");
                builder.append(this._flags);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._length != null) {
                builder.append("_length=");
                builder.append(this._length);
                builder.append(", ");
            }
            if (this._tlvClass != null) {
                builder.append("_tlvClass=");
                builder.append(this._tlvClass);
                builder.append(", ");
            }
            if (this._tlvData != null) {
                builder.append("_tlvData=");
                builder.append(this._tlvData);
                builder.append(", ");
            }
            if (this._tlvType != null) {
                builder.append("_tlvType=");
                builder.append(this._tlvType);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

