/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.md.rev140701.service.function.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.md.rev140701.service.function.metadata.ContextMetadata;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.md.rev140701.service.function.metadata.ContextMetadataKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ContextMetadataBuilder
implements Builder<ContextMetadata> {
    private Long _contextHeader1;
    private Long _contextHeader2;
    private Long _contextHeader3;
    private Long _contextHeader4;
    private ContextMetadataKey _key;
    private String _name;
    Map<Class<? extends Augmentation<ContextMetadata>>, Augmentation<ContextMetadata>> augmentation = Collections.emptyMap();

    public ContextMetadataBuilder() {
    }

    public ContextMetadataBuilder(ContextMetadata base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ContextMetadataKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._contextHeader1 = base.getContextHeader1();
        this._contextHeader2 = base.getContextHeader2();
        this._contextHeader3 = base.getContextHeader3();
        this._contextHeader4 = base.getContextHeader4();
        if (base instanceof ContextMetadataImpl) {
            ContextMetadataImpl impl = (ContextMetadataImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ContextMetadata>>, Augmentation<ContextMetadata>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ContextMetadata>>, Augmentation<ContextMetadata>>(casted.augmentations());
        }
    }

    public Long getContextHeader1() {
        return this._contextHeader1;
    }

    public Long getContextHeader2() {
        return this._contextHeader2;
    }

    public Long getContextHeader3() {
        return this._contextHeader3;
    }

    public Long getContextHeader4() {
        return this._contextHeader4;
    }

    public ContextMetadataKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public <E extends Augmentation<ContextMetadata>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkContextHeader1Range(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ContextMetadataBuilder setContextHeader1(Long value) {
        if (value != null) {
            ContextMetadataBuilder.checkContextHeader1Range(value);
        }
        this._contextHeader1 = value;
        return this;
    }

    private static void checkContextHeader2Range(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ContextMetadataBuilder setContextHeader2(Long value) {
        if (value != null) {
            ContextMetadataBuilder.checkContextHeader2Range(value);
        }
        this._contextHeader2 = value;
        return this;
    }

    private static void checkContextHeader3Range(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ContextMetadataBuilder setContextHeader3(Long value) {
        if (value != null) {
            ContextMetadataBuilder.checkContextHeader3Range(value);
        }
        this._contextHeader3 = value;
        return this;
    }

    private static void checkContextHeader4Range(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ContextMetadataBuilder setContextHeader4(Long value) {
        if (value != null) {
            ContextMetadataBuilder.checkContextHeader4Range(value);
        }
        this._contextHeader4 = value;
        return this;
    }

    public ContextMetadataBuilder setKey(ContextMetadataKey value) {
        this._key = value;
        return this;
    }

    public ContextMetadataBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ContextMetadataBuilder addAugmentation(Class<? extends Augmentation<ContextMetadata>> augmentationType, Augmentation<ContextMetadata> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ContextMetadata>>, Augmentation<ContextMetadata>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ContextMetadataBuilder removeAugmentation(Class<? extends Augmentation<ContextMetadata>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ContextMetadata build() {
        return new ContextMetadataImpl(this);
    }

    private static final class ContextMetadataImpl
    implements ContextMetadata {
        private final Long _contextHeader1;
        private final Long _contextHeader2;
        private final Long _contextHeader3;
        private final Long _contextHeader4;
        private final ContextMetadataKey _key;
        private final String _name;
        private Map<Class<? extends Augmentation<ContextMetadata>>, Augmentation<ContextMetadata>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ContextMetadata> getImplementedInterface() {
            return ContextMetadata.class;
        }

        private ContextMetadataImpl(ContextMetadataBuilder base) {
            if (base.getKey() == null) {
                this._key = new ContextMetadataKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._contextHeader1 = base.getContextHeader1();
            this._contextHeader2 = base.getContextHeader2();
            this._contextHeader3 = base.getContextHeader3();
            this._contextHeader4 = base.getContextHeader4();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ContextMetadata>>, Augmentation<ContextMetadata>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ContextMetadata>>, Augmentation<ContextMetadata>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getContextHeader1() {
            return this._contextHeader1;
        }

        @Override
        public Long getContextHeader2() {
            return this._contextHeader2;
        }

        @Override
        public Long getContextHeader3() {
            return this._contextHeader3;
        }

        @Override
        public Long getContextHeader4() {
            return this._contextHeader4;
        }

        @Override
        public ContextMetadataKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public <E extends Augmentation<ContextMetadata>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._contextHeader1);
            result = 31 * result + Objects.hashCode(this._contextHeader2);
            result = 31 * result + Objects.hashCode(this._contextHeader3);
            result = 31 * result + Objects.hashCode(this._contextHeader4);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ContextMetadata.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ContextMetadata other = (ContextMetadata)obj;
            if (!Objects.equals(this._contextHeader1, other.getContextHeader1())) {
                return false;
            }
            if (!Objects.equals(this._contextHeader2, other.getContextHeader2())) {
                return false;
            }
            if (!Objects.equals(this._contextHeader3, other.getContextHeader3())) {
                return false;
            }
            if (!Objects.equals(this._contextHeader4, other.getContextHeader4())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ContextMetadataImpl otherImpl = (ContextMetadataImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ContextMetadata>>, Augmentation<ContextMetadata>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ContextMetadata [";
            StringBuilder builder = new StringBuilder(name);
            if (this._contextHeader1 != null) {
                builder.append("_contextHeader1=");
                builder.append(this._contextHeader1);
                builder.append(", ");
            }
            if (this._contextHeader2 != null) {
                builder.append("_contextHeader2=");
                builder.append(this._contextHeader2);
                builder.append(", ");
            }
            if (this._contextHeader3 != null) {
                builder.append("_contextHeader3=");
                builder.append(this._contextHeader3);
                builder.append(", ");
            }
            if (this._contextHeader4 != null) {
                builder.append("_contextHeader4=");
                builder.append(this._contextHeader4);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

