/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profiles;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.PathIdentifierIdentity;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.PotProfile;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.ProfileIndexRange;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profile.PotProfileList;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profiles.PotProfileSet;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profiles.PotProfileSetKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PotProfileSetBuilder
implements Builder<PotProfileSet> {
    private ProfileIndexRange _activeProfileIndex;
    private PotProfileSetKey _key;
    private String _name;
    private String _pathIdentifier;
    private Class<? extends PathIdentifierIdentity> _pathIdentifierTypeValue;
    private List<PotProfileList> _potProfileList;
    Map<Class<? extends Augmentation<PotProfileSet>>, Augmentation<PotProfileSet>> augmentation = Collections.emptyMap();

    public PotProfileSetBuilder() {
    }

    public PotProfileSetBuilder(PotProfile arg) {
        this._potProfileList = arg.getPotProfileList();
    }

    public PotProfileSetBuilder(PotProfileSet base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new PotProfileSetKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._activeProfileIndex = base.getActiveProfileIndex();
        this._pathIdentifier = base.getPathIdentifier();
        this._pathIdentifierTypeValue = base.getPathIdentifierTypeValue();
        this._potProfileList = base.getPotProfileList();
        if (base instanceof PotProfileSetImpl) {
            PotProfileSetImpl impl = (PotProfileSetImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PotProfileSet>>, Augmentation<PotProfileSet>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PotProfileSet>>, Augmentation<PotProfileSet>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PotProfile) {
            this._potProfileList = ((PotProfile)arg).getPotProfileList();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.PotProfile] \nbut was: " + arg);
        }
    }

    public ProfileIndexRange getActiveProfileIndex() {
        return this._activeProfileIndex;
    }

    public PotProfileSetKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public String getPathIdentifier() {
        return this._pathIdentifier;
    }

    public Class<? extends PathIdentifierIdentity> getPathIdentifierTypeValue() {
        return this._pathIdentifierTypeValue;
    }

    public List<PotProfileList> getPotProfileList() {
        return this._potProfileList;
    }

    public <E extends Augmentation<PotProfileSet>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PotProfileSetBuilder setActiveProfileIndex(ProfileIndexRange value) {
        this._activeProfileIndex = value;
        return this;
    }

    public PotProfileSetBuilder setKey(PotProfileSetKey value) {
        this._key = value;
        return this;
    }

    public PotProfileSetBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public PotProfileSetBuilder setPathIdentifier(String value) {
        this._pathIdentifier = value;
        return this;
    }

    public PotProfileSetBuilder setPathIdentifierTypeValue(Class<? extends PathIdentifierIdentity> value) {
        this._pathIdentifierTypeValue = value;
        return this;
    }

    public PotProfileSetBuilder setPotProfileList(List<PotProfileList> value) {
        this._potProfileList = value;
        return this;
    }

    public PotProfileSetBuilder addAugmentation(Class<? extends Augmentation<PotProfileSet>> augmentationType, Augmentation<PotProfileSet> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PotProfileSet>>, Augmentation<PotProfileSet>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PotProfileSetBuilder removeAugmentation(Class<? extends Augmentation<PotProfileSet>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PotProfileSet build() {
        return new PotProfileSetImpl(this);
    }

    private static final class PotProfileSetImpl
    implements PotProfileSet {
        private final ProfileIndexRange _activeProfileIndex;
        private final PotProfileSetKey _key;
        private final String _name;
        private final String _pathIdentifier;
        private final Class<? extends PathIdentifierIdentity> _pathIdentifierTypeValue;
        private final List<PotProfileList> _potProfileList;
        private Map<Class<? extends Augmentation<PotProfileSet>>, Augmentation<PotProfileSet>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PotProfileSet> getImplementedInterface() {
            return PotProfileSet.class;
        }

        private PotProfileSetImpl(PotProfileSetBuilder base) {
            if (base.getKey() == null) {
                this._key = new PotProfileSetKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._activeProfileIndex = base.getActiveProfileIndex();
            this._pathIdentifier = base.getPathIdentifier();
            this._pathIdentifierTypeValue = base.getPathIdentifierTypeValue();
            this._potProfileList = base.getPotProfileList();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PotProfileSet>>, Augmentation<PotProfileSet>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PotProfileSet>>, Augmentation<PotProfileSet>>(base.augmentation);
                }
            }
        }

        @Override
        public ProfileIndexRange getActiveProfileIndex() {
            return this._activeProfileIndex;
        }

        @Override
        public PotProfileSetKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getPathIdentifier() {
            return this._pathIdentifier;
        }

        @Override
        public Class<? extends PathIdentifierIdentity> getPathIdentifierTypeValue() {
            return this._pathIdentifierTypeValue;
        }

        @Override
        public List<PotProfileList> getPotProfileList() {
            return this._potProfileList;
        }

        public <E extends Augmentation<PotProfileSet>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._activeProfileIndex);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._pathIdentifier);
            result = 31 * result + Objects.hashCode(this._pathIdentifierTypeValue);
            result = 31 * result + Objects.hashCode(this._potProfileList);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PotProfileSet.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PotProfileSet other = (PotProfileSet)obj;
            if (!Objects.equals(this._activeProfileIndex, other.getActiveProfileIndex())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._pathIdentifier, other.getPathIdentifier())) {
                return false;
            }
            if (!Objects.equals(this._pathIdentifierTypeValue, other.getPathIdentifierTypeValue())) {
                return false;
            }
            if (!Objects.equals(this._potProfileList, other.getPotProfileList())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PotProfileSetImpl otherImpl = (PotProfileSetImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PotProfileSet>>, Augmentation<PotProfileSet>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PotProfileSet [";
            StringBuilder builder = new StringBuilder(name);
            if (this._activeProfileIndex != null) {
                builder.append("_activeProfileIndex=");
                builder.append(this._activeProfileIndex);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._pathIdentifier != null) {
                builder.append("_pathIdentifier=");
                builder.append(this._pathIdentifier);
                builder.append(", ");
            }
            if (this._pathIdentifierTypeValue != null) {
                builder.append("_pathIdentifierTypeValue=");
                builder.append(this._pathIdentifierTypeValue);
                builder.append(", ");
            }
            if (this._potProfileList != null) {
                builder.append("_potProfileList=");
                builder.append(this._potProfileList);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

