/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profile;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.ProfileIndexRange;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profile.PotProfileList;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.pot.profile.PotProfileListKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PotProfileListBuilder
implements Builder<PotProfileList> {
    private ProfileIndexRange _index;
    private PotProfileListKey _key;
    private BigInteger _lpc;
    private Short _numberOfBits;
    private BigInteger _primeNumber;
    private BigInteger _publicPolynomial;
    private BigInteger _secretShare;
    private BigInteger _validatorKey;
    private Boolean _validator;
    Map<Class<? extends Augmentation<PotProfileList>>, Augmentation<PotProfileList>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKLPCRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPRIMENUMBERRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKPUBLICPOLYNOMIALRANGE_RANGES;
    private static final Range<BigInteger>[] CHECKSECRETSHARERANGE_RANGES;
    private static final Range<BigInteger>[] CHECKVALIDATORKEYRANGE_RANGES;

    public PotProfileListBuilder() {
    }

    public PotProfileListBuilder(PotProfileList base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new PotProfileListKey(base.getIndex());
            this._index = base.getIndex();
        } else {
            this._key = base.getKey();
            this._index = this._key.getIndex();
        }
        this._lpc = base.getLpc();
        this._numberOfBits = base.getNumberOfBits();
        this._primeNumber = base.getPrimeNumber();
        this._publicPolynomial = base.getPublicPolynomial();
        this._secretShare = base.getSecretShare();
        this._validatorKey = base.getValidatorKey();
        this._validator = base.isValidator();
        if (base instanceof PotProfileListImpl) {
            PotProfileListImpl impl = (PotProfileListImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PotProfileList>>, Augmentation<PotProfileList>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PotProfileList>>, Augmentation<PotProfileList>>(casted.augmentations());
        }
    }

    public ProfileIndexRange getIndex() {
        return this._index;
    }

    public PotProfileListKey getKey() {
        return this._key;
    }

    public BigInteger getLpc() {
        return this._lpc;
    }

    public Short getNumberOfBits() {
        return this._numberOfBits;
    }

    public BigInteger getPrimeNumber() {
        return this._primeNumber;
    }

    public BigInteger getPublicPolynomial() {
        return this._publicPolynomial;
    }

    public BigInteger getSecretShare() {
        return this._secretShare;
    }

    public BigInteger getValidatorKey() {
        return this._validatorKey;
    }

    public Boolean isValidator() {
        return this._validator;
    }

    public <E extends Augmentation<PotProfileList>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PotProfileListBuilder setIndex(ProfileIndexRange value) {
        this._index = value;
        return this;
    }

    public PotProfileListBuilder setKey(PotProfileListKey value) {
        this._key = value;
        return this;
    }

    private static void checkLpcRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKLPCRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKLPCRANGE_RANGES)));
    }

    public PotProfileListBuilder setLpc(BigInteger value) {
        if (value != null) {
            PotProfileListBuilder.checkLpcRange(value);
        }
        this._lpc = value;
        return this;
    }

    private static void checkNumberOfBitsRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public PotProfileListBuilder setNumberOfBits(Short value) {
        if (value != null) {
            PotProfileListBuilder.checkNumberOfBitsRange(value);
        }
        this._numberOfBits = value;
        return this;
    }

    private static void checkPrimeNumberRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPRIMENUMBERRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPRIMENUMBERRANGE_RANGES)));
    }

    public PotProfileListBuilder setPrimeNumber(BigInteger value) {
        if (value != null) {
            PotProfileListBuilder.checkPrimeNumberRange(value);
        }
        this._primeNumber = value;
        return this;
    }

    private static void checkPublicPolynomialRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKPUBLICPOLYNOMIALRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKPUBLICPOLYNOMIALRANGE_RANGES)));
    }

    public PotProfileListBuilder setPublicPolynomial(BigInteger value) {
        if (value != null) {
            PotProfileListBuilder.checkPublicPolynomialRange(value);
        }
        this._publicPolynomial = value;
        return this;
    }

    private static void checkSecretShareRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKSECRETSHARERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKSECRETSHARERANGE_RANGES)));
    }

    public PotProfileListBuilder setSecretShare(BigInteger value) {
        if (value != null) {
            PotProfileListBuilder.checkSecretShareRange(value);
        }
        this._secretShare = value;
        return this;
    }

    private static void checkValidatorKeyRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKVALIDATORKEYRANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKVALIDATORKEYRANGE_RANGES)));
    }

    public PotProfileListBuilder setValidatorKey(BigInteger value) {
        if (value != null) {
            PotProfileListBuilder.checkValidatorKeyRange(value);
        }
        this._validatorKey = value;
        return this;
    }

    public PotProfileListBuilder setValidator(Boolean value) {
        this._validator = value;
        return this;
    }

    public PotProfileListBuilder addAugmentation(Class<? extends Augmentation<PotProfileList>> augmentationType, Augmentation<PotProfileList> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PotProfileList>>, Augmentation<PotProfileList>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PotProfileListBuilder removeAugmentation(Class<? extends Augmentation<PotProfileList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PotProfileList build() {
        return new PotProfileListImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKLPCRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPRIMENUMBERRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKPUBLICPOLYNOMIALRANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKSECRETSHARERANGE_RANGES = a;
        a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKVALIDATORKEYRANGE_RANGES = a;
    }

    private static final class PotProfileListImpl
    implements PotProfileList {
        private final ProfileIndexRange _index;
        private final PotProfileListKey _key;
        private final BigInteger _lpc;
        private final Short _numberOfBits;
        private final BigInteger _primeNumber;
        private final BigInteger _publicPolynomial;
        private final BigInteger _secretShare;
        private final BigInteger _validatorKey;
        private final Boolean _validator;
        private Map<Class<? extends Augmentation<PotProfileList>>, Augmentation<PotProfileList>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PotProfileList> getImplementedInterface() {
            return PotProfileList.class;
        }

        private PotProfileListImpl(PotProfileListBuilder base) {
            if (base.getKey() == null) {
                this._key = new PotProfileListKey(base.getIndex());
                this._index = base.getIndex();
            } else {
                this._key = base.getKey();
                this._index = this._key.getIndex();
            }
            this._lpc = base.getLpc();
            this._numberOfBits = base.getNumberOfBits();
            this._primeNumber = base.getPrimeNumber();
            this._publicPolynomial = base.getPublicPolynomial();
            this._secretShare = base.getSecretShare();
            this._validatorKey = base.getValidatorKey();
            this._validator = base.isValidator();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PotProfileList>>, Augmentation<PotProfileList>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PotProfileList>>, Augmentation<PotProfileList>>(base.augmentation);
                }
            }
        }

        @Override
        public ProfileIndexRange getIndex() {
            return this._index;
        }

        @Override
        public PotProfileListKey getKey() {
            return this._key;
        }

        @Override
        public BigInteger getLpc() {
            return this._lpc;
        }

        @Override
        public Short getNumberOfBits() {
            return this._numberOfBits;
        }

        @Override
        public BigInteger getPrimeNumber() {
            return this._primeNumber;
        }

        @Override
        public BigInteger getPublicPolynomial() {
            return this._publicPolynomial;
        }

        @Override
        public BigInteger getSecretShare() {
            return this._secretShare;
        }

        @Override
        public BigInteger getValidatorKey() {
            return this._validatorKey;
        }

        @Override
        public Boolean isValidator() {
            return this._validator;
        }

        public <E extends Augmentation<PotProfileList>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._index);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._lpc);
            result = 31 * result + Objects.hashCode(this._numberOfBits);
            result = 31 * result + Objects.hashCode(this._primeNumber);
            result = 31 * result + Objects.hashCode(this._publicPolynomial);
            result = 31 * result + Objects.hashCode(this._secretShare);
            result = 31 * result + Objects.hashCode(this._validatorKey);
            result = 31 * result + Objects.hashCode(this._validator);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PotProfileList.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PotProfileList other = (PotProfileList)obj;
            if (!Objects.equals(this._index, other.getIndex())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._lpc, other.getLpc())) {
                return false;
            }
            if (!Objects.equals(this._numberOfBits, other.getNumberOfBits())) {
                return false;
            }
            if (!Objects.equals(this._primeNumber, other.getPrimeNumber())) {
                return false;
            }
            if (!Objects.equals(this._publicPolynomial, other.getPublicPolynomial())) {
                return false;
            }
            if (!Objects.equals(this._secretShare, other.getSecretShare())) {
                return false;
            }
            if (!Objects.equals(this._validatorKey, other.getValidatorKey())) {
                return false;
            }
            if (!Objects.equals(this._validator, other.isValidator())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PotProfileListImpl otherImpl = (PotProfileListImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PotProfileList>>, Augmentation<PotProfileList>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PotProfileList [";
            StringBuilder builder = new StringBuilder(name);
            if (this._index != null) {
                builder.append("_index=");
                builder.append(this._index);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._lpc != null) {
                builder.append("_lpc=");
                builder.append(this._lpc);
                builder.append(", ");
            }
            if (this._numberOfBits != null) {
                builder.append("_numberOfBits=");
                builder.append(this._numberOfBits);
                builder.append(", ");
            }
            if (this._primeNumber != null) {
                builder.append("_primeNumber=");
                builder.append(this._primeNumber);
                builder.append(", ");
            }
            if (this._publicPolynomial != null) {
                builder.append("_publicPolynomial=");
                builder.append(this._publicPolynomial);
                builder.append(", ");
            }
            if (this._secretShare != null) {
                builder.append("_secretShare=");
                builder.append(this._secretShare);
                builder.append(", ");
            }
            if (this._validatorKey != null) {
                builder.append("_validatorKey=");
                builder.append(this._validatorKey);
                builder.append(", ");
            }
            if (this._validator != null) {
                builder.append("_validator=");
                builder.append(this._validator);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

