/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class ProfileIndexRange
implements Serializable {
    private static final long serialVersionUID = -6682683666196083004L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= -1 && value <= 1) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[-1..1]].", value));
    }

    @ConstructorProperties(value={"value"})
    public ProfileIndexRange(Integer _value) {
        if (_value != null) {
            ProfileIndexRange.check_valueRange(_value);
        }
        Preconditions.checkNotNull((Object)_value, (Object)"Supplied value may not be null");
        this._value = _value;
    }

    public ProfileIndexRange(ProfileIndexRange source) {
        this._value = source._value;
    }

    public static ProfileIndexRange getDefaultInstance(String defaultValue) {
        return new ProfileIndexRange(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfileIndexRange other = (ProfileIndexRange)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(ProfileIndexRange.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

