/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.PolyParameter;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.PolyParameterKey;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.Coeffs;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.poly.parameter.Lpcs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PolyParameterBuilder
implements Builder<PolyParameter> {
    private List<Coeffs> _coeffs;
    private PolyParameterKey _key;
    private List<Lpcs> _lpcs;
    private Long _pindex;
    private Long _prime;
    Map<Class<? extends Augmentation<PolyParameter>>, Augmentation<PolyParameter>> augmentation = Collections.emptyMap();

    public PolyParameterBuilder() {
    }

    public PolyParameterBuilder(PolyParameter base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new PolyParameterKey(base.getPindex());
            this._pindex = base.getPindex();
        } else {
            this._key = base.getKey();
            this._pindex = this._key.getPindex();
        }
        this._coeffs = base.getCoeffs();
        this._lpcs = base.getLpcs();
        this._prime = base.getPrime();
        if (base instanceof PolyParameterImpl) {
            PolyParameterImpl impl = (PolyParameterImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PolyParameter>>, Augmentation<PolyParameter>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PolyParameter>>, Augmentation<PolyParameter>>(casted.augmentations());
        }
    }

    public List<Coeffs> getCoeffs() {
        return this._coeffs;
    }

    public PolyParameterKey getKey() {
        return this._key;
    }

    public List<Lpcs> getLpcs() {
        return this._lpcs;
    }

    public Long getPindex() {
        return this._pindex;
    }

    public Long getPrime() {
        return this._prime;
    }

    public <E extends Augmentation<PolyParameter>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PolyParameterBuilder setCoeffs(List<Coeffs> value) {
        this._coeffs = value;
        return this;
    }

    public PolyParameterBuilder setKey(PolyParameterKey value) {
        this._key = value;
        return this;
    }

    public PolyParameterBuilder setLpcs(List<Lpcs> value) {
        this._lpcs = value;
        return this;
    }

    private static void checkPindexRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PolyParameterBuilder setPindex(Long value) {
        if (value != null) {
            PolyParameterBuilder.checkPindexRange(value);
        }
        this._pindex = value;
        return this;
    }

    public PolyParameterBuilder setPrime(Long value) {
        this._prime = value;
        return this;
    }

    public PolyParameterBuilder addAugmentation(Class<? extends Augmentation<PolyParameter>> augmentationType, Augmentation<PolyParameter> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PolyParameter>>, Augmentation<PolyParameter>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PolyParameterBuilder removeAugmentation(Class<? extends Augmentation<PolyParameter>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PolyParameter build() {
        return new PolyParameterImpl(this);
    }

    private static final class PolyParameterImpl
    implements PolyParameter {
        private final List<Coeffs> _coeffs;
        private final PolyParameterKey _key;
        private final List<Lpcs> _lpcs;
        private final Long _pindex;
        private final Long _prime;
        private Map<Class<? extends Augmentation<PolyParameter>>, Augmentation<PolyParameter>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PolyParameter> getImplementedInterface() {
            return PolyParameter.class;
        }

        private PolyParameterImpl(PolyParameterBuilder base) {
            if (base.getKey() == null) {
                this._key = new PolyParameterKey(base.getPindex());
                this._pindex = base.getPindex();
            } else {
                this._key = base.getKey();
                this._pindex = this._key.getPindex();
            }
            this._coeffs = base.getCoeffs();
            this._lpcs = base.getLpcs();
            this._prime = base.getPrime();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PolyParameter>>, Augmentation<PolyParameter>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PolyParameter>>, Augmentation<PolyParameter>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Coeffs> getCoeffs() {
            return this._coeffs;
        }

        @Override
        public PolyParameterKey getKey() {
            return this._key;
        }

        @Override
        public List<Lpcs> getLpcs() {
            return this._lpcs;
        }

        @Override
        public Long getPindex() {
            return this._pindex;
        }

        @Override
        public Long getPrime() {
            return this._prime;
        }

        public <E extends Augmentation<PolyParameter>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._coeffs);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._lpcs);
            result = 31 * result + Objects.hashCode(this._pindex);
            result = 31 * result + Objects.hashCode(this._prime);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PolyParameter.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PolyParameter other = (PolyParameter)obj;
            if (!Objects.equals(this._coeffs, other.getCoeffs())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._lpcs, other.getLpcs())) {
                return false;
            }
            if (!Objects.equals(this._pindex, other.getPindex())) {
                return false;
            }
            if (!Objects.equals(this._prime, other.getPrime())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PolyParameterImpl otherImpl = (PolyParameterImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PolyParameter>>, Augmentation<PolyParameter>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PolyParameter [";
            StringBuilder builder = new StringBuilder(name);
            if (this._coeffs != null) {
                builder.append("_coeffs=");
                builder.append(this._coeffs);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._lpcs != null) {
                builder.append("_lpcs=");
                builder.append(this._lpcs);
                builder.append(", ");
            }
            if (this._pindex != null) {
                builder.append("_pindex=");
                builder.append(this._pindex);
                builder.append(", ");
            }
            if (this._prime != null) {
                builder.append("_prime=");
                builder.append(this._prime);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

