/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.BitMaskOptions;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RefreshPeriodInterval;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.TimeResolution;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.PolyParameters;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.params.rev161205.poly.parameters.PolyParameter;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.rev170112.ProfileIndexRange;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PolyParametersBuilder
implements Builder<PolyParameters> {
    private ProfileIndexRange _activeProfileIndex;
    private List<PolyParameter> _polyParameter;
    private BitMaskOptions _profileBitMaskValue;
    private Class<? extends TimeResolution> _refreshPeriodTimeUnits;
    private Long _refreshPeriodValue;
    Map<Class<? extends Augmentation<PolyParameters>>, Augmentation<PolyParameters>> augmentation = Collections.emptyMap();

    public PolyParametersBuilder() {
    }

    public PolyParametersBuilder(RefreshPeriodInterval arg) {
        this._refreshPeriodTimeUnits = arg.getRefreshPeriodTimeUnits();
        this._refreshPeriodValue = arg.getRefreshPeriodValue();
    }

    public PolyParametersBuilder(PolyParameters base) {
        AugmentationHolder casted;
        this._activeProfileIndex = base.getActiveProfileIndex();
        this._polyParameter = base.getPolyParameter();
        this._profileBitMaskValue = base.getProfileBitMaskValue();
        this._refreshPeriodTimeUnits = base.getRefreshPeriodTimeUnits();
        this._refreshPeriodValue = base.getRefreshPeriodValue();
        if (base instanceof PolyParametersImpl) {
            PolyParametersImpl impl = (PolyParametersImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PolyParameters>>, Augmentation<PolyParameters>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PolyParameters>>, Augmentation<PolyParameters>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RefreshPeriodInterval) {
            this._refreshPeriodTimeUnits = ((RefreshPeriodInterval)arg).getRefreshPeriodTimeUnits();
            this._refreshPeriodValue = ((RefreshPeriodInterval)arg).getRefreshPeriodValue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RefreshPeriodInterval] \nbut was: " + arg);
        }
    }

    public ProfileIndexRange getActiveProfileIndex() {
        return this._activeProfileIndex;
    }

    public List<PolyParameter> getPolyParameter() {
        return this._polyParameter;
    }

    public BitMaskOptions getProfileBitMaskValue() {
        return this._profileBitMaskValue;
    }

    public Class<? extends TimeResolution> getRefreshPeriodTimeUnits() {
        return this._refreshPeriodTimeUnits;
    }

    public Long getRefreshPeriodValue() {
        return this._refreshPeriodValue;
    }

    public <E extends Augmentation<PolyParameters>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PolyParametersBuilder setActiveProfileIndex(ProfileIndexRange value) {
        this._activeProfileIndex = value;
        return this;
    }

    public PolyParametersBuilder setPolyParameter(List<PolyParameter> value) {
        this._polyParameter = value;
        return this;
    }

    public PolyParametersBuilder setProfileBitMaskValue(BitMaskOptions value) {
        this._profileBitMaskValue = value;
        return this;
    }

    public PolyParametersBuilder setRefreshPeriodTimeUnits(Class<? extends TimeResolution> value) {
        this._refreshPeriodTimeUnits = value;
        return this;
    }

    private static void checkRefreshPeriodValueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PolyParametersBuilder setRefreshPeriodValue(Long value) {
        if (value != null) {
            PolyParametersBuilder.checkRefreshPeriodValueRange(value);
        }
        this._refreshPeriodValue = value;
        return this;
    }

    public PolyParametersBuilder addAugmentation(Class<? extends Augmentation<PolyParameters>> augmentationType, Augmentation<PolyParameters> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PolyParameters>>, Augmentation<PolyParameters>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PolyParametersBuilder removeAugmentation(Class<? extends Augmentation<PolyParameters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PolyParameters build() {
        return new PolyParametersImpl(this);
    }

    private static final class PolyParametersImpl
    implements PolyParameters {
        private final ProfileIndexRange _activeProfileIndex;
        private final List<PolyParameter> _polyParameter;
        private final BitMaskOptions _profileBitMaskValue;
        private final Class<? extends TimeResolution> _refreshPeriodTimeUnits;
        private final Long _refreshPeriodValue;
        private Map<Class<? extends Augmentation<PolyParameters>>, Augmentation<PolyParameters>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PolyParameters> getImplementedInterface() {
            return PolyParameters.class;
        }

        private PolyParametersImpl(PolyParametersBuilder base) {
            this._activeProfileIndex = base.getActiveProfileIndex();
            this._polyParameter = base.getPolyParameter();
            this._profileBitMaskValue = base.getProfileBitMaskValue();
            this._refreshPeriodTimeUnits = base.getRefreshPeriodTimeUnits();
            this._refreshPeriodValue = base.getRefreshPeriodValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PolyParameters>>, Augmentation<PolyParameters>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PolyParameters>>, Augmentation<PolyParameters>>(base.augmentation);
                }
            }
        }

        @Override
        public ProfileIndexRange getActiveProfileIndex() {
            return this._activeProfileIndex;
        }

        @Override
        public List<PolyParameter> getPolyParameter() {
            return this._polyParameter;
        }

        @Override
        public BitMaskOptions getProfileBitMaskValue() {
            return this._profileBitMaskValue;
        }

        @Override
        public Class<? extends TimeResolution> getRefreshPeriodTimeUnits() {
            return this._refreshPeriodTimeUnits;
        }

        @Override
        public Long getRefreshPeriodValue() {
            return this._refreshPeriodValue;
        }

        public <E extends Augmentation<PolyParameters>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._activeProfileIndex);
            result = 31 * result + Objects.hashCode(this._polyParameter);
            result = 31 * result + Objects.hashCode((Object)this._profileBitMaskValue);
            result = 31 * result + Objects.hashCode(this._refreshPeriodTimeUnits);
            result = 31 * result + Objects.hashCode(this._refreshPeriodValue);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PolyParameters.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PolyParameters other = (PolyParameters)obj;
            if (!Objects.equals(this._activeProfileIndex, other.getActiveProfileIndex())) {
                return false;
            }
            if (!Objects.equals(this._polyParameter, other.getPolyParameter())) {
                return false;
            }
            if (!Objects.equals((Object)this._profileBitMaskValue, (Object)other.getProfileBitMaskValue())) {
                return false;
            }
            if (!Objects.equals(this._refreshPeriodTimeUnits, other.getRefreshPeriodTimeUnits())) {
                return false;
            }
            if (!Objects.equals(this._refreshPeriodValue, other.getRefreshPeriodValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PolyParametersImpl otherImpl = (PolyParametersImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PolyParameters>>, Augmentation<PolyParameters>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PolyParameters [";
            StringBuilder builder = new StringBuilder(name);
            if (this._activeProfileIndex != null) {
                builder.append("_activeProfileIndex=");
                builder.append(this._activeProfileIndex);
                builder.append(", ");
            }
            if (this._polyParameter != null) {
                builder.append("_polyParameter=");
                builder.append(this._polyParameter);
                builder.append(", ");
            }
            if (this._profileBitMaskValue != null) {
                builder.append("_profileBitMaskValue=");
                builder.append((Object)this._profileBitMaskValue);
                builder.append(", ");
            }
            if (this._refreshPeriodTimeUnits != null) {
                builder.append("_refreshPeriodTimeUnits=");
                builder.append(this._refreshPeriodTimeUnits);
                builder.append(", ");
            }
            if (this._refreshPeriodValue != null) {
                builder.append("_refreshPeriodValue=");
                builder.append(this._refreshPeriodValue);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

