/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.poly.secrets;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.poly.secrets.PolySecret;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.sb.pot.hop.params.rev161205.poly.secrets.PolySecretKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PolySecretBuilder
implements Builder<PolySecret> {
    private PolySecretKey _key;
    private Long _pindex;
    private Long _secret;
    private Long _secretShare;
    Map<Class<? extends Augmentation<PolySecret>>, Augmentation<PolySecret>> augmentation = Collections.emptyMap();

    public PolySecretBuilder() {
    }

    public PolySecretBuilder(PolySecret base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new PolySecretKey(base.getPindex());
            this._pindex = base.getPindex();
        } else {
            this._key = base.getKey();
            this._pindex = this._key.getPindex();
        }
        this._secret = base.getSecret();
        this._secretShare = base.getSecretShare();
        if (base instanceof PolySecretImpl) {
            PolySecretImpl impl = (PolySecretImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PolySecret>>, Augmentation<PolySecret>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PolySecret>>, Augmentation<PolySecret>>(casted.augmentations());
        }
    }

    public PolySecretKey getKey() {
        return this._key;
    }

    public Long getPindex() {
        return this._pindex;
    }

    public Long getSecret() {
        return this._secret;
    }

    public Long getSecretShare() {
        return this._secretShare;
    }

    public <E extends Augmentation<PolySecret>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PolySecretBuilder setKey(PolySecretKey value) {
        this._key = value;
        return this;
    }

    private static void checkPindexRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public PolySecretBuilder setPindex(Long value) {
        if (value != null) {
            PolySecretBuilder.checkPindexRange(value);
        }
        this._pindex = value;
        return this;
    }

    public PolySecretBuilder setSecret(Long value) {
        this._secret = value;
        return this;
    }

    public PolySecretBuilder setSecretShare(Long value) {
        this._secretShare = value;
        return this;
    }

    public PolySecretBuilder addAugmentation(Class<? extends Augmentation<PolySecret>> augmentationType, Augmentation<PolySecret> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PolySecret>>, Augmentation<PolySecret>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PolySecretBuilder removeAugmentation(Class<? extends Augmentation<PolySecret>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PolySecret build() {
        return new PolySecretImpl(this);
    }

    private static final class PolySecretImpl
    implements PolySecret {
        private final PolySecretKey _key;
        private final Long _pindex;
        private final Long _secret;
        private final Long _secretShare;
        private Map<Class<? extends Augmentation<PolySecret>>, Augmentation<PolySecret>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PolySecret> getImplementedInterface() {
            return PolySecret.class;
        }

        private PolySecretImpl(PolySecretBuilder base) {
            if (base.getKey() == null) {
                this._key = new PolySecretKey(base.getPindex());
                this._pindex = base.getPindex();
            } else {
                this._key = base.getKey();
                this._pindex = this._key.getPindex();
            }
            this._secret = base.getSecret();
            this._secretShare = base.getSecretShare();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PolySecret>>, Augmentation<PolySecret>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PolySecret>>, Augmentation<PolySecret>>(base.augmentation);
                }
            }
        }

        @Override
        public PolySecretKey getKey() {
            return this._key;
        }

        @Override
        public Long getPindex() {
            return this._pindex;
        }

        @Override
        public Long getSecret() {
            return this._secret;
        }

        @Override
        public Long getSecretShare() {
            return this._secretShare;
        }

        public <E extends Augmentation<PolySecret>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._pindex);
            result = 31 * result + Objects.hashCode(this._secret);
            result = 31 * result + Objects.hashCode(this._secretShare);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PolySecret.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PolySecret other = (PolySecret)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._pindex, other.getPindex())) {
                return false;
            }
            if (!Objects.equals(this._secret, other.getSecret())) {
                return false;
            }
            if (!Objects.equals(this._secretShare, other.getSecretShare())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PolySecretImpl otherImpl = (PolySecretImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PolySecret>>, Augmentation<PolySecret>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PolySecret [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._pindex != null) {
                builder.append("_pindex=");
                builder.append(this._pindex);
                builder.append(", ");
            }
            if (this._secret != null) {
                builder.append("_secret=");
                builder.append(this._secret);
                builder.append(", ");
            }
            if (this._secretShare != null) {
                builder.append("_secretShare=");
                builder.append(this._secretShare);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

