/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122;

import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.BitMaskOptions;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.IoamPotParams;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RefreshPeriodInterval;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RspIoamPotAugmentation;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.TimeResolution;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RspIoamPotAugmentationBuilder
implements Builder<RspIoamPotAugmentation> {
    private BitMaskOptions _ioamPotBitMask;
    private Long _ioamPotNumProfiles;
    private Class<? extends TimeResolution> _refreshPeriodTimeUnits;
    private Long _refreshPeriodValue;
    private Boolean _ioamPotEnable;

    public RspIoamPotAugmentationBuilder() {
    }

    public RspIoamPotAugmentationBuilder(IoamPotParams arg) {
        this._ioamPotEnable = arg.isIoamPotEnable();
        this._ioamPotNumProfiles = arg.getIoamPotNumProfiles();
        this._ioamPotBitMask = arg.getIoamPotBitMask();
        this._refreshPeriodTimeUnits = arg.getRefreshPeriodTimeUnits();
        this._refreshPeriodValue = arg.getRefreshPeriodValue();
    }

    public RspIoamPotAugmentationBuilder(RefreshPeriodInterval arg) {
        this._refreshPeriodTimeUnits = arg.getRefreshPeriodTimeUnits();
        this._refreshPeriodValue = arg.getRefreshPeriodValue();
    }

    public RspIoamPotAugmentationBuilder(RspIoamPotAugmentation base) {
        this._ioamPotBitMask = base.getIoamPotBitMask();
        this._ioamPotNumProfiles = base.getIoamPotNumProfiles();
        this._refreshPeriodTimeUnits = base.getRefreshPeriodTimeUnits();
        this._refreshPeriodValue = base.getRefreshPeriodValue();
        this._ioamPotEnable = base.isIoamPotEnable();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof IoamPotParams) {
            this._ioamPotEnable = ((IoamPotParams)arg).isIoamPotEnable();
            this._ioamPotNumProfiles = ((IoamPotParams)arg).getIoamPotNumProfiles();
            this._ioamPotBitMask = ((IoamPotParams)arg).getIoamPotBitMask();
            isValidArg = true;
        }
        if (arg instanceof RefreshPeriodInterval) {
            this._refreshPeriodTimeUnits = ((RefreshPeriodInterval)arg).getRefreshPeriodTimeUnits();
            this._refreshPeriodValue = ((RefreshPeriodInterval)arg).getRefreshPeriodValue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.IoamPotParams, org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RefreshPeriodInterval] \nbut was: " + arg);
        }
    }

    public BitMaskOptions getIoamPotBitMask() {
        return this._ioamPotBitMask;
    }

    public Long getIoamPotNumProfiles() {
        return this._ioamPotNumProfiles;
    }

    public Class<? extends TimeResolution> getRefreshPeriodTimeUnits() {
        return this._refreshPeriodTimeUnits;
    }

    public Long getRefreshPeriodValue() {
        return this._refreshPeriodValue;
    }

    public Boolean isIoamPotEnable() {
        return this._ioamPotEnable;
    }

    public RspIoamPotAugmentationBuilder setIoamPotBitMask(BitMaskOptions value) {
        this._ioamPotBitMask = value;
        return this;
    }

    private static void checkIoamPotNumProfilesRange(long value) {
        if (value >= 2L && value <= 16L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[2..16]].", value));
    }

    public RspIoamPotAugmentationBuilder setIoamPotNumProfiles(Long value) {
        if (value != null) {
            RspIoamPotAugmentationBuilder.checkIoamPotNumProfilesRange(value);
        }
        this._ioamPotNumProfiles = value;
        return this;
    }

    public RspIoamPotAugmentationBuilder setRefreshPeriodTimeUnits(Class<? extends TimeResolution> value) {
        this._refreshPeriodTimeUnits = value;
        return this;
    }

    private static void checkRefreshPeriodValueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public RspIoamPotAugmentationBuilder setRefreshPeriodValue(Long value) {
        if (value != null) {
            RspIoamPotAugmentationBuilder.checkRefreshPeriodValueRange(value);
        }
        this._refreshPeriodValue = value;
        return this;
    }

    public RspIoamPotAugmentationBuilder setIoamPotEnable(Boolean value) {
        this._ioamPotEnable = value;
        return this;
    }

    public RspIoamPotAugmentation build() {
        return new RspIoamPotAugmentationImpl(this);
    }

    private static final class RspIoamPotAugmentationImpl
    implements RspIoamPotAugmentation {
        private final BitMaskOptions _ioamPotBitMask;
        private final Long _ioamPotNumProfiles;
        private final Class<? extends TimeResolution> _refreshPeriodTimeUnits;
        private final Long _refreshPeriodValue;
        private final Boolean _ioamPotEnable;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RspIoamPotAugmentation> getImplementedInterface() {
            return RspIoamPotAugmentation.class;
        }

        private RspIoamPotAugmentationImpl(RspIoamPotAugmentationBuilder base) {
            this._ioamPotBitMask = base.getIoamPotBitMask();
            this._ioamPotNumProfiles = base.getIoamPotNumProfiles();
            this._refreshPeriodTimeUnits = base.getRefreshPeriodTimeUnits();
            this._refreshPeriodValue = base.getRefreshPeriodValue();
            this._ioamPotEnable = base.isIoamPotEnable();
        }

        @Override
        public BitMaskOptions getIoamPotBitMask() {
            return this._ioamPotBitMask;
        }

        @Override
        public Long getIoamPotNumProfiles() {
            return this._ioamPotNumProfiles;
        }

        @Override
        public Class<? extends TimeResolution> getRefreshPeriodTimeUnits() {
            return this._refreshPeriodTimeUnits;
        }

        @Override
        public Long getRefreshPeriodValue() {
            return this._refreshPeriodValue;
        }

        @Override
        public Boolean isIoamPotEnable() {
            return this._ioamPotEnable;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._ioamPotBitMask);
            result = 31 * result + Objects.hashCode(this._ioamPotNumProfiles);
            result = 31 * result + Objects.hashCode(this._refreshPeriodTimeUnits);
            result = 31 * result + Objects.hashCode(this._refreshPeriodValue);
            this.hash = result = 31 * result + Objects.hashCode(this._ioamPotEnable);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RspIoamPotAugmentation.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RspIoamPotAugmentation other = (RspIoamPotAugmentation)obj;
            if (!Objects.equals((Object)this._ioamPotBitMask, (Object)other.getIoamPotBitMask())) {
                return false;
            }
            if (!Objects.equals(this._ioamPotNumProfiles, other.getIoamPotNumProfiles())) {
                return false;
            }
            if (!Objects.equals(this._refreshPeriodTimeUnits, other.getRefreshPeriodTimeUnits())) {
                return false;
            }
            if (!Objects.equals(this._refreshPeriodValue, other.getRefreshPeriodValue())) {
                return false;
            }
            return Objects.equals(this._ioamPotEnable, other.isIoamPotEnable());
        }

        public String toString() {
            String name = "RspIoamPotAugmentation [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ioamPotBitMask != null) {
                builder.append("_ioamPotBitMask=");
                builder.append((Object)this._ioamPotBitMask);
                builder.append(", ");
            }
            if (this._ioamPotNumProfiles != null) {
                builder.append("_ioamPotNumProfiles=");
                builder.append(this._ioamPotNumProfiles);
                builder.append(", ");
            }
            if (this._refreshPeriodTimeUnits != null) {
                builder.append("_refreshPeriodTimeUnits=");
                builder.append(this._refreshPeriodTimeUnits);
                builder.append(", ");
            }
            if (this._refreshPeriodValue != null) {
                builder.append("_refreshPeriodValue=");
                builder.append(this._refreshPeriodValue);
                builder.append(", ");
            }
            if (this._ioamPotEnable != null) {
                builder.append("_ioamPotEnable=");
                builder.append(this._ioamPotEnable);
            }
            return builder.append(']').toString();
        }
    }
}

