/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.common.rev151017.RspName;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.BitMaskOptions;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.EnableSfcIoamPotRenderedPathInput;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.IoamPotParams;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RefreshPeriodInterval;
import org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.TimeResolution;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EnableSfcIoamPotRenderedPathInputBuilder
implements Builder<EnableSfcIoamPotRenderedPathInput> {
    private BitMaskOptions _ioamPotBitMask;
    private Long _ioamPotNumProfiles;
    private Class<? extends TimeResolution> _refreshPeriodTimeUnits;
    private Long _refreshPeriodValue;
    private RspName _sfcIoamPotRspName;
    private Boolean _ioamPotEnable;
    Map<Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>>, Augmentation<EnableSfcIoamPotRenderedPathInput>> augmentation = Collections.emptyMap();

    public EnableSfcIoamPotRenderedPathInputBuilder() {
    }

    public EnableSfcIoamPotRenderedPathInputBuilder(IoamPotParams arg) {
        this._ioamPotEnable = arg.isIoamPotEnable();
        this._ioamPotNumProfiles = arg.getIoamPotNumProfiles();
        this._ioamPotBitMask = arg.getIoamPotBitMask();
        this._refreshPeriodTimeUnits = arg.getRefreshPeriodTimeUnits();
        this._refreshPeriodValue = arg.getRefreshPeriodValue();
    }

    public EnableSfcIoamPotRenderedPathInputBuilder(RefreshPeriodInterval arg) {
        this._refreshPeriodTimeUnits = arg.getRefreshPeriodTimeUnits();
        this._refreshPeriodValue = arg.getRefreshPeriodValue();
    }

    public EnableSfcIoamPotRenderedPathInputBuilder(EnableSfcIoamPotRenderedPathInput base) {
        AugmentationHolder casted;
        this._ioamPotBitMask = base.getIoamPotBitMask();
        this._ioamPotNumProfiles = base.getIoamPotNumProfiles();
        this._refreshPeriodTimeUnits = base.getRefreshPeriodTimeUnits();
        this._refreshPeriodValue = base.getRefreshPeriodValue();
        this._sfcIoamPotRspName = base.getSfcIoamPotRspName();
        this._ioamPotEnable = base.isIoamPotEnable();
        if (base instanceof EnableSfcIoamPotRenderedPathInputImpl) {
            EnableSfcIoamPotRenderedPathInputImpl impl = (EnableSfcIoamPotRenderedPathInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>>, Augmentation<EnableSfcIoamPotRenderedPathInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>>, Augmentation<EnableSfcIoamPotRenderedPathInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof IoamPotParams) {
            this._ioamPotEnable = ((IoamPotParams)arg).isIoamPotEnable();
            this._ioamPotNumProfiles = ((IoamPotParams)arg).getIoamPotNumProfiles();
            this._ioamPotBitMask = ((IoamPotParams)arg).getIoamPotBitMask();
            isValidArg = true;
        }
        if (arg instanceof RefreshPeriodInterval) {
            this._refreshPeriodTimeUnits = ((RefreshPeriodInterval)arg).getRefreshPeriodTimeUnits();
            this._refreshPeriodValue = ((RefreshPeriodInterval)arg).getRefreshPeriodValue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.IoamPotParams, org.opendaylight.yang.gen.v1.urn.cisco.params.xml.ns.yang.sfc.ioam.nb.pot.rev161122.RefreshPeriodInterval] \nbut was: " + arg);
        }
    }

    public BitMaskOptions getIoamPotBitMask() {
        return this._ioamPotBitMask;
    }

    public Long getIoamPotNumProfiles() {
        return this._ioamPotNumProfiles;
    }

    public Class<? extends TimeResolution> getRefreshPeriodTimeUnits() {
        return this._refreshPeriodTimeUnits;
    }

    public Long getRefreshPeriodValue() {
        return this._refreshPeriodValue;
    }

    public RspName getSfcIoamPotRspName() {
        return this._sfcIoamPotRspName;
    }

    public Boolean isIoamPotEnable() {
        return this._ioamPotEnable;
    }

    public <E extends Augmentation<EnableSfcIoamPotRenderedPathInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EnableSfcIoamPotRenderedPathInputBuilder setIoamPotBitMask(BitMaskOptions value) {
        this._ioamPotBitMask = value;
        return this;
    }

    private static void checkIoamPotNumProfilesRange(long value) {
        if (value >= 2L && value <= 16L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[2..16]].", value));
    }

    public EnableSfcIoamPotRenderedPathInputBuilder setIoamPotNumProfiles(Long value) {
        if (value != null) {
            EnableSfcIoamPotRenderedPathInputBuilder.checkIoamPotNumProfilesRange(value);
        }
        this._ioamPotNumProfiles = value;
        return this;
    }

    public EnableSfcIoamPotRenderedPathInputBuilder setRefreshPeriodTimeUnits(Class<? extends TimeResolution> value) {
        this._refreshPeriodTimeUnits = value;
        return this;
    }

    private static void checkRefreshPeriodValueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public EnableSfcIoamPotRenderedPathInputBuilder setRefreshPeriodValue(Long value) {
        if (value != null) {
            EnableSfcIoamPotRenderedPathInputBuilder.checkRefreshPeriodValueRange(value);
        }
        this._refreshPeriodValue = value;
        return this;
    }

    public EnableSfcIoamPotRenderedPathInputBuilder setSfcIoamPotRspName(RspName value) {
        this._sfcIoamPotRspName = value;
        return this;
    }

    public EnableSfcIoamPotRenderedPathInputBuilder setIoamPotEnable(Boolean value) {
        this._ioamPotEnable = value;
        return this;
    }

    public EnableSfcIoamPotRenderedPathInputBuilder addAugmentation(Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>> augmentationType, Augmentation<EnableSfcIoamPotRenderedPathInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>>, Augmentation<EnableSfcIoamPotRenderedPathInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EnableSfcIoamPotRenderedPathInputBuilder removeAugmentation(Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EnableSfcIoamPotRenderedPathInput build() {
        return new EnableSfcIoamPotRenderedPathInputImpl(this);
    }

    private static final class EnableSfcIoamPotRenderedPathInputImpl
    implements EnableSfcIoamPotRenderedPathInput {
        private final BitMaskOptions _ioamPotBitMask;
        private final Long _ioamPotNumProfiles;
        private final Class<? extends TimeResolution> _refreshPeriodTimeUnits;
        private final Long _refreshPeriodValue;
        private final RspName _sfcIoamPotRspName;
        private final Boolean _ioamPotEnable;
        private Map<Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>>, Augmentation<EnableSfcIoamPotRenderedPathInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<EnableSfcIoamPotRenderedPathInput> getImplementedInterface() {
            return EnableSfcIoamPotRenderedPathInput.class;
        }

        private EnableSfcIoamPotRenderedPathInputImpl(EnableSfcIoamPotRenderedPathInputBuilder base) {
            this._ioamPotBitMask = base.getIoamPotBitMask();
            this._ioamPotNumProfiles = base.getIoamPotNumProfiles();
            this._refreshPeriodTimeUnits = base.getRefreshPeriodTimeUnits();
            this._refreshPeriodValue = base.getRefreshPeriodValue();
            this._sfcIoamPotRspName = base.getSfcIoamPotRspName();
            this._ioamPotEnable = base.isIoamPotEnable();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>>, Augmentation<EnableSfcIoamPotRenderedPathInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>>, Augmentation<EnableSfcIoamPotRenderedPathInput>>(base.augmentation);
                }
            }
        }

        @Override
        public BitMaskOptions getIoamPotBitMask() {
            return this._ioamPotBitMask;
        }

        @Override
        public Long getIoamPotNumProfiles() {
            return this._ioamPotNumProfiles;
        }

        @Override
        public Class<? extends TimeResolution> getRefreshPeriodTimeUnits() {
            return this._refreshPeriodTimeUnits;
        }

        @Override
        public Long getRefreshPeriodValue() {
            return this._refreshPeriodValue;
        }

        @Override
        public RspName getSfcIoamPotRspName() {
            return this._sfcIoamPotRspName;
        }

        @Override
        public Boolean isIoamPotEnable() {
            return this._ioamPotEnable;
        }

        public <E extends Augmentation<EnableSfcIoamPotRenderedPathInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._ioamPotBitMask);
            result = 31 * result + Objects.hashCode(this._ioamPotNumProfiles);
            result = 31 * result + Objects.hashCode(this._refreshPeriodTimeUnits);
            result = 31 * result + Objects.hashCode(this._refreshPeriodValue);
            result = 31 * result + Objects.hashCode(this._sfcIoamPotRspName);
            result = 31 * result + Objects.hashCode(this._ioamPotEnable);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EnableSfcIoamPotRenderedPathInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EnableSfcIoamPotRenderedPathInput other = (EnableSfcIoamPotRenderedPathInput)obj;
            if (!Objects.equals((Object)this._ioamPotBitMask, (Object)other.getIoamPotBitMask())) {
                return false;
            }
            if (!Objects.equals(this._ioamPotNumProfiles, other.getIoamPotNumProfiles())) {
                return false;
            }
            if (!Objects.equals(this._refreshPeriodTimeUnits, other.getRefreshPeriodTimeUnits())) {
                return false;
            }
            if (!Objects.equals(this._refreshPeriodValue, other.getRefreshPeriodValue())) {
                return false;
            }
            if (!Objects.equals(this._sfcIoamPotRspName, other.getSfcIoamPotRspName())) {
                return false;
            }
            if (!Objects.equals(this._ioamPotEnable, other.isIoamPotEnable())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EnableSfcIoamPotRenderedPathInputImpl otherImpl = (EnableSfcIoamPotRenderedPathInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EnableSfcIoamPotRenderedPathInput>>, Augmentation<EnableSfcIoamPotRenderedPathInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "EnableSfcIoamPotRenderedPathInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ioamPotBitMask != null) {
                builder.append("_ioamPotBitMask=");
                builder.append((Object)this._ioamPotBitMask);
                builder.append(", ");
            }
            if (this._ioamPotNumProfiles != null) {
                builder.append("_ioamPotNumProfiles=");
                builder.append(this._ioamPotNumProfiles);
                builder.append(", ");
            }
            if (this._refreshPeriodTimeUnits != null) {
                builder.append("_refreshPeriodTimeUnits=");
                builder.append(this._refreshPeriodTimeUnits);
                builder.append(", ");
            }
            if (this._refreshPeriodValue != null) {
                builder.append("_refreshPeriodValue=");
                builder.append(this._refreshPeriodValue);
                builder.append(", ");
            }
            if (this._sfcIoamPotRspName != null) {
                builder.append("_sfcIoamPotRspName=");
                builder.append(this._sfcIoamPotRspName);
                builder.append(", ");
            }
            if (this._ioamPotEnable != null) {
                builder.append("_ioamPotEnable=");
                builder.append(this._ioamPotEnable);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

